/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue.linear.upc;

import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.linear.LinearBarcode;
import ai.net.sourceforge.barbecue.linear.upc.ModuleFactory;
import ai.net.sourceforge.barbecue.output.LabelLayoutFactory;
import ai.net.sourceforge.barbecue.output.Output;
import ai.net.sourceforge.barbecue.output.OutputException;
import java.awt.Dimension;
import java.text.StringCharacterIterator;
import java.util.ArrayList;

public class UPCABarcode
extends LinearBarcode {
    public static final String[] TYPES = new String[]{"UPC-A", "UPCA"};
    protected boolean requiresChecksum = false;
    protected final String label;
    protected int width = 0;
    protected static final int CHECKSUM_WEIGHT_EVEN = 1;
    protected static final int CHECKSUM_WEIGHT_ODD = 3;
    public static final int BARCODE_LENGTH = 11;

    public UPCABarcode(String string) throws BarcodeException {
        this(string, false);
    }

    public UPCABarcode(String string, boolean bl) throws BarcodeException {
        super(UPCABarcode.validateChars(string));
        if (string.length() != this.getBarcodeLength()) {
            throw new BarcodeException("Invalid data length");
        }
        this.requiresChecksum = true;
        if (bl) {
            string = this.populateRandonWeightCheckDigit(string);
        }
        this.label = string;
    }

    protected int getBarcodeLength() {
        return 11;
    }

    protected Dimension draw(Output output, int n, int n2, int n3, int n4) throws OutputException {
        int n5;
        int n6;
        int n7 = n;
        output.beginDraw();
        int n8 = 0;
        int n9 = n4;
        int n10 = 10 * n3;
        if (this.drawingText) {
            n9 = n4 - 11 * n3;
            n8 = n9 + 6 * n3;
        } else {
            n9 = n4 - 6 * n3;
            n8 = n4;
        }
        String string = this.getLabel();
        int n11 = this.barHeight + n2;
        Module[] moduleArray = this.encodeData();
        String string2 = String.valueOf(string.charAt(0));
        String string3 = String.valueOf(string.charAt(string.length() - 1));
        String string4 = string.substring(1, this.getLeftWidth());
        String string5 = string.substring(this.getLeftWidth(), 11);
        if (this.requiresChecksum) {
            string3 = this.calculateChecksum().getSymbol();
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = n;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        Module module = this.getPreAmble();
        Module module2 = this.getPostAmble();
        n16 = 0;
        if (this.drawingQuietSection) {
            n7 += this.drawModule(this.getLeftMargin(), output, n7, n2, n3, n9 + n10);
        }
        n12 = n;
        n16 = n7 - n12;
        n20 = n7;
        int n21 = this.getGuardCharSize();
        int n22 = this.getLeftWidth();
        if (module != null) {
            n7 += this.drawModule(module, output, n7, n2, n3, n8);
        }
        for (n6 = 0; n6 < n21; ++n6) {
            n7 += this.drawModule(moduleArray[0], output, n7, n2, n3, n8);
        }
        n13 = n7;
        n20 = n7 - n20;
        output.paintBackground(n7 - n20, n8, n20, n9 + n10 - n8);
        for (n6 = n21; n6 < n22; ++n6) {
            n7 += this.drawModule(moduleArray[n6], output, n7, n2, n3, n9);
        }
        n17 = n7 - n13;
        n20 = n7;
        n7 += this.drawModule(this.getCentreGuard(), output, n7, n2, n3, n8);
        n14 = n7;
        n20 = n7 - n20;
        output.paintBackground(n7 - n20, n8, n20, n9 + n10 - n8);
        n6 = moduleArray.length - n21;
        for (n5 = n22; n5 < n6; ++n5) {
            n7 += this.drawModule(moduleArray[n5], output, n7, n2, n3, n9);
        }
        n18 = n7 - n14;
        n20 = n7;
        for (n5 = n6; n5 < moduleArray.length; ++n5) {
            n7 += this.drawModule(moduleArray[n5], output, n7, n2, n3, n8);
        }
        if (module2 != null) {
            n7 += this.drawModule(module2, output, n7, n2, n3, n8);
        }
        n20 = n7 - n20;
        output.paintBackground(n7 - n20, n8, n20, n9 + n10 - n8);
        n15 = n7;
        if (this.drawingQuietSection) {
            n7 += this.drawModule(this.getRightMargin(), output, n7, n2, n3, n9 + n10);
        }
        n19 = n7 - n15;
        if (this.drawingText) {
            output.drawText(string2, LabelLayoutFactory.createMarginLayout(n12, n9, n16, n10));
            output.drawText(string4, LabelLayoutFactory.createMarginLayout(n13, n9, n17, n10));
            output.drawText(string5, LabelLayoutFactory.createMarginLayout(n14, n9, n18, n10));
            output.drawText(string3, LabelLayoutFactory.createMarginLayout(n15, n9, n19, n10));
        }
        Dimension dimension = new Dimension(n7 - n, n11 - n2);
        output.endDraw((int)dimension.getWidth(), (int)dimension.getHeight());
        return dimension;
    }

    public String getLabel() {
        return this.label;
    }

    protected double getBarcodeWidth(int n) {
        this.encodeData();
        return this.barWidth * this.width;
    }

    protected Module[] encodeData() {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        Module module = null;
        int n = this.data.length();
        for (int i = 0; i < n; ++i) {
            char c = this.data.charAt(i);
            module = ModuleFactory.getModule(String.valueOf(c), i);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        if (this.requiresChecksum) {
            module = ModuleFactory.getModule(this.calculateChecksum().getSymbol(), arrayList.size() - 1);
            this.width += module.widthInBars();
            arrayList.add(module);
        }
        return arrayList.toArray(new Module[0]);
    }

    protected Module calculateChecksum() {
        if (this.requiresChecksum) {
            return ModuleFactory.getModuleForIndex(UPCABarcode.getMod10CheckDigit(this.data));
        }
        return null;
    }

    protected int getGuardCharSize() {
        return 1;
    }

    protected int getLeftWidth() {
        return 6;
    }

    protected Module getLeftMargin() {
        return ModuleFactory.LEFT_MARGIN;
    }

    protected Module getRightMargin() {
        return ModuleFactory.RIGHT_MARGIN;
    }

    protected Module getPreAmble() {
        return ModuleFactory.LEFT_GUARD;
    }

    protected Module getCentreGuard() {
        return ModuleFactory.CENTRE_GUARD;
    }

    protected Module getPostAmble() {
        return ModuleFactory.RIGHT_GUARD;
    }

    public static int getMod10CheckDigit(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        for (n = 0; n < n3; ++n) {
            try {
                int n4 = Integer.parseInt(String.valueOf(string.charAt(n)));
                n2 += UPCABarcode.calculateChecksum(n4, n % 2 == 1);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        n = 10 - n2 % 10;
        if (n == 10) {
            n = 0;
        }
        return n;
    }

    protected static int calculateChecksum(int n, boolean bl) {
        if (bl) {
            return n * 1;
        }
        return n * 3;
    }

    private static String validateChars(String string) throws BarcodeException {
        if (string == null) {
            throw new IllegalArgumentException("data param must contain a value, not null");
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (!ModuleFactory.hasModule(String.valueOf(c))) {
                throw new BarcodeException("Illegal character");
            }
            c = stringCharacterIterator.next();
        }
        return string;
    }

    private String populateRandonWeightCheckDigit(String string) {
        int[][] nArrayArray = new int[][]{{0, 2, 4, 6, 8, 9, 1, 3, 5, 7}, {0, 3, 6, 9, 2, 5, 8, 1, 4, 7}, {0, 5, 9, 4, 8, 3, 7, 2, 6, 1}};
        int n = 0;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        int n3 = Character.digit(cArray[7], 10);
        n += nArrayArray[0][n3];
        n3 = Character.digit(cArray[8], 10);
        n += nArrayArray[0][n3];
        n3 = Character.digit(cArray[9], 10);
        n += nArrayArray[1][n3];
        n3 = Character.digit(cArray[10], 10);
        n2 = (n += nArrayArray[2][n3]) % 10 == 0 ? 0 : 10 - n % 10;
        cArray[6] = String.valueOf(n2).charAt(0);
        return String.valueOf(cArray);
    }
}

