/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue;

import ai.net.sourceforge.barbecue.Barcode;
import ai.net.sourceforge.barbecue.BarcodeFactory;
import ai.net.sourceforge.barbecue.BarcodeImageHandler;
import ai.net.sourceforge.barbecue.env.DefaultEnvironment;
import ai.net.sourceforge.barbecue.output.EPSOutput;
import ai.net.sourceforge.barbecue.output.SVGOutput;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class Main {
    public static void main(String[] stringArray) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        if (stringArray.length == 0) {
            Main.Usage();
        }
        int n = 0;
        while (n < stringArray.length) {
            if (((String)(object = stringArray[n++])).equals("-b")) {
                string = stringArray[n++];
            }
            if (((String)object).equals("-e")) {
                string2 = stringArray[n++];
            }
            if (((String)object).equals("-o")) {
                string3 = stringArray[n++];
            }
            if (((String)object).equals("-E")) {
                bl = true;
            }
            if (!((String)object).equals("-label")) continue;
            string4 = stringArray[n++];
        }
        if (null == string) {
            System.err.println("Some barcode text must be specified with the -b option");
            Main.Usage();
            return;
        }
        try {
            object = null;
            if (string2.equals("ean128")) {
                object = BarcodeFactory.parseEAN128(string);
            } else if (string2.equals("code128")) {
                object = BarcodeFactory.createCode128(string);
            } else if (string2.equals("upca")) {
                object = BarcodeFactory.createUPCA(string);
            } else if (string2.equals("codabar")) {
                object = BarcodeFactory.createCodabar(string);
            } else if (string2.equals("ean13")) {
                object = BarcodeFactory.createEAN13(string);
            } else {
                System.err.println("Unknown encoding: " + string2);
            }
            if (null == object) {
                return;
            }
            OutputStream outputStream = null;
            outputStream = null != string3 ? new FileOutputStream(string3) : System.out;
            if (bl) {
                Main.outputEPS((Barcode)object, outputStream);
            } else {
                Main.outputPNG((Barcode)object, outputStream);
            }
            if (null != string4) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(string4));
                outputStreamWriter.write(((Barcode)object).getLabel());
                outputStreamWriter.flush();
                outputStreamWriter.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void Usage() {
        System.err.println("Barbecue Barcode generator");
        System.err.println("Usage:");
        System.err.println("java -jar barbecue.jar -b <barcode text> -e <encoding> -o <outfile> {-E}");
        System.err.println("\tAvailable Encodings are:");
        System.err.println("\t\t \"ean128\"");
        System.err.println("\t-E: Write output as EPS.");
        System.err.println("\t-label <filename>: Write human readable (including check digit) text to the file.");
        System.err.println("\t-o <filename>: Write the barcode image to the file.");
        System.err.println("Example:\n\tjava -jar barbecue.jar -E -e ean128 -o test.eps\\ \n\t\t-label test_label.txt  -b \"(01)0941919600001(10)012004(21)000123\"");
    }

    public static void outputPNG(Barcode barcode, OutputStream outputStream) {
        try {
            BarcodeImageHandler.writePNG(barcode, outputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void outputSVG(Barcode barcode, OutputStream outputStream) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            SVGOutput sVGOutput = new SVGOutput(outputStreamWriter, DefaultEnvironment.DEFAULT_FONT, Color.black, Color.white, 1.0, "in");
            barcode.output(sVGOutput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void outputEPS(Barcode barcode, OutputStream outputStream) {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            EPSOutput ePSOutput = new EPSOutput(outputStreamWriter);
            barcode.output(ePSOutput);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

