/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue;

import ai.net.sourceforge.barbecue.Barcode;
import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.BarcodeFactory;
import ai.net.sourceforge.barbecue.BarcodeImageHandler;
import ai.net.sourceforge.barbecue.env.EnvironmentFactory;
import ai.net.sourceforge.barbecue.linear.code39.Code39Barcode;
import ai.net.sourceforge.barbecue.output.OutputException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BarcodeServlet
extends HttpServlet {
    public String getServletName() {
        return "barbecue";
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        this.doRequest(httpServletRequest, httpServletResponse);
    }

    private void doRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        String string = this.getRequiredParameter(httpServletRequest, "data");
        String string2 = this.getParameter(httpServletRequest, "type");
        String string3 = this.getParameter(httpServletRequest, "appid");
        Integer n = this.getParameterAsInteger(httpServletRequest, "width");
        Integer n2 = this.getParameterAsInteger(httpServletRequest, "height");
        Integer n3 = this.getParameterAsInteger(httpServletRequest, "resolution");
        boolean bl = this.getParameterAsBoolean(httpServletRequest, "checksum", false);
        boolean bl2 = this.getParameterAsBoolean(httpServletRequest, "headless", true);
        boolean bl3 = false;
        if (bl2) {
            EnvironmentFactory.setHeadlessMode();
        } else {
            bl3 = this.getParameterAsBoolean(httpServletRequest, "drawText", false);
        }
        Barcode barcode = this.getBarcode(string2, string, string3, bl);
        barcode.setDrawingText(bl3);
        if (n != null) {
            barcode.setBarWidth(n);
        }
        if (n2 != null) {
            barcode.setBarHeight(n2);
        }
        if (n3 != null) {
            barcode.setResolution(n3);
        }
        try {
            this.outputBarcodeImage(httpServletResponse, barcode);
        }
        catch (IOException iOException) {
            throw new ServletException("Could not output barcode", (Throwable)iOException);
        }
        catch (OutputException outputException) {
            throw new ServletException("Could not output barcode", (Throwable)outputException);
        }
    }

    private String getRequiredParameter(HttpServletRequest httpServletRequest, String string) throws ServletException {
        String string2 = this.getParameter(httpServletRequest, string);
        if (string2 == null) {
            throw new ServletException("Parameter " + string + " is required");
        }
        return string2;
    }

    private boolean getParameterAsBoolean(HttpServletRequest httpServletRequest, String string, boolean bl) {
        String string2 = this.getParameter(httpServletRequest, string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    private Integer getParameterAsInteger(HttpServletRequest httpServletRequest, String string) {
        String string2 = this.getParameter(httpServletRequest, string);
        if (string2 == null) {
            return null;
        }
        return new Integer(string2);
    }

    private String getParameter(HttpServletRequest httpServletRequest, String string) {
        return httpServletRequest.getParameter(string);
    }

    protected Barcode getBarcode(String string, String string2, String string3, boolean bl) throws ServletException {
        if (string == null || string.length() == 0) {
            try {
                return BarcodeFactory.createCode128B(string2);
            }
            catch (BarcodeException barcodeException) {
                throw new ServletException("BARCODE ERROR", (Throwable)barcodeException);
            }
        }
        if (this.isType(string, new String[]{"UCC128"})) {
            if (string3 == null) {
                throw new ServletException("UCC128 barcode type requires the appid parameter");
            }
            try {
                return BarcodeFactory.createUCC128(string3, string2);
            }
            catch (BarcodeException barcodeException) {
                throw new ServletException("BARCODE ERROR", (Throwable)barcodeException);
            }
        }
        if (this.isType(string, Code39Barcode.TYPES)) {
            try {
                return BarcodeFactory.createCode39(string2, bl);
            }
            catch (BarcodeException barcodeException) {
                throw new ServletException("BARCODE ERROR", (Throwable)barcodeException);
            }
        }
        try {
            return (Barcode)this.getMethod(string).invoke(null, string2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ServletException("Invalid barcode type: " + string);
        }
        catch (SecurityException securityException) {
            throw new ServletException("Could not create barcode of type: " + string + "; Security exception accessing BarcodeFactory");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServletException("Could not create barcode of type: " + string + "; Illegal access to BarcodeFactory");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ServletException("Could not create barcode of type: " + string + "; Could not invoke BarcodeFactory");
        }
    }

    private boolean isType(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private Method getMethod(String string) throws NoSuchMethodException {
        Method[] methodArray = BarcodeFactory.class.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (method.getParameterTypes().length != 1 || !this.matches(method, string)) continue;
            return method;
        }
        throw new NoSuchMethodException();
    }

    private boolean matches(Method method, String string) {
        return method.getName().startsWith("create") && method.getName().substring(6).equalsIgnoreCase(string);
    }

    private void outputBarcodeImage(HttpServletResponse httpServletResponse, Barcode barcode) throws IOException, OutputException {
        httpServletResponse.setContentType("image/png");
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        BarcodeImageHandler.writePNG(barcode, (OutputStream)servletOutputStream);
        servletOutputStream.flush();
        servletOutputStream.close();
    }
}

