/*
 * Decompiled with CFR 0.152.
 */
package ai.net.sourceforge.barbecue;

import ai.net.sourceforge.barbecue.BarcodeException;
import ai.net.sourceforge.barbecue.Module;
import ai.net.sourceforge.barbecue.env.EnvironmentFactory;
import ai.net.sourceforge.barbecue.env.HeadlessEnvironment;
import ai.net.sourceforge.barbecue.output.GraphicsOutput;
import ai.net.sourceforge.barbecue.output.Output;
import ai.net.sourceforge.barbecue.output.OutputException;
import ai.net.sourceforge.barbecue.output.SizingOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.text.StringCharacterIterator;
import javax.swing.JComponent;

public abstract class Barcode
extends JComponent
implements Printable {
    private static final int DEFAULT_BAR_HEIGHT = 50;
    protected String data;
    protected String label;
    protected boolean drawingText;
    protected boolean drawingQuietSection = true;
    protected int barWidth = 2;
    protected int barHeight;
    private Font font;
    private Dimension size;
    private int x;
    private int y;
    private int resolution = -1;

    protected Barcode(String string) throws BarcodeException {
        if (string == null || string.length() == 0) {
            throw new BarcodeException("Data to encode cannot be empty");
        }
        this.data = string;
        int n = this.calculateMinimumBarHeight(this.getResolution());
        this.barHeight = n > 0 ? n : 50;
        this.font = EnvironmentFactory.getEnvironment().getDefaultFont();
        this.drawingText = true;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.invalidateSize();
    }

    public String getData() {
        return this.data;
    }

    public void setFont(Font font) {
        this.font = font;
        this.invalidateSize();
    }

    public void setDrawingText(boolean bl) {
        this.drawingText = bl;
        this.invalidateSize();
    }

    public boolean isDrawingText() {
        return this.drawingText;
    }

    public void setDrawingQuietSection(boolean bl) {
        this.drawingQuietSection = bl;
        this.invalidateSize();
    }

    public boolean isDrawingQuietSection() {
        return this.drawingQuietSection;
    }

    public void setBarWidth(int n) {
        this.barWidth = n >= 1 ? n : 1;
        this.invalidateSize();
    }

    public void setBarHeight(int n) {
        if (n > this.calculateMinimumBarHeight(this.getResolution())) {
            this.barHeight = n;
            this.invalidateSize();
        }
    }

    public void setResolution(int n) {
        if (n > 0) {
            this.resolution = n;
            int n2 = this.calculateMinimumBarHeight(this.getResolution());
            if (n2 > this.barHeight) {
                this.barHeight = n2;
            }
            this.invalidateSize();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return (int)this.getActualSize().getWidth();
    }

    public int getHeight() {
        return (int)this.getActualSize().getHeight();
    }

    public Rectangle getBounds() {
        return this.getBounds(new Rectangle());
    }

    public Rectangle getBounds(Rectangle rectangle) {
        rectangle.setBounds(this.getX(), this.getY(), (int)this.getActualSize().getWidth() + this.getX(), (int)this.getActualSize().getHeight() + this.getY());
        return rectangle;
    }

    public Dimension getPreferredSize() {
        return this.getActualSize();
    }

    public Dimension getMinimumSize() {
        return this.getActualSize();
    }

    public Dimension getMaximumSize() {
        return this.getActualSize();
    }

    public Dimension getSize() {
        return this.getActualSize();
    }

    public void draw(Graphics2D graphics2D, int n, int n2) throws OutputException {
        this.x = n;
        this.y = n2;
        GraphicsOutput graphicsOutput = new GraphicsOutput(graphics2D, this.font, this.getForeground(), this.getBackground());
        this.size = this.draw(graphicsOutput, n, n2, this.barWidth, this.barHeight);
    }

    public void output(Output output) throws OutputException {
        this.draw(output, 0, 0, this.barWidth, this.barHeight);
    }

    protected abstract Module[] encodeData();

    protected abstract Module calculateChecksum();

    protected abstract Module getPreAmble();

    protected abstract Module getPostAmble();

    protected abstract Dimension draw(Output var1, int var2, int var3, int var4, int var5) throws OutputException;

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.beautify(this.data);
    }

    public void setLabel(String string) {
        this.label = string;
    }

    protected int calculateMinimumBarHeight(int n) {
        return 0;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        try {
            this.draw((Graphics2D)graphics, insets.left, insets.top);
        }
        catch (OutputException outputException) {
            // empty catch block
        }
    }

    protected int getResolution() {
        if (this.resolution > 0) {
            return this.resolution;
        }
        return EnvironmentFactory.getEnvironment().getResolution();
    }

    protected int drawModule(Module module, Output output, int n, int n2, int n3, int n4) throws OutputException {
        if (module == null) {
            return 0;
        }
        return module.draw(output, n, n2, n3, n4);
    }

    protected String beautify(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.first();
        while (c != '\uffff') {
            if (Character.isDefined(c) && !Character.isISOControl(c)) {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private void invalidateSize() {
        this.size = null;
    }

    private Dimension getActualSize() {
        if (this.size == null) {
            this.size = this.calculateSize();
        }
        return this.size;
    }

    private Dimension calculateSize() {
        Dimension dimension = new Dimension();
        if (EnvironmentFactory.getEnvironment() instanceof HeadlessEnvironment) {
            try {
                dimension = this.draw(new SizingOutput(this.font, this.getForeground(), this.getBackground()), 0, 0, this.barWidth, this.barHeight);
            }
            catch (OutputException outputException) {}
        } else {
            try {
                FontMetrics fontMetrics = null;
                if (this.font != null) {
                    fontMetrics = this.getFontMetrics(this.font);
                }
                dimension = this.draw(new SizingOutput(this.font, fontMetrics, this.getForeground(), this.getBackground()), 0, 0, this.barWidth, this.barHeight);
            }
            catch (OutputException outputException) {
                // empty catch block
            }
        }
        return dimension;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        try {
            this.draw((Graphics2D)graphics, 0, 0);
            return 0;
        }
        catch (OutputException outputException) {
            throw new PrinterException(outputException.getMessage());
        }
    }

    public String toString() {
        return this.getData();
    }
}

