/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public final class Output {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Writer writer_;
    private StringBuffer currentIndent_;
    private boolean afterNewLine_;
    private final String indent_;

    public Output(Writer writer, String string) {
        this.writer_ = new BufferedWriter(writer);
        this.indent_ = string;
        this.currentIndent_ = new StringBuffer();
    }

    public Output print(char c) throws IOException {
        this.writeIndentIfNeeded();
        this.writer_.write(c);
        return this;
    }

    public Output print(String string) throws IOException {
        if (null != string) {
            this.writeIndentIfNeeded();
            this.writer_.write(string);
        }
        return this;
    }

    public Output println(String string) throws IOException {
        this.writeIndentIfNeeded();
        this.writer_.write(string);
        this.writer_.write(NEW_LINE);
        this.afterNewLine_ = true;
        return this;
    }

    public Output println() throws IOException {
        this.writer_.write(NEW_LINE);
        this.afterNewLine_ = true;
        return this;
    }

    public Output flush() throws IOException {
        this.writer_.flush();
        return this;
    }

    public Output indent() {
        this.currentIndent_.append(this.indent_);
        return this;
    }

    public Output unindent() {
        this.currentIndent_.setLength(Math.max(0, this.currentIndent_.length() - this.indent_.length()));
        return this;
    }

    private void writeIndentIfNeeded() throws IOException {
        if (this.afterNewLine_) {
            this.writer_.write(this.currentIndent_.toString());
            this.afterNewLine_ = false;
        }
    }
}

