/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSUnknownRule;

public class CSSUnknownRuleImpl
extends AbstractCSSRuleImpl
implements CSSUnknownRule {
    private static final long serialVersionUID = -268104019127675990L;
    private String text_;

    public String getText() {
        return this.text_;
    }

    public void setText(String string) {
        this.text_ = string;
    }

    public CSSUnknownRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, String string) {
        super(cSSStyleSheetImpl, cSSRule);
        this.text_ = string;
    }

    public CSSUnknownRuleImpl() {
    }

    public short getType() {
        return 0;
    }

    public String getCssText(CSSFormat cSSFormat) {
        if (null == this.text_) {
            return "";
        }
        return this.text_;
    }

    public void setCssText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 0) {
                throw new DOMExceptionImpl(13, 8);
            }
            this.text_ = ((CSSUnknownRuleImpl)cSSRule).text_;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public String toString() {
        return this.getCssText(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSUnknownRule)) {
            return false;
        }
        CSSUnknownRule cSSUnknownRule = (CSSUnknownRule)object;
        return super.equals(object) && LangUtils.equals(this.getCssText(), cSSUnknownRule.getCssText());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.text_);
        return n;
    }
}

