/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSMediaRuleImpl;
import ai.com.steadystate.css.dom.CSSRuleListImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.dom.MediaListImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.format.CSSFormatable;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.com.steadystate.css.util.ThrowCssExceptionErrorHandler;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import ai.org.w3c.css.sac.SACMediaList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;
import org.w3c.dom.stylesheets.StyleSheet;

public class CSSStyleSheetImpl
implements CSSStyleSheet,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -2300541300646796363L;
    private boolean disabled_;
    private Node ownerNode_;
    private StyleSheet parentStyleSheet_;
    private String href_;
    private String title_;
    private MediaList media_;
    private CSSRule ownerRule_;
    private boolean readOnly_;
    private CSSRuleList cssRules_;
    private String baseUri_;

    public void setMedia(MediaList mediaList) {
        this.media_ = mediaList;
    }

    private String getBaseUri() {
        return this.baseUri_;
    }

    public void setBaseUri(String string) {
        this.baseUri_ = string;
    }

    public String getType() {
        return "text/css";
    }

    public boolean getDisabled() {
        return this.disabled_;
    }

    public void setDisabled(boolean bl) {
        this.disabled_ = bl;
    }

    public Node getOwnerNode() {
        return this.ownerNode_;
    }

    public StyleSheet getParentStyleSheet() {
        return this.parentStyleSheet_;
    }

    public String getHref() {
        return this.href_;
    }

    public String getTitle() {
        return this.title_;
    }

    public MediaList getMedia() {
        return this.media_;
    }

    public CSSRule getOwnerRule() {
        return this.ownerRule_;
    }

    public CSSRuleList getCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleListImpl();
        }
        return this.cssRules_;
    }

    public int insertRule(String string, int n) throws DOMException {
        if (this.readOnly_) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            cSSOMParser.setParentStyleSheet(this);
            cSSOMParser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule == null) {
                throw new DOMExceptionImpl(12, 0, "Parsing rule '" + string + "' failed.");
            }
            if (this.getCssRules().getLength() > 0) {
                int n2 = -1;
                if (cSSRule.getType() == 2) {
                    if (n != 0) {
                        n2 = 15;
                    } else if (this.getCssRules().item(0).getType() == 2) {
                        n2 = 16;
                    }
                } else if (cSSRule.getType() == 3) {
                    if (n <= this.getCssRules().getLength()) {
                        for (int i = 0; i < n; ++i) {
                            short s = this.getCssRules().item(i).getType();
                            if (s == 2 || s == 3) continue;
                            n2 = 17;
                            break;
                        }
                    }
                } else if (n <= this.getCssRules().getLength()) {
                    for (int i = n; i < this.getCssRules().getLength(); ++i) {
                        short s = this.getCssRules().item(i).getType();
                        if (s != 2 && s != 3) continue;
                        n2 = 20;
                        break;
                    }
                }
                if (n2 > -1) {
                    throw new DOMExceptionImpl(3, n2);
                }
            }
            ((CSSRuleListImpl)this.getCssRules()).insert(cSSRule, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, 1, indexOutOfBoundsException.getMessage());
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
        return n;
    }

    public void deleteRule(int n) throws DOMException {
        if (this.readOnly_) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, 1, indexOutOfBoundsException.getMessage());
        }
    }

    public boolean isReadOnly() {
        return this.readOnly_;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly_ = bl;
    }

    public void setOwnerNode(Node node) {
        this.ownerNode_ = node;
    }

    public void setParentStyleSheet(StyleSheet styleSheet) {
        this.parentStyleSheet_ = styleSheet;
    }

    public void setHref(String string) {
        this.href_ = string;
    }

    public void setTitle(String string) {
        this.title_ = string;
    }

    public void setMediaText(String string) {
        InputSource inputSource = new InputSource(new StringReader(string));
        try {
            CSSOMParser cSSOMParser = new CSSOMParser();
            SACMediaList sACMediaList = cSSOMParser.parseMedia(inputSource);
            this.media_ = new MediaListImpl(sACMediaList);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setOwnerRule(CSSRule cSSRule) {
        this.ownerRule_ = cSSRule;
    }

    public void setCssRules(CSSRuleList cSSRuleList) {
        this.cssRules_ = cSSRuleList;
    }

    public String getCssText() {
        return this.getCssText(null);
    }

    public String getCssText(CSSFormat cSSFormat) {
        CSSRuleList cSSRuleList = this.getCssRules();
        if (cSSRuleList instanceof CSSFormatable) {
            return ((CSSRuleListImpl)cSSRuleList).getCssText(cSSFormat);
        }
        return this.getCssRules().toString();
    }

    public String toString() {
        return this.getCssText(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSStyleSheet)) {
            return false;
        }
        CSSStyleSheet cSSStyleSheet = (CSSStyleSheet)object;
        boolean bl = LangUtils.equals(this.getCssRules(), cSSStyleSheet.getCssRules());
        bl = bl && this.getDisabled() == cSSStyleSheet.getDisabled();
        bl = bl && LangUtils.equals(this.getHref(), cSSStyleSheet.getHref());
        bl = bl && LangUtils.equals(this.getMedia(), cSSStyleSheet.getMedia());
        bl = bl && LangUtils.equals(this.getTitle(), cSSStyleSheet.getTitle());
        return bl;
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.baseUri_);
        n = LangUtils.hashCode(n, this.cssRules_);
        n = LangUtils.hashCode(n, this.disabled_);
        n = LangUtils.hashCode(n, this.href_);
        n = LangUtils.hashCode(n, this.media_);
        n = LangUtils.hashCode(n, this.ownerNode_);
        n = LangUtils.hashCode(n, this.readOnly_);
        n = LangUtils.hashCode(n, this.title_);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.baseUri_);
        objectOutputStream.writeObject(this.cssRules_);
        objectOutputStream.writeBoolean(this.disabled_);
        objectOutputStream.writeObject(this.href_);
        objectOutputStream.writeObject(this.media_);
        objectOutputStream.writeBoolean(this.readOnly_);
        objectOutputStream.writeObject(this.title_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.baseUri_ = (String)objectInputStream.readObject();
        this.cssRules_ = (CSSRuleList)objectInputStream.readObject();
        if (this.cssRules_ != null) {
            for (int i = 0; i < this.cssRules_.getLength(); ++i) {
                CSSRule cSSRule = this.cssRules_.item(i);
                if (!(cSSRule instanceof AbstractCSSRuleImpl)) continue;
                ((AbstractCSSRuleImpl)((Object)cSSRule)).setParentStyleSheet(this);
            }
        }
        this.disabled_ = objectInputStream.readBoolean();
        this.href_ = (String)objectInputStream.readObject();
        this.media_ = (MediaList)objectInputStream.readObject();
        this.readOnly_ = objectInputStream.readBoolean();
        this.title_ = (String)objectInputStream.readObject();
    }

    public void importImports(boolean bl) throws DOMException {
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            CSSRule cSSRule = this.getCssRules().item(i);
            if (cSSRule.getType() != 3) continue;
            CSSImportRule cSSImportRule = (CSSImportRule)cSSRule;
            try {
                MediaList mediaList;
                URI uRI = new URI(this.getBaseUri()).resolve(cSSImportRule.getHref());
                CSSStyleSheetImpl cSSStyleSheetImpl = (CSSStyleSheetImpl)new CSSOMParser().parseStyleSheet(new InputSource(uRI.toString()), null, uRI.toString());
                if (bl) {
                    cSSStyleSheetImpl.importImports(bl);
                }
                if ((mediaList = cSSImportRule.getMedia()).getLength() == 0) {
                    mediaList.appendMedium("all");
                }
                CSSMediaRuleImpl cSSMediaRuleImpl = new CSSMediaRuleImpl(this, null, mediaList);
                cSSMediaRuleImpl.setRuleList((CSSRuleListImpl)cSSStyleSheetImpl.getCssRules());
                this.deleteRule(i);
                ((CSSRuleListImpl)this.getCssRules()).insert(cSSMediaRuleImpl, i);
                continue;
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new DOMException(12, uRISyntaxException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

