/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.format.CSSFormatable;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import ai.org.w3c.css.sac.SelectorList;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;

public class CSSStyleRuleImpl
extends AbstractCSSRuleImpl
implements CSSStyleRule {
    private static final long serialVersionUID = -697009251364657426L;
    private SelectorList selectors_;
    private CSSStyleDeclaration style_;

    public SelectorList getSelectors() {
        return this.selectors_;
    }

    public void setSelectors(SelectorList selectorList) {
        this.selectors_ = selectorList;
    }

    public CSSStyleRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, SelectorList selectorList) {
        super(cSSStyleSheetImpl, cSSRule);
        this.selectors_ = selectorList;
    }

    public CSSStyleRuleImpl() {
    }

    public short getType() {
        return 1;
    }

    public String getCssText(CSSFormat cSSFormat) {
        CSSStyleDeclaration cSSStyleDeclaration = this.getStyle();
        if (null == cSSStyleDeclaration) {
            return "";
        }
        String string = ((CSSFormatable)((Object)this.selectors_)).getCssText(cSSFormat);
        String string2 = ((CSSFormatable)((Object)cSSStyleDeclaration)).getCssText(cSSFormat);
        if (null == string2 || string2.length() == 0) {
            return string + " { }";
        }
        if (cSSFormat != null && cSSFormat.getPropertiesInSeparateLines()) {
            return string + " {" + string2 + "}";
        }
        return string + " { " + string2 + " }";
    }

    public void setCssText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 1) {
                throw new DOMExceptionImpl(13, 4);
            }
            this.selectors_ = ((CSSStyleRuleImpl)cSSRule).selectors_;
            this.style_ = ((CSSStyleRuleImpl)cSSRule).style_;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public String getSelectorText() {
        return this.selectors_.toString();
    }

    public void setSelectorText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            this.selectors_ = cSSOMParser.parseSelectors(inputSource);
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public CSSStyleDeclaration getStyle() {
        return this.style_;
    }

    public void setStyle(CSSStyleDeclaration cSSStyleDeclaration) {
        this.style_ = cSSStyleDeclaration;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSStyleRule)) {
            return false;
        }
        CSSStyleRule cSSStyleRule = (CSSStyleRule)object;
        return super.equals(object) && LangUtils.equals(this.getSelectorText(), cSSStyleRule.getSelectorText()) && LangUtils.equals(this.getStyle(), cSSStyleRule.getStyle());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.selectors_);
        n = LangUtils.hashCode(n, this.style_);
        return n;
    }
}

