/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.format.CSSFormatable;
import ai.com.steadystate.css.util.LangUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSRuleListImpl
implements CSSRuleList,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -1269068897476453290L;
    private List<CSSRule> rules_;

    public List<CSSRule> getRules() {
        if (this.rules_ == null) {
            this.rules_ = new ArrayList<CSSRule>();
        }
        return this.rules_;
    }

    public void setRules(List<CSSRule> list) {
        this.rules_ = list;
    }

    @Override
    public int getLength() {
        return this.getRules().size();
    }

    @Override
    public CSSRule item(int n) {
        if (n < 0 || null == this.rules_ || n >= this.rules_.size()) {
            return null;
        }
        return this.rules_.get(n);
    }

    public void add(CSSRule cSSRule) {
        this.getRules().add(cSSRule);
    }

    public void insert(CSSRule cSSRule, int n) {
        this.getRules().add(n, cSSRule);
    }

    public void delete(int n) {
        this.getRules().remove(n);
    }

    public String getCssText() {
        return this.getCssText(null);
    }

    @Override
    public String getCssText(CSSFormat cSSFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.getLength(); ++i) {
            if (i > 0) {
                stringBuilder.append("\r\n");
            }
            CSSRule cSSRule = this.item(i);
            stringBuilder.append(((CSSFormatable)((Object)cSSRule)).getCssText(cSSFormat));
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.getCssText(null);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSRuleList)) {
            return false;
        }
        CSSRuleList cSSRuleList = (CSSRuleList)object;
        return this.equalsRules(cSSRuleList);
    }

    private boolean equalsRules(CSSRuleList cSSRuleList) {
        if (cSSRuleList == null || this.getLength() != cSSRuleList.getLength()) {
            return false;
        }
        for (int i = 0; i < this.getLength(); ++i) {
            CSSRule cSSRule;
            CSSRule cSSRule2 = this.item(i);
            if (LangUtils.equals(cSSRule2, cSSRule = cSSRuleList.item(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.rules_);
        return n;
    }
}

