/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSRuleListImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.dom.MediaListImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.com.steadystate.css.util.ThrowCssExceptionErrorHandler;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.stylesheets.MediaList;

public class CSSMediaRuleImpl
extends AbstractCSSRuleImpl
implements CSSMediaRule {
    private static final long serialVersionUID = 6603734096445214651L;
    private MediaList media_;
    private CSSRuleList cssRules_;

    public void setMedia(MediaList mediaList) {
        this.media_ = mediaList;
    }

    public void setCssRules(CSSRuleList cSSRuleList) {
        this.cssRules_ = cSSRuleList;
    }

    public CSSMediaRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, MediaList mediaList) {
        super(cSSStyleSheetImpl, cSSRule);
        this.media_ = mediaList;
    }

    public CSSMediaRuleImpl() {
    }

    public short getType() {
        return 4;
    }

    public String getCssText(CSSFormat cSSFormat) {
        StringBuilder stringBuilder = new StringBuilder("@media ");
        stringBuilder.append(((MediaListImpl)this.getMedia()).getMediaText(cSSFormat));
        stringBuilder.append(" {");
        for (int i = 0; i < this.getCssRules().getLength(); ++i) {
            CSSRule cSSRule = this.getCssRules().item(i);
            stringBuilder.append(cSSRule.getCssText()).append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public void setCssText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 4) {
                throw new DOMExceptionImpl(13, 7);
            }
            this.media_ = ((CSSMediaRuleImpl)cSSRule).media_;
            this.cssRules_ = ((CSSMediaRuleImpl)cSSRule).cssRules_;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public MediaList getMedia() {
        return this.media_;
    }

    public CSSRuleList getCssRules() {
        if (this.cssRules_ == null) {
            this.cssRules_ = new CSSRuleListImpl();
        }
        return this.cssRules_;
    }

    public int insertRule(String string, int n) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            cSSOMParser.setParentStyleSheet(cSSStyleSheetImpl);
            cSSOMParser.setErrorHandler(ThrowCssExceptionErrorHandler.INSTANCE);
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            ((CSSRuleListImpl)this.getCssRules()).insert(cSSRule, n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, 1, indexOutOfBoundsException.getMessage());
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
        return n;
    }

    public void deleteRule(int n) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            ((CSSRuleListImpl)this.getCssRules()).delete(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DOMExceptionImpl(1, 1, indexOutOfBoundsException.getMessage());
        }
    }

    public void setRuleList(CSSRuleListImpl cSSRuleListImpl) {
        this.cssRules_ = cSSRuleListImpl;
    }

    public String toString() {
        return this.getCssText();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSMediaRule)) {
            return false;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)object;
        return super.equals(object) && LangUtils.equals(this.getMedia(), cSSMediaRule.getMedia()) && LangUtils.equals(this.getCssRules(), cSSMediaRule.getCssRules());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.media_);
        n = LangUtils.hashCode(n, this.cssRules_);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.cssRules_);
        objectOutputStream.writeObject(this.media_);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.cssRules_ = (CSSRuleList)objectInputStream.readObject();
        if (this.cssRules_ != null) {
            for (int i = 0; i < this.cssRules_.getLength(); ++i) {
                CSSRule cSSRule = this.cssRules_.item(i);
                if (!(cSSRule instanceof AbstractCSSRuleImpl)) continue;
                ((AbstractCSSRuleImpl)((Object)cSSRule)).setParentRule(this);
                ((AbstractCSSRuleImpl)((Object)cSSRule)).setParentStyleSheet(this.getParentStyleSheetImpl());
            }
        }
        this.media_ = (MediaList)objectInputStream.readObject();
    }
}

