/*
 * Decompiled with CFR 0.152.
 */
package ai.com.steadystate.css.dom;

import ai.com.steadystate.css.dom.AbstractCSSRuleImpl;
import ai.com.steadystate.css.dom.CSSStyleSheetImpl;
import ai.com.steadystate.css.dom.DOMExceptionImpl;
import ai.com.steadystate.css.format.CSSFormat;
import ai.com.steadystate.css.parser.CSSOMParser;
import ai.com.steadystate.css.util.LangUtils;
import ai.org.w3c.css.sac.CSSException;
import ai.org.w3c.css.sac.InputSource;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSCharsetRule;
import org.w3c.dom.css.CSSRule;

public class CSSCharsetRuleImpl
extends AbstractCSSRuleImpl
implements CSSCharsetRule {
    private static final long serialVersionUID = -2472209213089007127L;
    private String encoding_;

    public CSSCharsetRuleImpl(CSSStyleSheetImpl cSSStyleSheetImpl, CSSRule cSSRule, String string) {
        super(cSSStyleSheetImpl, cSSRule);
        this.encoding_ = string;
    }

    public CSSCharsetRuleImpl() {
    }

    public short getType() {
        return 2;
    }

    public String getCssText(CSSFormat cSSFormat) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@charset \"");
        String string = this.getEncoding();
        if (null != string) {
            stringBuilder.append(string);
        }
        stringBuilder.append("\";");
        return stringBuilder.toString();
    }

    public void setCssText(String string) throws DOMException {
        CSSStyleSheetImpl cSSStyleSheetImpl = this.getParentStyleSheetImpl();
        if (cSSStyleSheetImpl != null && cSSStyleSheetImpl.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource inputSource = new InputSource(new StringReader(string));
            CSSOMParser cSSOMParser = new CSSOMParser();
            CSSRule cSSRule = cSSOMParser.parseRule(inputSource);
            if (cSSRule.getType() != 2) {
                throw new DOMExceptionImpl(13, 5);
            }
            this.encoding_ = ((CSSCharsetRuleImpl)cSSRule).encoding_;
        }
        catch (CSSException cSSException) {
            throw new DOMExceptionImpl(12, 0, cSSException.getMessage());
        }
        catch (IOException iOException) {
            throw new DOMExceptionImpl(12, 0, iOException.getMessage());
        }
    }

    public String getEncoding() {
        return this.encoding_;
    }

    public void setEncoding(String string) throws DOMException {
        this.encoding_ = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CSSCharsetRule)) {
            return false;
        }
        CSSCharsetRule cSSCharsetRule = (CSSCharsetRule)object;
        return super.equals(object) && LangUtils.equals(this.getEncoding(), cSSCharsetRule.getEncoding());
    }

    public int hashCode() {
        int n = super.hashCode();
        n = LangUtils.hashCode(n, this.encoding_);
        return n;
    }

    public String toString() {
        return this.getCssText(null);
    }
}

