/*
 * Decompiled with CFR 0.152.
 */
package ai.com.lowagie.text.xml.xmp;

import ai.com.lowagie.text.pdf.PdfDate;
import ai.com.lowagie.text.pdf.PdfDictionary;
import ai.com.lowagie.text.pdf.PdfName;
import ai.com.lowagie.text.pdf.PdfObject;
import ai.com.lowagie.text.pdf.PdfString;
import ai.com.lowagie.text.xml.xmp.DublinCoreSchema;
import ai.com.lowagie.text.xml.xmp.PdfA1Schema;
import ai.com.lowagie.text.xml.xmp.PdfSchema;
import ai.com.lowagie.text.xml.xmp.XmpBasicSchema;
import ai.com.lowagie.text.xml.xmp.XmpSchema;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;

public class XmpWriter {
    public static final String UTF8 = "UTF-8";
    public static final String UTF16 = "UTF-16";
    public static final String UTF16BE = "UTF-16BE";
    public static final String UTF16LE = "UTF-16LE";
    public static final String EXTRASPACE = "                                                                                                   \n";
    protected int extraSpace;
    protected OutputStreamWriter writer;
    protected String about;
    public static final String XPACKET_PI_BEGIN = "<?xpacket begin=\"\ufeff\" id=\"W5M0MpCehiHzreSzNTczkc9d\"?>\n";
    public static final String XPACKET_PI_END_W = "<?xpacket end=\"w\"?>";
    public static final String XPACKET_PI_END_R = "<?xpacket end=\"r\"?>";
    protected char end = (char)119;

    public XmpWriter(OutputStream outputStream, String string, int n) throws IOException {
        this.extraSpace = n;
        this.writer = new OutputStreamWriter(outputStream, string);
        this.writer.write(XPACKET_PI_BEGIN);
        this.writer.write("<x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n");
        this.writer.write("<rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n");
        this.about = "";
    }

    public XmpWriter(OutputStream outputStream) throws IOException {
        this(outputStream, UTF8, 20);
    }

    public void setReadOnly() {
        this.end = (char)114;
    }

    public void setAbout(String string) {
        this.about = string;
    }

    public void addRdfDescription(String string, String string2) throws IOException {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(string);
        this.writer.write(">");
        this.writer.write(string2);
        this.writer.write("</rdf:Description>\n");
    }

    public void addRdfDescription(XmpSchema xmpSchema) throws IOException {
        this.writer.write("<rdf:Description rdf:about=\"");
        this.writer.write(this.about);
        this.writer.write("\" ");
        this.writer.write(xmpSchema.getXmlns());
        this.writer.write(">");
        this.writer.write(xmpSchema.toString());
        this.writer.write("</rdf:Description>\n");
    }

    public void close() throws IOException {
        this.writer.write("</rdf:RDF>");
        this.writer.write("</x:xmpmeta>\n");
        for (int i = 0; i < this.extraSpace; ++i) {
            this.writer.write(EXTRASPACE);
        }
        this.writer.write(this.end == 'r' ? XPACKET_PI_END_R : XPACKET_PI_END_W);
        this.writer.flush();
        this.writer.close();
    }

    public XmpWriter(OutputStream outputStream, PdfDictionary pdfDictionary, int n) throws IOException {
        this(outputStream);
        if (pdfDictionary != null) {
            DublinCoreSchema dublinCoreSchema = new DublinCoreSchema();
            PdfSchema pdfSchema = new PdfSchema();
            XmpBasicSchema xmpBasicSchema = new XmpBasicSchema();
            for (PdfName pdfName : pdfDictionary.getKeys()) {
                PdfObject pdfObject = pdfDictionary.get(pdfName);
                if (pdfObject == null) continue;
                if (PdfName.TITLE.equals(pdfName)) {
                    dublinCoreSchema.addTitle(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.AUTHOR.equals(pdfName)) {
                    dublinCoreSchema.addAuthor(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.SUBJECT.equals(pdfName)) {
                    dublinCoreSchema.addSubject(((PdfString)pdfObject).toUnicodeString());
                    dublinCoreSchema.addDescription(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.KEYWORDS.equals(pdfName)) {
                    pdfSchema.addKeywords(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATOR.equals(pdfName)) {
                    xmpBasicSchema.addCreatorTool(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.PRODUCER.equals(pdfName)) {
                    pdfSchema.addProducer(((PdfString)pdfObject).toUnicodeString());
                }
                if (PdfName.CREATIONDATE.equals(pdfName)) {
                    xmpBasicSchema.addCreateDate(((PdfDate)pdfObject).getW3CDate());
                }
                if (!PdfName.MODDATE.equals(pdfName)) continue;
                xmpBasicSchema.addModDate(((PdfDate)pdfObject).getW3CDate());
            }
            if (dublinCoreSchema.size() > 0) {
                this.addRdfDescription(dublinCoreSchema);
            }
            if (pdfSchema.size() > 0) {
                this.addRdfDescription(pdfSchema);
            }
            if (xmpBasicSchema.size() > 0) {
                this.addRdfDescription(xmpBasicSchema);
            }
            if (n == 3 || n == 4) {
                PdfA1Schema pdfA1Schema = new PdfA1Schema();
                if (n == 3) {
                    pdfA1Schema.addConformance("A");
                } else {
                    pdfA1Schema.addConformance("B");
                }
                this.addRdfDescription(pdfA1Schema);
            }
        }
    }

    public XmpWriter(OutputStream outputStream, Map map) throws IOException {
        this(outputStream);
        if (map != null) {
            DublinCoreSchema dublinCoreSchema = new DublinCoreSchema();
            PdfSchema pdfSchema = new PdfSchema();
            XmpBasicSchema xmpBasicSchema = new XmpBasicSchema();
            for (Map.Entry entry : map.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (string2 == null) continue;
                if ("Title".equals(string)) {
                    dublinCoreSchema.addTitle(string2);
                }
                if ("Author".equals(string)) {
                    dublinCoreSchema.addAuthor(string2);
                }
                if ("Subject".equals(string)) {
                    dublinCoreSchema.addSubject(string2);
                    dublinCoreSchema.addDescription(string2);
                }
                if ("Keywords".equals(string)) {
                    pdfSchema.addKeywords(string2);
                }
                if ("Creator".equals(string)) {
                    xmpBasicSchema.addCreatorTool(string2);
                }
                if ("Producer".equals(string)) {
                    pdfSchema.addProducer(string2);
                }
                if ("CreationDate".equals(string)) {
                    xmpBasicSchema.addCreateDate(PdfDate.getW3CDate(string2));
                }
                if (!"ModDate".equals(string)) continue;
                xmpBasicSchema.addModDate(PdfDate.getW3CDate(string2));
            }
            if (dublinCoreSchema.size() > 0) {
                this.addRdfDescription(dublinCoreSchema);
            }
            if (pdfSchema.size() > 0) {
                this.addRdfDescription(pdfSchema);
            }
            if (xmpBasicSchema.size() > 0) {
                this.addRdfDescription(xmpBasicSchema);
            }
        }
    }
}

