/*
 * Decompiled with CFR 0.152.
 */
package ai.com.lowagie.text.pdf;

import ai.com.lowagie.text.pdf.PdfArray;
import ai.com.lowagie.text.pdf.PdfDictionary;
import ai.com.lowagie.text.pdf.PdfIndirectReference;
import ai.com.lowagie.text.pdf.PdfName;
import ai.com.lowagie.text.pdf.PdfNumber;
import ai.com.lowagie.text.pdf.PdfObject;
import ai.com.lowagie.text.pdf.PdfReader;
import ai.com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;

public class PdfNumberTree {
    private static final int leafSize = 64;

    public static PdfDictionary writeTree(HashMap hashMap, PdfWriter pdfWriter) throws IOException {
        int n;
        int n2;
        int n3;
        if (hashMap.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Integer[hashMap.size()];
        objectArray = hashMap.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        if (objectArray.length <= 64) {
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            for (int i = 0; i < objectArray.length; ++i) {
                pdfArray.add(new PdfNumber((Integer)objectArray[i]));
                pdfArray.add((PdfObject)hashMap.get(objectArray[i]));
            }
            pdfDictionary.put(PdfName.NUMS, pdfArray);
            return pdfDictionary;
        }
        int n4 = 64;
        PdfIndirectReference[] pdfIndirectReferenceArray = new PdfIndirectReference[(objectArray.length + 64 - 1) / 64];
        for (n3 = 0; n3 < pdfIndirectReferenceArray.length; ++n3) {
            n = Math.min(n2 + 64, objectArray.length);
            PdfDictionary pdfDictionary = new PdfDictionary();
            PdfArray pdfArray = new PdfArray();
            pdfArray.add(new PdfNumber((Integer)objectArray[n2]));
            pdfArray.add(new PdfNumber((Integer)objectArray[n - 1]));
            pdfDictionary.put(PdfName.LIMITS, pdfArray);
            pdfArray = new PdfArray();
            for (n2 = n3 * 64; n2 < n; ++n2) {
                pdfArray.add(new PdfNumber((Integer)objectArray[n2]));
                pdfArray.add((PdfObject)hashMap.get(objectArray[n2]));
            }
            pdfDictionary.put(PdfName.NUMS, pdfArray);
            pdfIndirectReferenceArray[n3] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
        }
        n3 = pdfIndirectReferenceArray.length;
        while (true) {
            if (n3 <= 64) {
                PdfArray pdfArray = new PdfArray();
                for (n = 0; n < n3; ++n) {
                    pdfArray.add(pdfIndirectReferenceArray[n]);
                }
                PdfDictionary pdfDictionary = new PdfDictionary();
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                return pdfDictionary;
            }
            n2 = (objectArray.length + (n4 *= 64) - 1) / n4;
            for (n = 0; n < n2; ++n) {
                int n5;
                int n6 = Math.min(n5 + 64, n3);
                PdfDictionary pdfDictionary = new PdfDictionary();
                PdfArray pdfArray = new PdfArray();
                pdfArray.add(new PdfNumber((Integer)objectArray[n * n4]));
                pdfArray.add(new PdfNumber((Integer)objectArray[Math.min((n + 1) * n4, objectArray.length) - 1]));
                pdfDictionary.put(PdfName.LIMITS, pdfArray);
                pdfArray = new PdfArray();
                for (n5 = n * 64; n5 < n6; ++n5) {
                    pdfArray.add(pdfIndirectReferenceArray[n5]);
                }
                pdfDictionary.put(PdfName.KIDS, pdfArray);
                pdfIndirectReferenceArray[n] = pdfWriter.addToBody(pdfDictionary).getIndirectReference();
            }
            n3 = n2;
        }
    }

    private static void iterateItems(PdfDictionary pdfDictionary, HashMap hashMap) {
        block3: {
            PdfArray pdfArray;
            block2: {
                pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.NUMS));
                if (pdfArray == null) break block2;
                for (int i = 0; i < pdfArray.size(); ++i) {
                    PdfNumber pdfNumber = (PdfNumber)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i++));
                    hashMap.put(new Integer(pdfNumber.intValue()), pdfArray.getPdfObject(i));
                }
                break block3;
            }
            pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.KIDS));
            if (pdfArray == null) break block3;
            for (int i = 0; i < pdfArray.size(); ++i) {
                PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(pdfArray.getPdfObject(i));
                PdfNumberTree.iterateItems(pdfDictionary2, hashMap);
            }
        }
    }

    public static HashMap readTree(PdfDictionary pdfDictionary) {
        HashMap hashMap = new HashMap();
        if (pdfDictionary != null) {
            PdfNumberTree.iterateItems(pdfDictionary, hashMap);
        }
        return hashMap;
    }
}

