/*
 * Decompiled with CFR 0.152.
 */
package ai.com.lowagie.text.pdf;

import ai.com.lowagie.text.ExceptionConverter;
import ai.com.lowagie.text.pdf.OcspClient;
import ai.com.lowagie.text.pdf.PdfEncryption;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.CertificateStatus;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.RevokedStatus;
import org.bouncycastle.ocsp.SingleResp;

public class OcspClientBouncyCastle
implements OcspClient {
    private X509Certificate rootCert;
    private X509Certificate checkCert;
    private String url;

    public OcspClientBouncyCastle(X509Certificate x509Certificate, X509Certificate x509Certificate2, String string) {
        this.checkCert = x509Certificate;
        this.rootCert = x509Certificate2;
        this.url = string;
    }

    private static OCSPReq generateOCSPRequest(X509Certificate x509Certificate, BigInteger bigInteger) throws OCSPException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        CertificateID certificateID = new CertificateID("1.3.14.3.2.26", x509Certificate, bigInteger);
        OCSPReqGenerator oCSPReqGenerator = new OCSPReqGenerator();
        oCSPReqGenerator.addRequest(certificateID);
        Vector<ASN1ObjectIdentifier> vector = new Vector<ASN1ObjectIdentifier>();
        Vector<X509Extension> vector2 = new Vector<X509Extension>();
        vector.add(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        vector2.add(new X509Extension(false, (ASN1OctetString)new DEROctetString(new DEROctetString(PdfEncryption.createDocumentId()).getEncoded())));
        oCSPReqGenerator.setRequestExtensions(new X509Extensions(vector, vector2));
        return oCSPReqGenerator.generate();
    }

    public byte[] getEncoded() {
        try {
            SingleResp[] singleRespArray;
            OCSPReq oCSPReq = OcspClientBouncyCastle.generateOCSPRequest(this.rootCert, this.checkCert.getSerialNumber());
            byte[] byArray = oCSPReq.getEncoded();
            URL uRL = new URL(this.url);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestProperty("Content-Type", "application/ocsp-request");
            httpURLConnection.setRequestProperty("Accept", "application/ocsp-response");
            httpURLConnection.setDoOutput(true);
            OutputStream outputStream = httpURLConnection.getOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(outputStream));
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            dataOutputStream.close();
            if (httpURLConnection.getResponseCode() / 100 != 2) {
                throw new IOException("Invalid HTTP response");
            }
            InputStream inputStream = (InputStream)httpURLConnection.getContent();
            OCSPResp oCSPResp = new OCSPResp(inputStream);
            if (oCSPResp.getStatus() != 0) {
                throw new IOException("Invalid status: " + oCSPResp.getStatus());
            }
            BasicOCSPResp basicOCSPResp = (BasicOCSPResp)oCSPResp.getResponseObject();
            if (basicOCSPResp != null && (singleRespArray = basicOCSPResp.getResponses()).length == 1) {
                SingleResp singleResp = singleRespArray[0];
                Object object = singleResp.getCertStatus();
                if (object == CertificateStatus.GOOD) {
                    return basicOCSPResp.getEncoded();
                }
                if (object instanceof RevokedStatus) {
                    throw new IOException("OCSP Status is revoked!");
                }
                throw new IOException("OCSP Status is unknown!");
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        return null;
    }
}

