/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.qrcode.encoder;

import ai.com.google.zxing.WriterException;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import ai.com.google.zxing.qrcode.encoder.ByteMatrix;
import ai.com.google.zxing.qrcode.encoder.MaskUtil;
import ai.com.google.zxing.qrcode.encoder.QRCode;

public final class MatrixUtil {
    private static final int[][] POSITION_DETECTION_PATTERN = new int[][]{{1, 1, 1, 1, 1, 1, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 1, 1, 1, 0, 1}, {1, 0, 0, 0, 0, 0, 1}, {1, 1, 1, 1, 1, 1, 1}};
    private static final int[][] HORIZONTAL_SEPARATION_PATTERN = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0}};
    private static final int[][] VERTICAL_SEPARATION_PATTERN = new int[][]{{0}, {0}, {0}, {0}, {0}, {0}, {0}};
    private static final int[][] POSITION_ADJUSTMENT_PATTERN = new int[][]{{1, 1, 1, 1, 1}, {1, 0, 0, 0, 1}, {1, 0, 1, 0, 1}, {1, 0, 0, 0, 1}, {1, 1, 1, 1, 1}};
    private static final int[][] POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE = new int[][]{{-1, -1, -1, -1, -1, -1, -1}, {6, 18, -1, -1, -1, -1, -1}, {6, 22, -1, -1, -1, -1, -1}, {6, 26, -1, -1, -1, -1, -1}, {6, 30, -1, -1, -1, -1, -1}, {6, 34, -1, -1, -1, -1, -1}, {6, 22, 38, -1, -1, -1, -1}, {6, 24, 42, -1, -1, -1, -1}, {6, 26, 46, -1, -1, -1, -1}, {6, 28, 50, -1, -1, -1, -1}, {6, 30, 54, -1, -1, -1, -1}, {6, 32, 58, -1, -1, -1, -1}, {6, 34, 62, -1, -1, -1, -1}, {6, 26, 46, 66, -1, -1, -1}, {6, 26, 48, 70, -1, -1, -1}, {6, 26, 50, 74, -1, -1, -1}, {6, 30, 54, 78, -1, -1, -1}, {6, 30, 56, 82, -1, -1, -1}, {6, 30, 58, 86, -1, -1, -1}, {6, 34, 62, 90, -1, -1, -1}, {6, 28, 50, 72, 94, -1, -1}, {6, 26, 50, 74, 98, -1, -1}, {6, 30, 54, 78, 102, -1, -1}, {6, 28, 54, 80, 106, -1, -1}, {6, 32, 58, 84, 110, -1, -1}, {6, 30, 58, 86, 114, -1, -1}, {6, 34, 62, 90, 118, -1, -1}, {6, 26, 50, 74, 98, 122, -1}, {6, 30, 54, 78, 102, 126, -1}, {6, 26, 52, 78, 104, 130, -1}, {6, 30, 56, 82, 108, 134, -1}, {6, 34, 60, 86, 112, 138, -1}, {6, 30, 58, 86, 114, 142, -1}, {6, 34, 62, 90, 118, 146, -1}, {6, 30, 54, 78, 102, 126, 150}, {6, 24, 50, 76, 102, 128, 154}, {6, 28, 54, 80, 106, 132, 158}, {6, 32, 58, 84, 110, 136, 162}, {6, 26, 54, 82, 110, 138, 166}, {6, 30, 58, 86, 114, 142, 170}};
    private static final int[][] TYPE_INFO_COORDINATES = new int[][]{{8, 0}, {8, 1}, {8, 2}, {8, 3}, {8, 4}, {8, 5}, {8, 7}, {8, 8}, {7, 8}, {5, 8}, {4, 8}, {3, 8}, {2, 8}, {1, 8}, {0, 8}};
    private static final int VERSION_INFO_POLY = 7973;
    private static final int TYPE_INFO_POLY = 1335;
    private static final int TYPE_INFO_MASK_PATTERN = 21522;

    private MatrixUtil() {
    }

    public static void clearMatrix(ByteMatrix byteMatrix) {
        byteMatrix.clear((byte)-1);
    }

    public static void buildMatrix(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, int n, int n2, ByteMatrix byteMatrix) throws WriterException {
        MatrixUtil.clearMatrix(byteMatrix);
        MatrixUtil.embedBasicPatterns(n, byteMatrix);
        MatrixUtil.embedTypeInfo(errorCorrectionLevel, n2, byteMatrix);
        MatrixUtil.maybeEmbedVersionInfo(n, byteMatrix);
        MatrixUtil.embedDataBits(bitArray, n2, byteMatrix);
    }

    public static void embedBasicPatterns(int n, ByteMatrix byteMatrix) throws WriterException {
        MatrixUtil.embedPositionDetectionPatternsAndSeparators(byteMatrix);
        MatrixUtil.embedDarkDotAtLeftBottomCorner(byteMatrix);
        MatrixUtil.maybeEmbedPositionAdjustmentPatterns(n, byteMatrix);
        MatrixUtil.embedTimingPatterns(byteMatrix);
    }

    public static void embedTypeInfo(ErrorCorrectionLevel errorCorrectionLevel, int n, ByteMatrix byteMatrix) throws WriterException {
        BitArray bitArray = new BitArray();
        MatrixUtil.makeTypeInfoBits(errorCorrectionLevel, n, bitArray);
        for (int i = 0; i < bitArray.getSize(); ++i) {
            int n2;
            int n3;
            boolean bl = bitArray.get(bitArray.getSize() - 1 - i);
            int n4 = TYPE_INFO_COORDINATES[i][0];
            int n5 = TYPE_INFO_COORDINATES[i][1];
            byteMatrix.set(n4, n5, bl);
            if (i < 8) {
                n3 = byteMatrix.getWidth() - i - 1;
                n2 = 8;
                byteMatrix.set(n3, n2, bl);
                continue;
            }
            n3 = 8;
            n2 = byteMatrix.getHeight() - 7 + (i - 8);
            byteMatrix.set(n3, n2, bl);
        }
    }

    public static void maybeEmbedVersionInfo(int n, ByteMatrix byteMatrix) throws WriterException {
        if (n < 7) {
            return;
        }
        BitArray bitArray = new BitArray();
        MatrixUtil.makeVersionInfoBits(n, bitArray);
        int n2 = 17;
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 3; ++j) {
                boolean bl = bitArray.get(n2);
                --n2;
                byteMatrix.set(i, byteMatrix.getHeight() - 11 + j, bl);
                byteMatrix.set(byteMatrix.getHeight() - 11 + j, i, bl);
            }
        }
    }

    public static void embedDataBits(BitArray bitArray, int n, ByteMatrix byteMatrix) throws WriterException {
        int n2 = 0;
        int n3 = -1;
        int n4 = byteMatrix.getHeight() - 1;
        for (int i = byteMatrix.getWidth() - 1; i > 0; i -= 2) {
            if (i == 6) {
                --i;
            }
            while (n4 >= 0 && n4 < byteMatrix.getHeight()) {
                for (int j = 0; j < 2; ++j) {
                    boolean bl;
                    int n5 = i - j;
                    if (!MatrixUtil.isEmpty(byteMatrix.get(n5, n4))) continue;
                    if (n2 < bitArray.getSize()) {
                        bl = bitArray.get(n2);
                        ++n2;
                    } else {
                        bl = false;
                    }
                    if (n != -1 && MaskUtil.getDataMaskBit(n, n5, n4)) {
                        bl = !bl;
                    }
                    byteMatrix.set(n5, n4, bl);
                }
                n4 += n3;
            }
            n3 = -n3;
            n4 += n3;
        }
        if (n2 != bitArray.getSize()) {
            throw new WriterException("Not all bits consumed: " + n2 + '/' + bitArray.getSize());
        }
    }

    public static int findMSBSet(int n) {
        int n2 = 0;
        while (n != 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    public static int calculateBCHCode(int n, int n2) {
        int n3 = MatrixUtil.findMSBSet(n2);
        n <<= n3 - 1;
        while (MatrixUtil.findMSBSet(n) >= n3) {
            n ^= n2 << MatrixUtil.findMSBSet(n) - n3;
        }
        return n;
    }

    public static void makeTypeInfoBits(ErrorCorrectionLevel errorCorrectionLevel, int n, BitArray bitArray) throws WriterException {
        if (!QRCode.isValidMaskPattern(n)) {
            throw new WriterException("Invalid mask pattern");
        }
        int n2 = errorCorrectionLevel.getBits() << 3 | n;
        bitArray.appendBits(n2, 5);
        int n3 = MatrixUtil.calculateBCHCode(n2, 1335);
        bitArray.appendBits(n3, 10);
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBits(21522, 15);
        bitArray.xor(bitArray2);
        if (bitArray.getSize() != 15) {
            throw new WriterException("should not happen but we got: " + bitArray.getSize());
        }
    }

    public static void makeVersionInfoBits(int n, BitArray bitArray) throws WriterException {
        bitArray.appendBits(n, 6);
        int n2 = MatrixUtil.calculateBCHCode(n, 7973);
        bitArray.appendBits(n2, 12);
        if (bitArray.getSize() != 18) {
            throw new WriterException("should not happen but we got: " + bitArray.getSize());
        }
    }

    private static boolean isEmpty(int n) {
        return n == -1;
    }

    private static boolean isValidValue(int n) {
        return n == -1 || n == 0 || n == 1;
    }

    private static void embedTimingPatterns(ByteMatrix byteMatrix) throws WriterException {
        for (int i = 8; i < byteMatrix.getWidth() - 8; ++i) {
            int n = (i + 1) % 2;
            if (!MatrixUtil.isValidValue(byteMatrix.get(i, 6))) {
                throw new WriterException();
            }
            if (MatrixUtil.isEmpty(byteMatrix.get(i, 6))) {
                byteMatrix.set(i, 6, n);
            }
            if (!MatrixUtil.isValidValue(byteMatrix.get(6, i))) {
                throw new WriterException();
            }
            if (!MatrixUtil.isEmpty(byteMatrix.get(6, i))) continue;
            byteMatrix.set(6, i, n);
        }
    }

    private static void embedDarkDotAtLeftBottomCorner(ByteMatrix byteMatrix) throws WriterException {
        if (byteMatrix.get(8, byteMatrix.getHeight() - 8) == 0) {
            throw new WriterException();
        }
        byteMatrix.set(8, byteMatrix.getHeight() - 8, 1);
    }

    private static void embedHorizontalSeparationPattern(int n, int n2, ByteMatrix byteMatrix) throws WriterException {
        if (HORIZONTAL_SEPARATION_PATTERN[0].length != 8 || HORIZONTAL_SEPARATION_PATTERN.length != 1) {
            throw new WriterException("Bad horizontal separation pattern");
        }
        for (int i = 0; i < 8; ++i) {
            if (!MatrixUtil.isEmpty(byteMatrix.get(n + i, n2))) {
                throw new WriterException();
            }
            byteMatrix.set(n + i, n2, HORIZONTAL_SEPARATION_PATTERN[0][i]);
        }
    }

    private static void embedVerticalSeparationPattern(int n, int n2, ByteMatrix byteMatrix) throws WriterException {
        if (VERTICAL_SEPARATION_PATTERN[0].length != 1 || VERTICAL_SEPARATION_PATTERN.length != 7) {
            throw new WriterException("Bad vertical separation pattern");
        }
        for (int i = 0; i < 7; ++i) {
            if (!MatrixUtil.isEmpty(byteMatrix.get(n, n2 + i))) {
                throw new WriterException();
            }
            byteMatrix.set(n, n2 + i, VERTICAL_SEPARATION_PATTERN[i][0]);
        }
    }

    private static void embedPositionAdjustmentPattern(int n, int n2, ByteMatrix byteMatrix) throws WriterException {
        if (POSITION_ADJUSTMENT_PATTERN[0].length != 5 || POSITION_ADJUSTMENT_PATTERN.length != 5) {
            throw new WriterException("Bad position adjustment");
        }
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                if (!MatrixUtil.isEmpty(byteMatrix.get(n + j, n2 + i))) {
                    throw new WriterException();
                }
                byteMatrix.set(n + j, n2 + i, POSITION_ADJUSTMENT_PATTERN[i][j]);
            }
        }
    }

    private static void embedPositionDetectionPattern(int n, int n2, ByteMatrix byteMatrix) throws WriterException {
        if (POSITION_DETECTION_PATTERN[0].length != 7 || POSITION_DETECTION_PATTERN.length != 7) {
            throw new WriterException("Bad position detection pattern");
        }
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (!MatrixUtil.isEmpty(byteMatrix.get(n + j, n2 + i))) {
                    throw new WriterException();
                }
                byteMatrix.set(n + j, n2 + i, POSITION_DETECTION_PATTERN[i][j]);
            }
        }
    }

    private static void embedPositionDetectionPatternsAndSeparators(ByteMatrix byteMatrix) throws WriterException {
        int n = POSITION_DETECTION_PATTERN[0].length;
        MatrixUtil.embedPositionDetectionPattern(0, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(byteMatrix.getWidth() - n, 0, byteMatrix);
        MatrixUtil.embedPositionDetectionPattern(0, byteMatrix.getWidth() - n, byteMatrix);
        int n2 = HORIZONTAL_SEPARATION_PATTERN[0].length;
        MatrixUtil.embedHorizontalSeparationPattern(0, n2 - 1, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(byteMatrix.getWidth() - n2, n2 - 1, byteMatrix);
        MatrixUtil.embedHorizontalSeparationPattern(0, byteMatrix.getWidth() - n2, byteMatrix);
        int n3 = VERTICAL_SEPARATION_PATTERN.length;
        MatrixUtil.embedVerticalSeparationPattern(n3, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(byteMatrix.getHeight() - n3 - 1, 0, byteMatrix);
        MatrixUtil.embedVerticalSeparationPattern(n3, byteMatrix.getHeight() - n3, byteMatrix);
    }

    private static void maybeEmbedPositionAdjustmentPatterns(int n, ByteMatrix byteMatrix) throws WriterException {
        if (n < 2) {
            return;
        }
        int n2 = n - 1;
        int[] nArray = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n2];
        int n3 = POSITION_ADJUSTMENT_PATTERN_COORDINATE_TABLE[n2].length;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = nArray[i];
                int n5 = nArray[j];
                if (n5 == -1 || n4 == -1 || !MatrixUtil.isEmpty(byteMatrix.get(n5, n4))) continue;
                MatrixUtil.embedPositionAdjustmentPattern(n5 - 2, n4 - 2, byteMatrix);
            }
        }
    }
}

