/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.qrcode.decoder;

import ai.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;

final class FormatInformation {
    private static final int FORMAT_INFO_MASK_QR = 21522;
    private static final int[][] FORMAT_INFO_DECODE_LOOKUP = new int[][]{{21522, 0}, {20773, 1}, {24188, 2}, {23371, 3}, {17913, 4}, {16590, 5}, {20375, 6}, {19104, 7}, {30660, 8}, {29427, 9}, {32170, 10}, {30877, 11}, {26159, 12}, {25368, 13}, {27713, 14}, {26998, 15}, {5769, 16}, {5054, 17}, {7399, 18}, {6608, 19}, {1890, 20}, {597, 21}, {3340, 22}, {2107, 23}, {13663, 24}, {12392, 25}, {16177, 26}, {14854, 27}, {9396, 28}, {8579, 29}, {11994, 30}, {11245, 31}};
    private static final int[] BITS_SET_IN_HALF_BYTE = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    private final ErrorCorrectionLevel errorCorrectionLevel;
    private final byte dataMask;

    private FormatInformation(int n) {
        this.errorCorrectionLevel = ErrorCorrectionLevel.forBits(n >> 3 & 3);
        this.dataMask = (byte)(n & 7);
    }

    static int numBitsDiffering(int n, int n2) {
        return BITS_SET_IN_HALF_BYTE[(n ^= n2) & 0xF] + BITS_SET_IN_HALF_BYTE[n >>> 4 & 0xF] + BITS_SET_IN_HALF_BYTE[n >>> 8 & 0xF] + BITS_SET_IN_HALF_BYTE[n >>> 12 & 0xF] + BITS_SET_IN_HALF_BYTE[n >>> 16 & 0xF] + BITS_SET_IN_HALF_BYTE[n >>> 20 & 0xF] + BITS_SET_IN_HALF_BYTE[n >>> 24 & 0xF] + BITS_SET_IN_HALF_BYTE[n >>> 28 & 0xF];
    }

    static FormatInformation decodeFormatInformation(int n, int n2) {
        FormatInformation formatInformation = FormatInformation.doDecodeFormatInformation(n, n2);
        if (formatInformation != null) {
            return formatInformation;
        }
        return FormatInformation.doDecodeFormatInformation(n ^ 0x5412, n2 ^ 0x5412);
    }

    private static FormatInformation doDecodeFormatInformation(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        for (int i = 0; i < FORMAT_INFO_DECODE_LOOKUP.length; ++i) {
            int[] nArray = FORMAT_INFO_DECODE_LOOKUP[i];
            int n5 = nArray[0];
            if (n5 == n || n5 == n2) {
                return new FormatInformation(nArray[1]);
            }
            int n6 = FormatInformation.numBitsDiffering(n, n5);
            if (n6 < n3) {
                n4 = nArray[1];
                n3 = n6;
            }
            if (n == n2 || (n6 = FormatInformation.numBitsDiffering(n2, n5)) >= n3) continue;
            n4 = nArray[1];
            n3 = n6;
        }
        if (n3 <= 3) {
            return new FormatInformation(n4);
        }
        return null;
    }

    ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    byte getDataMask() {
        return this.dataMask;
    }

    public int hashCode() {
        return this.errorCorrectionLevel.ordinal() << 3 | this.dataMask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormatInformation)) {
            return false;
        }
        FormatInformation formatInformation = (FormatInformation)object;
        return this.errorCorrectionLevel == formatInformation.errorCorrectionLevel && this.dataMask == formatInformation.dataMask;
    }
}

