/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned.rss.expanded.decoders;

import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.rss.expanded.decoders.BlockParsedResult;
import ai.com.google.zxing.oned.rss.expanded.decoders.CurrentParsingState;
import ai.com.google.zxing.oned.rss.expanded.decoders.DecodedChar;
import ai.com.google.zxing.oned.rss.expanded.decoders.DecodedInformation;
import ai.com.google.zxing.oned.rss.expanded.decoders.DecodedNumeric;
import ai.com.google.zxing.oned.rss.expanded.decoders.FieldParser;

final class GeneralAppIdDecoder {
    private final BitArray information;
    private final CurrentParsingState current = new CurrentParsingState();
    private final StringBuffer buffer = new StringBuffer();

    GeneralAppIdDecoder(BitArray bitArray) {
        this.information = bitArray;
    }

    String decodeAllCodes(StringBuffer stringBuffer, int n) throws NotFoundException {
        int n2 = n;
        String string = null;
        while (true) {
            DecodedInformation decodedInformation = this.decodeGeneralPurposeField(n2, string);
            String string2 = FieldParser.parseFieldsInGeneralPurpose(decodedInformation.getNewString());
            stringBuffer.append(string2);
            string = decodedInformation.isRemaining() ? String.valueOf(decodedInformation.getRemainingValue()) : null;
            if (n2 == decodedInformation.getNewPosition()) break;
            n2 = decodedInformation.getNewPosition();
        }
        return stringBuffer.toString();
    }

    private boolean isStillNumeric(int n) {
        if (n + 7 > this.information.size) {
            return n + 4 <= this.information.size;
        }
        for (int i = n; i < n + 3; ++i) {
            if (!this.information.get(i)) continue;
            return true;
        }
        return this.information.get(n + 3);
    }

    private DecodedNumeric decodeNumeric(int n) {
        if (n + 7 > this.information.size) {
            int n2 = this.extractNumericValueFromBitArray(n, 4);
            if (n2 == 0) {
                return new DecodedNumeric(this.information.size, 10, 10);
            }
            return new DecodedNumeric(this.information.size, n2 - 1, 10);
        }
        int n3 = this.extractNumericValueFromBitArray(n, 7);
        int n4 = (n3 - 8) / 11;
        int n5 = (n3 - 8) % 11;
        return new DecodedNumeric(n + 7, n4, n5);
    }

    int extractNumericValueFromBitArray(int n, int n2) {
        return GeneralAppIdDecoder.extractNumericValueFromBitArray(this.information, n, n2);
    }

    static int extractNumericValueFromBitArray(BitArray bitArray, int n, int n2) {
        if (n2 > 32) {
            throw new IllegalArgumentException("extractNumberValueFromBitArray can't handle more than 32 bits");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (!bitArray.get(n + i)) continue;
            n3 |= 1 << n2 - i - 1;
        }
        return n3;
    }

    DecodedInformation decodeGeneralPurposeField(int n, String string) {
        this.buffer.setLength(0);
        if (string != null) {
            this.buffer.append(string);
        }
        this.current.position = n;
        DecodedInformation decodedInformation = this.parseBlocks();
        if (decodedInformation != null && decodedInformation.isRemaining()) {
            return new DecodedInformation(this.current.position, this.buffer.toString(), decodedInformation.getRemainingValue());
        }
        return new DecodedInformation(this.current.position, this.buffer.toString());
    }

    private DecodedInformation parseBlocks() {
        BlockParsedResult blockParsedResult;
        boolean bl;
        boolean bl2;
        do {
            int n = this.current.position;
            if (this.current.isAlpha()) {
                blockParsedResult = this.parseAlphaBlock();
                bl = blockParsedResult.isFinished();
            } else if (this.current.isIsoIec646()) {
                blockParsedResult = this.parseIsoIec646Block();
                bl = blockParsedResult.isFinished();
            } else {
                blockParsedResult = this.parseNumericBlock();
                bl = blockParsedResult.isFinished();
            }
            boolean bl3 = bl2 = n != this.current.position;
        } while ((bl2 || bl) && !bl);
        return blockParsedResult.getDecodedInformation();
    }

    private BlockParsedResult parseNumericBlock() {
        while (this.isStillNumeric(this.current.position)) {
            DecodedNumeric decodedNumeric = this.decodeNumeric(this.current.position);
            this.current.position = decodedNumeric.getNewPosition();
            if (decodedNumeric.isFirstDigitFNC1()) {
                DecodedInformation decodedInformation = decodedNumeric.isSecondDigitFNC1() ? new DecodedInformation(this.current.position, this.buffer.toString()) : new DecodedInformation(this.current.position, this.buffer.toString(), decodedNumeric.getSecondDigit());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedNumeric.getFirstDigit());
            if (decodedNumeric.isSecondDigitFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.position, this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedNumeric.getSecondDigit());
        }
        if (this.isNumericToAlphaNumericLatch(this.current.position)) {
            this.current.setAlpha();
            this.current.position += 4;
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseIsoIec646Block() {
        while (this.isStillIsoIec646(this.current.position)) {
            DecodedChar decodedChar = this.decodeIsoIec646(this.current.position);
            this.current.position = decodedChar.getNewPosition();
            if (decodedChar.isFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.position, this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.position)) {
            this.current.position += 3;
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.position)) {
            this.current.position = this.current.position + 5 < this.information.size ? (this.current.position += 5) : this.information.size;
            this.current.setAlpha();
        }
        return new BlockParsedResult(false);
    }

    private BlockParsedResult parseAlphaBlock() {
        while (this.isStillAlpha(this.current.position)) {
            DecodedChar decodedChar = this.decodeAlphanumeric(this.current.position);
            this.current.position = decodedChar.getNewPosition();
            if (decodedChar.isFNC1()) {
                DecodedInformation decodedInformation = new DecodedInformation(this.current.position, this.buffer.toString());
                return new BlockParsedResult(decodedInformation, true);
            }
            this.buffer.append(decodedChar.getValue());
        }
        if (this.isAlphaOr646ToNumericLatch(this.current.position)) {
            this.current.position += 3;
            this.current.setNumeric();
        } else if (this.isAlphaTo646ToAlphaLatch(this.current.position)) {
            this.current.position = this.current.position + 5 < this.information.size ? (this.current.position += 5) : this.information.size;
            this.current.setIsoIec646();
        }
        return new BlockParsedResult(false);
    }

    private boolean isStillIsoIec646(int n) {
        if (n + 5 > this.information.size) {
            return false;
        }
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 >= 5 && n2 < 16) {
            return true;
        }
        if (n + 7 > this.information.size) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n, 7);
        if (n3 >= 64 && n3 < 116) {
            return true;
        }
        if (n + 8 > this.information.size) {
            return false;
        }
        int n4 = this.extractNumericValueFromBitArray(n, 8);
        return n4 >= 232 && n4 < 253;
    }

    private DecodedChar decodeIsoIec646(int n) {
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 == 15) {
            return new DecodedChar(n + 5, '$');
        }
        if (n2 >= 5 && n2 < 15) {
            return new DecodedChar(n + 5, (char)(48 + n2 - 5));
        }
        int n3 = this.extractNumericValueFromBitArray(n, 7);
        if (n3 >= 64 && n3 < 90) {
            return new DecodedChar(n + 7, (char)(n3 + 1));
        }
        if (n3 >= 90 && n3 < 116) {
            return new DecodedChar(n + 7, (char)(n3 + 7));
        }
        int n4 = this.extractNumericValueFromBitArray(n, 8);
        switch (n4) {
            case 232: {
                return new DecodedChar(n + 8, '!');
            }
            case 233: {
                return new DecodedChar(n + 8, '\"');
            }
            case 234: {
                return new DecodedChar(n + 8, '%');
            }
            case 235: {
                return new DecodedChar(n + 8, '&');
            }
            case 236: {
                return new DecodedChar(n + 8, '\'');
            }
            case 237: {
                return new DecodedChar(n + 8, '(');
            }
            case 238: {
                return new DecodedChar(n + 8, ')');
            }
            case 239: {
                return new DecodedChar(n + 8, '*');
            }
            case 240: {
                return new DecodedChar(n + 8, '+');
            }
            case 241: {
                return new DecodedChar(n + 8, ',');
            }
            case 242: {
                return new DecodedChar(n + 8, '-');
            }
            case 243: {
                return new DecodedChar(n + 8, '.');
            }
            case 244: {
                return new DecodedChar(n + 8, '/');
            }
            case 245: {
                return new DecodedChar(n + 8, ':');
            }
            case 246: {
                return new DecodedChar(n + 8, ';');
            }
            case 247: {
                return new DecodedChar(n + 8, '<');
            }
            case 248: {
                return new DecodedChar(n + 8, '=');
            }
            case 249: {
                return new DecodedChar(n + 8, '>');
            }
            case 250: {
                return new DecodedChar(n + 8, '?');
            }
            case 251: {
                return new DecodedChar(n + 8, '_');
            }
            case 252: {
                return new DecodedChar(n + 8, ' ');
            }
        }
        throw new RuntimeException("Decoding invalid ISO/IEC 646 value: " + n4);
    }

    private boolean isStillAlpha(int n) {
        if (n + 5 > this.information.size) {
            return false;
        }
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 >= 5 && n2 < 16) {
            return true;
        }
        if (n + 6 > this.information.size) {
            return false;
        }
        int n3 = this.extractNumericValueFromBitArray(n, 6);
        return n3 >= 16 && n3 < 63;
    }

    private DecodedChar decodeAlphanumeric(int n) {
        int n2 = this.extractNumericValueFromBitArray(n, 5);
        if (n2 == 15) {
            return new DecodedChar(n + 5, '$');
        }
        if (n2 >= 5 && n2 < 15) {
            return new DecodedChar(n + 5, (char)(48 + n2 - 5));
        }
        int n3 = this.extractNumericValueFromBitArray(n, 6);
        if (n3 >= 32 && n3 < 58) {
            return new DecodedChar(n + 6, (char)(n3 + 33));
        }
        switch (n3) {
            case 58: {
                return new DecodedChar(n + 6, '*');
            }
            case 59: {
                return new DecodedChar(n + 6, ',');
            }
            case 60: {
                return new DecodedChar(n + 6, '-');
            }
            case 61: {
                return new DecodedChar(n + 6, '.');
            }
            case 62: {
                return new DecodedChar(n + 6, '/');
            }
        }
        throw new RuntimeException("Decoding invalid alphanumeric value: " + n3);
    }

    private boolean isAlphaTo646ToAlphaLatch(int n) {
        if (n + 1 > this.information.size) {
            return false;
        }
        for (int i = 0; i < 5 && i + n < this.information.size; ++i) {
            if (!(i == 2 ? !this.information.get(n + 2) : this.information.get(n + i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAlphaOr646ToNumericLatch(int n) {
        if (n + 3 > this.information.size) {
            return false;
        }
        for (int i = n; i < n + 3; ++i) {
            if (!this.information.get(i)) continue;
            return false;
        }
        return true;
    }

    private boolean isNumericToAlphaNumericLatch(int n) {
        if (n + 1 > this.information.size) {
            return false;
        }
        for (int i = 0; i < 4 && i + n < this.information.size; ++i) {
            if (!this.information.get(n + i)) continue;
            return false;
        }
        return true;
    }
}

