/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned.rss.expanded;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.rss.AbstractRSSReader;
import ai.com.google.zxing.oned.rss.DataCharacter;
import ai.com.google.zxing.oned.rss.FinderPattern;
import ai.com.google.zxing.oned.rss.RSSUtils;
import ai.com.google.zxing.oned.rss.expanded.BitArrayBuilder;
import ai.com.google.zxing.oned.rss.expanded.ExpandedPair;
import ai.com.google.zxing.oned.rss.expanded.decoders.AbstractExpandedDecoder;
import java.util.Hashtable;
import java.util.Vector;

public final class RSSExpandedReader
extends AbstractRSSReader {
    private static final int[] SYMBOL_WIDEST = new int[]{7, 5, 4, 3, 1};
    private static final int[] EVEN_TOTAL_SUBSET = new int[]{4, 20, 52, 104, 204};
    private static final int[] GSUM = new int[]{0, 348, 1388, 2948, 3988};
    private static final int[][] FINDER_PATTERNS = new int[][]{{1, 8, 4, 1}, {3, 6, 4, 1}, {3, 4, 6, 1}, {3, 2, 8, 1}, {2, 6, 5, 1}, {2, 2, 9, 1}};
    private static final int[][] WEIGHTS = new int[][]{{1, 3, 9, 27, 81, 32, 96, 77}, {20, 60, 180, 118, 143, 7, 21, 63}, {189, 145, 13, 39, 117, 140, 209, 205}, {193, 157, 49, 147, 19, 57, 171, 91}, {62, 186, 136, 197, 169, 85, 44, 132}, {185, 133, 188, 142, 4, 12, 36, 108}, {113, 128, 173, 97, 80, 29, 87, 50}, {150, 28, 84, 41, 123, 158, 52, 156}, {46, 138, 203, 187, 139, 206, 196, 166}, {76, 17, 51, 153, 37, 111, 122, 155}, {43, 129, 176, 106, 107, 110, 119, 146}, {16, 48, 144, 10, 30, 90, 59, 177}, {109, 116, 137, 200, 178, 112, 125, 164}, {70, 210, 208, 202, 184, 130, 179, 115}, {134, 191, 151, 31, 93, 68, 204, 190}, {148, 22, 66, 198, 172, 94, 71, 2}, {6, 18, 54, 162, 64, 192, 154, 40}, {120, 149, 25, 75, 14, 42, 126, 167}, {79, 26, 78, 23, 69, 207, 199, 175}, {103, 98, 83, 38, 114, 131, 182, 124}, {161, 61, 183, 127, 170, 88, 53, 159}, {55, 165, 73, 8, 24, 72, 5, 15}, {45, 135, 194, 160, 58, 174, 100, 89}};
    private static final int FINDER_PAT_A = 0;
    private static final int FINDER_PAT_B = 1;
    private static final int FINDER_PAT_C = 2;
    private static final int FINDER_PAT_D = 3;
    private static final int FINDER_PAT_E = 4;
    private static final int FINDER_PAT_F = 5;
    private static final int[][] FINDER_PATTERN_SEQUENCES = new int[][]{{0, 0}, {0, 1, 1}, {0, 2, 1, 3}, {0, 4, 1, 3, 2}, {0, 4, 1, 3, 3, 5}, {0, 4, 1, 3, 4, 5, 5}, {0, 0, 1, 1, 2, 2, 3, 3}, {0, 0, 1, 1, 2, 2, 3, 4, 4}, {0, 0, 1, 1, 2, 2, 3, 4, 5, 5}, {0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5}};
    private static final int LONGEST_SEQUENCE_SIZE = FINDER_PATTERN_SEQUENCES[FINDER_PATTERN_SEQUENCES.length - 1].length;
    private static final int MAX_PAIRS = 11;
    private final Vector pairs = new Vector(11);
    private final int[] startEnd = new int[2];
    private final int[] currentSequence = new int[LONGEST_SEQUENCE_SIZE];

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException {
        this.reset();
        this.decodeRow2pairs(n, bitArray);
        return RSSExpandedReader.constructResult(this.pairs);
    }

    public void reset() {
        this.pairs.setSize(0);
    }

    Vector decodeRow2pairs(int n, BitArray bitArray) throws NotFoundException {
        while (true) {
            ExpandedPair expandedPair = this.retrieveNextPair(bitArray, this.pairs, n);
            this.pairs.addElement(expandedPair);
            if (!expandedPair.mayBeLast()) continue;
            if (this.checkChecksum()) {
                return this.pairs;
            }
            if (expandedPair.mustBeLast()) break;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Result constructResult(Vector vector) throws NotFoundException {
        BitArray bitArray = BitArrayBuilder.buildBitArray(vector);
        AbstractExpandedDecoder abstractExpandedDecoder = AbstractExpandedDecoder.createDecoder(bitArray);
        String string = abstractExpandedDecoder.parseInformation();
        ResultPoint[] resultPointArray = ((ExpandedPair)vector.elementAt(0)).getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = ((ExpandedPair)vector.lastElement()).getFinderPattern().getResultPoints();
        return new Result(string, null, new ResultPoint[]{resultPointArray[0], resultPointArray[1], resultPointArray2[0], resultPointArray2[1]}, BarcodeFormat.RSS_EXPANDED);
    }

    private boolean checkChecksum() {
        int n;
        ExpandedPair expandedPair = (ExpandedPair)this.pairs.elementAt(0);
        DataCharacter dataCharacter = expandedPair.getLeftChar();
        DataCharacter dataCharacter2 = expandedPair.getRightChar();
        int n2 = dataCharacter2.getChecksumPortion();
        int n3 = 2;
        for (n = 1; n < this.pairs.size(); ++n) {
            ExpandedPair expandedPair2 = (ExpandedPair)this.pairs.elementAt(n);
            n2 += expandedPair2.getLeftChar().getChecksumPortion();
            ++n3;
            if (expandedPair2.getRightChar() == null) continue;
            n2 += expandedPair2.getRightChar().getChecksumPortion();
            ++n3;
        }
        n = 211 * (n3 - 4) + (n2 %= 211);
        return n == dataCharacter.getValue();
    }

    private static int getNextSecondBar(BitArray bitArray, int n) {
        int n2;
        boolean bl = bitArray.get(n2);
        for (n2 = n; n2 < bitArray.size && bitArray.get(n2) == bl; ++n2) {
        }
        boolean bl2 = bl = !bl;
        while (n2 < bitArray.size && bitArray.get(n2) == bl) {
            ++n2;
        }
        return n2;
    }

    ExpandedPair retrieveNextPair(BitArray bitArray, Vector vector, int n) throws NotFoundException {
        DataCharacter dataCharacter;
        FinderPattern finderPattern;
        boolean bl = vector.size() % 2 == 0;
        boolean bl2 = true;
        int n2 = -1;
        do {
            this.findNextPair(bitArray, vector, n2);
            finderPattern = this.parseFoundFinderPattern(bitArray, n, bl);
            if (finderPattern == null) {
                n2 = RSSExpandedReader.getNextSecondBar(bitArray, this.startEnd[0]);
                continue;
            }
            bl2 = false;
        } while (bl2);
        boolean bl3 = this.checkPairSequence(vector, finderPattern);
        DataCharacter dataCharacter2 = this.decodeDataCharacter(bitArray, finderPattern, bl, true);
        try {
            dataCharacter = this.decodeDataCharacter(bitArray, finderPattern, bl, false);
        }
        catch (NotFoundException notFoundException) {
            if (bl3) {
                dataCharacter = null;
            }
            throw notFoundException;
        }
        return new ExpandedPair(dataCharacter2, dataCharacter, finderPattern, bl3);
    }

    private boolean checkPairSequence(Vector vector, FinderPattern finderPattern) throws NotFoundException {
        int n;
        int n2 = vector.size() + 1;
        if (n2 > this.currentSequence.length) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (n = 0; n < vector.size(); ++n) {
            this.currentSequence[n] = ((ExpandedPair)vector.elementAt(n)).getFinderPattern().getValue();
        }
        this.currentSequence[n2 - 1] = finderPattern.getValue();
        for (n = 0; n < FINDER_PATTERN_SEQUENCES.length; ++n) {
            int[] nArray = FINDER_PATTERN_SEQUENCES[n];
            if (nArray.length < n2) continue;
            boolean bl = true;
            for (int i = 0; i < n2; ++i) {
                if (this.currentSequence[i] == nArray[i]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return n2 == nArray.length;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private void findNextPair(BitArray bitArray, Vector vector, int n) throws NotFoundException {
        int n2;
        int[] nArray = this.decodeFinderCounters;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n3 = bitArray.getSize();
        if (n >= 0) {
            n2 = n;
        } else if (vector.isEmpty()) {
            n2 = 0;
        } else {
            ExpandedPair expandedPair = (ExpandedPair)vector.lastElement();
            n2 = expandedPair.getFinderPattern().getStartEnd()[1];
        }
        boolean bl = vector.size() % 2 != 0;
        boolean bl2 = false;
        while (n2 < n3) {
            boolean bl3 = bl2 = !bitArray.get(n2);
            if (!bl2) break;
            ++n2;
        }
        int n4 = 0;
        int n5 = n2;
        for (int i = n2; i < n3; ++i) {
            boolean bl4 = bitArray.get(i);
            if (bl4 ^ bl2) {
                int n6 = n4;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n4 == 3) {
                if (bl) {
                    RSSExpandedReader.reverseCounters(nArray);
                }
                if (RSSExpandedReader.isFinderPattern(nArray)) {
                    this.startEnd[0] = n5;
                    this.startEnd[1] = i;
                    return;
                }
                if (bl) {
                    RSSExpandedReader.reverseCounters(nArray);
                }
                n5 += nArray[0] + nArray[1];
                nArray[0] = nArray[2];
                nArray[1] = nArray[3];
                nArray[2] = 0;
                nArray[3] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray[n4] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void reverseCounters(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n / 2; ++i) {
            int n2 = nArray[i];
            nArray[i] = nArray[n - i - 1];
            nArray[n - i - 1] = n2;
        }
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bl) {
            for (n6 = this.startEnd[0] - 1; n6 >= 0 && !bitArray.get(n6); --n6) {
            }
            n5 = this.startEnd[0] - ++n6;
            n4 = n6;
            n3 = this.startEnd[1];
        } else {
            n4 = this.startEnd[0];
            for (n6 = this.startEnd[1] + 1; bitArray.get(n6) && n6 < bitArray.size; ++n6) {
            }
            n3 = n6;
            n5 = n3 - this.startEnd[1];
        }
        int[] nArray = this.decodeFinderCounters;
        for (n2 = nArray.length - 1; n2 > 0; --n2) {
            nArray[n2] = nArray[n2 - 1];
        }
        nArray[0] = n5;
        try {
            n2 = RSSExpandedReader.parseFinderValue(nArray, FINDER_PATTERNS);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
        return new FinderPattern(n2, new int[]{n4, n3}, n4, n3, n);
    }

    DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl, boolean bl2) throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray = this.dataCharacterCounters;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl2) {
            RSSExpandedReader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray);
        } else {
            RSSExpandedReader.recordPattern(bitArray, finderPattern.getStartEnd()[1] + 1, nArray);
            n7 = 0;
            for (int i = nArray.length - 1; n7 < i; ++n7, --i) {
                int n8 = nArray[n7];
                nArray[n7] = nArray[i];
                nArray[i] = n8;
            }
        }
        n7 = 17;
        float f = (float)RSSExpandedReader.count(nArray) / (float)n7;
        int[] nArray2 = this.oddCounts;
        int[] nArray3 = this.evenCounts;
        float[] fArray = this.oddRoundingErrors;
        float[] fArray2 = this.evenRoundingErrors;
        for (n6 = 0; n6 < nArray.length; ++n6) {
            float f2 = 1.0f * (float)nArray[n6] / f;
            n5 = (int)(f2 + 0.5f);
            if (n5 < 1) {
                n5 = 1;
            } else if (n5 > 8) {
                n5 = 8;
            }
            n4 = n6 >> 1;
            if ((n6 & 1) == 0) {
                nArray2[n4] = n5;
                fArray[n4] = f2 - (float)n5;
                continue;
            }
            nArray3[n4] = n5;
            fArray2[n4] = f2 - (float)n5;
        }
        this.adjustOddEvenCounts(n7);
        n6 = 4 * finderPattern.getValue() + (bl ? 0 : 2) + (bl2 ? 0 : 1) - 1;
        int n9 = 0;
        n5 = 0;
        for (n4 = nArray2.length - 1; n4 >= 0; --n4) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) {
                n3 = WEIGHTS[n6][2 * n4];
                n5 += nArray2[n4] * n3;
            }
            n9 += nArray2[n4];
        }
        n4 = 0;
        n3 = 0;
        for (n2 = nArray3.length - 1; n2 >= 0; --n2) {
            if (RSSExpandedReader.isNotA1left(finderPattern, bl, bl2)) {
                n = WEIGHTS[n6][2 * n2 + 1];
                n4 += nArray3[n2] * n;
            }
            n3 += nArray3[n2];
        }
        n2 = n5 + n4;
        if ((n9 & 1) != 0 || n9 > 13 || n9 < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        n = (13 - n9) / 2;
        int n10 = SYMBOL_WIDEST[n];
        int n11 = 9 - n10;
        int n12 = RSSUtils.getRSSvalue(nArray2, n10, true);
        int n13 = RSSUtils.getRSSvalue(nArray3, n11, false);
        int n14 = EVEN_TOTAL_SUBSET[n];
        int n15 = GSUM[n];
        int n16 = n12 * n14 + n13 + n15;
        return new DataCharacter(n16, n2);
    }

    private static boolean isNotA1left(FinderPattern finderPattern, boolean bl, boolean bl2) {
        return finderPattern.getValue() != 0 || !bl || !bl2;
    }

    private void adjustOddEvenCounts(int n) throws NotFoundException {
        int n2 = RSSExpandedReader.count(this.oddCounts);
        int n3 = RSSExpandedReader.count(this.evenCounts);
        int n4 = n2 + n3 - n;
        boolean bl = (n2 & 1) == 1;
        boolean bl2 = (n3 & 1) == 0;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n2 > 13) {
            bl4 = true;
        } else if (n2 < 4) {
            bl3 = true;
        }
        boolean bl5 = false;
        boolean bl6 = false;
        if (n3 > 13) {
            bl6 = true;
        } else if (n3 < 4) {
            bl5 = true;
        }
        if (n4 == 1) {
            if (bl) {
                if (bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl4 = true;
            } else {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl6 = true;
            }
        } else if (n4 == -1) {
            if (bl) {
                if (bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl3 = true;
            } else {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl5 = true;
            }
        } else if (n4 == 0) {
            if (bl) {
                if (!bl2) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n2 < n3) {
                    bl3 = true;
                    bl6 = true;
                } else {
                    bl4 = true;
                    bl5 = true;
                }
            } else if (bl2) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl3) {
            if (bl4) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.oddCounts, this.oddRoundingErrors);
        }
        if (bl4) {
            RSSExpandedReader.decrement(this.oddCounts, this.oddRoundingErrors);
        }
        if (bl5) {
            if (bl6) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSSExpandedReader.increment(this.evenCounts, this.oddRoundingErrors);
        }
        if (bl6) {
            RSSExpandedReader.decrement(this.evenCounts, this.evenRoundingErrors);
        }
    }
}

