/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned.rss;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.ResultPointCallback;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.oned.rss.AbstractRSSReader;
import ai.com.google.zxing.oned.rss.DataCharacter;
import ai.com.google.zxing.oned.rss.FinderPattern;
import ai.com.google.zxing.oned.rss.Pair;
import ai.com.google.zxing.oned.rss.RSSUtils;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class RSS14Reader
extends AbstractRSSReader {
    private static final int[] OUTSIDE_EVEN_TOTAL_SUBSET = new int[]{1, 10, 34, 70, 126};
    private static final int[] INSIDE_ODD_TOTAL_SUBSET = new int[]{4, 20, 48, 81};
    private static final int[] OUTSIDE_GSUM = new int[]{0, 161, 961, 2015, 2715};
    private static final int[] INSIDE_GSUM = new int[]{0, 336, 1036, 1516};
    private static final int[] OUTSIDE_ODD_WIDEST = new int[]{8, 6, 4, 3, 1};
    private static final int[] INSIDE_ODD_WIDEST = new int[]{2, 4, 6, 8};
    private static final int[][] FINDER_PATTERNS = new int[][]{{3, 8, 2, 1}, {3, 5, 5, 1}, {3, 3, 7, 1}, {3, 1, 9, 1}, {2, 7, 4, 1}, {2, 5, 6, 1}, {2, 3, 8, 1}, {1, 5, 7, 1}, {1, 3, 9, 1}};
    private final Vector possibleLeftPairs = new Vector();
    private final Vector possibleRightPairs = new Vector();

    public Result decodeRow(int n, BitArray bitArray, Hashtable hashtable) throws NotFoundException {
        Pair pair = this.decodePair(bitArray, false, n, hashtable);
        RSS14Reader.addOrTally(this.possibleLeftPairs, pair);
        bitArray.reverse();
        Pair pair2 = this.decodePair(bitArray, true, n, hashtable);
        RSS14Reader.addOrTally(this.possibleRightPairs, pair2);
        bitArray.reverse();
        int n2 = this.possibleLeftPairs.size();
        int n3 = this.possibleRightPairs.size();
        for (int i = 0; i < n2; ++i) {
            Pair pair3 = (Pair)this.possibleLeftPairs.elementAt(i);
            if (pair3.getCount() <= 1) continue;
            for (int j = 0; j < n3; ++j) {
                Pair pair4 = (Pair)this.possibleRightPairs.elementAt(j);
                if (pair4.getCount() <= 1 || !RSS14Reader.checkChecksum(pair3, pair4)) continue;
                return RSS14Reader.constructResult(pair3, pair4);
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static void addOrTally(Vector vector, Pair pair) {
        if (pair == null) {
            return;
        }
        Enumeration enumeration = vector.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Pair pair2 = (Pair)enumeration.nextElement();
            if (pair2.getValue() != pair.getValue()) continue;
            pair2.incrementCount();
            bl = true;
            break;
        }
        if (!bl) {
            vector.addElement(pair);
        }
    }

    public void reset() {
        this.possibleLeftPairs.setSize(0);
        this.possibleRightPairs.setSize(0);
    }

    private static Result constructResult(Pair pair, Pair pair2) {
        int n;
        long l = 4537077L * (long)pair.getValue() + (long)pair2.getValue();
        String string = String.valueOf(l);
        StringBuffer stringBuffer = new StringBuffer(14);
        for (n = 13 - string.length(); n > 0; --n) {
            stringBuffer.append('0');
        }
        stringBuffer.append(string);
        n = 0;
        for (int i = 0; i < 13; ++i) {
            int n2 = stringBuffer.charAt(i) - 48;
            n += (i & 1) == 0 ? 3 * n2 : n2;
        }
        if ((n = 10 - n % 10) == 10) {
            n = 0;
        }
        stringBuffer.append(n);
        ResultPoint[] resultPointArray = pair.getFinderPattern().getResultPoints();
        ResultPoint[] resultPointArray2 = pair2.getFinderPattern().getResultPoints();
        return new Result(String.valueOf(stringBuffer.toString()), null, new ResultPoint[]{resultPointArray[0], resultPointArray[1], resultPointArray2[0], resultPointArray2[1]}, BarcodeFormat.RSS_14);
    }

    private static boolean checkChecksum(Pair pair, Pair pair2) {
        int n = pair.getFinderPattern().getValue();
        int n2 = pair2.getFinderPattern().getValue();
        if (n == 0 && n2 == 8 || n != 8 || n2 == 0) {
            // empty if block
        }
        int n3 = (pair.getChecksumPortion() + 16 * pair2.getChecksumPortion()) % 79;
        int n4 = 9 * pair.getFinderPattern().getValue() + pair2.getFinderPattern().getValue();
        if (n4 > 72) {
            --n4;
        }
        if (n4 > 8) {
            --n4;
        }
        return n3 == n4;
    }

    private Pair decodePair(BitArray bitArray, boolean bl, int n, Hashtable hashtable) {
        try {
            ResultPointCallback resultPointCallback;
            int[] nArray = this.findFinderPattern(bitArray, 0, bl);
            FinderPattern finderPattern = this.parseFoundFinderPattern(bitArray, n, bl, nArray);
            ResultPointCallback resultPointCallback2 = resultPointCallback = hashtable == null ? null : (ResultPointCallback)hashtable.get(DecodeHintType.NEED_RESULT_POINT_CALLBACK);
            if (resultPointCallback != null) {
                float f = (float)(nArray[0] + nArray[1]) / 2.0f;
                if (bl) {
                    f = (float)(bitArray.getSize() - 1) - f;
                }
                resultPointCallback.foundPossibleResultPoint(new ResultPoint(f, n));
            }
            DataCharacter dataCharacter = this.decodeDataCharacter(bitArray, finderPattern, true);
            DataCharacter dataCharacter2 = this.decodeDataCharacter(bitArray, finderPattern, false);
            return new Pair(1597 * dataCharacter.getValue() + dataCharacter2.getValue(), dataCharacter.getChecksumPortion() + 4 * dataCharacter2.getChecksumPortion(), finderPattern);
        }
        catch (NotFoundException notFoundException) {
            return null;
        }
    }

    private DataCharacter decodeDataCharacter(BitArray bitArray, FinderPattern finderPattern, boolean bl) throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = this.dataCharacterCounters;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        nArray[4] = 0;
        nArray[5] = 0;
        nArray[6] = 0;
        nArray[7] = 0;
        if (bl) {
            RSS14Reader.recordPatternInReverse(bitArray, finderPattern.getStartEnd()[0], nArray);
        } else {
            RSS14Reader.recordPattern(bitArray, finderPattern.getStartEnd()[1] + 1, nArray);
            n5 = 0;
            for (int i = nArray.length - 1; n5 < i; ++n5, --i) {
                int n6 = nArray[n5];
                nArray[n5] = nArray[i];
                nArray[i] = n6;
            }
        }
        n5 = bl ? 16 : 15;
        float f = (float)RSS14Reader.count(nArray) / (float)n5;
        int[] nArray2 = this.oddCounts;
        int[] nArray3 = this.evenCounts;
        float[] fArray = this.oddRoundingErrors;
        float[] fArray2 = this.evenRoundingErrors;
        for (n4 = 0; n4 < nArray.length; ++n4) {
            float f2 = (float)nArray[n4] / f;
            n3 = (int)(f2 + 0.5f);
            if (n3 < 1) {
                n3 = 1;
            } else if (n3 > 8) {
                n3 = 8;
            }
            n2 = n4 >> 1;
            if ((n4 & 1) == 0) {
                nArray2[n2] = n3;
                fArray[n2] = f2 - (float)n3;
                continue;
            }
            nArray3[n2] = n3;
            fArray2[n2] = f2 - (float)n3;
        }
        this.adjustOddEvenCounts(bl, n5);
        n4 = 0;
        int n7 = 0;
        for (n3 = nArray2.length - 1; n3 >= 0; --n3) {
            n7 *= 9;
            n7 += nArray2[n3];
            n4 += nArray2[n3];
        }
        n3 = 0;
        n2 = 0;
        for (n = nArray3.length - 1; n >= 0; --n) {
            n3 *= 9;
            n3 += nArray3[n];
            n2 += nArray3[n];
        }
        n = n7 + 3 * n3;
        if (bl) {
            if ((n4 & 1) != 0 || n4 > 12 || n4 < 4) {
                throw NotFoundException.getNotFoundInstance();
            }
            int n8 = (12 - n4) / 2;
            int n9 = OUTSIDE_ODD_WIDEST[n8];
            int n10 = 9 - n9;
            int n11 = RSSUtils.getRSSvalue(nArray2, n9, false);
            int n12 = RSSUtils.getRSSvalue(nArray3, n10, true);
            int n13 = OUTSIDE_EVEN_TOTAL_SUBSET[n8];
            int n14 = OUTSIDE_GSUM[n8];
            return new DataCharacter(n11 * n13 + n12 + n14, n);
        }
        if ((n2 & 1) != 0 || n2 > 10 || n2 < 4) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n15 = (10 - n2) / 2;
        int n16 = INSIDE_ODD_WIDEST[n15];
        int n17 = 9 - n16;
        int n18 = RSSUtils.getRSSvalue(nArray2, n16, true);
        int n19 = RSSUtils.getRSSvalue(nArray3, n17, false);
        int n20 = INSIDE_ODD_TOTAL_SUBSET[n15];
        int n21 = INSIDE_GSUM[n15];
        return new DataCharacter(n19 * n20 + n18 + n21, n);
    }

    private int[] findFinderPattern(BitArray bitArray, int n, boolean bl) throws NotFoundException {
        int[] nArray = this.decodeFinderCounters;
        nArray[0] = 0;
        nArray[1] = 0;
        nArray[2] = 0;
        nArray[3] = 0;
        int n2 = bitArray.getSize();
        boolean bl2 = false;
        while (n < n2) {
            boolean bl3 = bl2 = !bitArray.get(n);
            if (bl == bl2) break;
            ++n;
        }
        int n3 = 0;
        int n4 = n;
        for (int i = n; i < n2; ++i) {
            boolean bl4 = bitArray.get(i);
            if (bl4 ^ bl2) {
                int n5 = n3;
                nArray[n5] = nArray[n5] + 1;
                continue;
            }
            if (n3 == 3) {
                if (RSS14Reader.isFinderPattern(nArray)) {
                    return new int[]{n4, i};
                }
                n4 += nArray[0] + nArray[1];
                nArray[0] = nArray[2];
                nArray[1] = nArray[3];
                nArray[2] = 0;
                nArray[3] = 0;
                --n3;
            } else {
                ++n3;
            }
            nArray[n3] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private FinderPattern parseFoundFinderPattern(BitArray bitArray, int n, boolean bl, int[] nArray) throws NotFoundException {
        int n2;
        int n3;
        boolean bl2 = bitArray.get(nArray[0]);
        for (n3 = nArray[0] - 1; n3 >= 0 && bl2 ^ bitArray.get(n3); --n3) {
        }
        int n4 = nArray[0] - ++n3;
        int[] nArray2 = this.decodeFinderCounters;
        for (n2 = nArray2.length - 1; n2 > 0; --n2) {
            nArray2[n2] = nArray2[n2 - 1];
        }
        nArray2[0] = n4;
        n2 = RSS14Reader.parseFinderValue(nArray2, FINDER_PATTERNS);
        int n5 = n3;
        int n6 = nArray[1];
        if (bl) {
            n5 = bitArray.getSize() - 1 - n5;
            n6 = bitArray.getSize() - 1 - n6;
        }
        return new FinderPattern(n2, new int[]{n3, nArray[1]}, n5, n6, n);
    }

    private void adjustOddEvenCounts(boolean bl, int n) throws NotFoundException {
        int n2 = RSS14Reader.count(this.oddCounts);
        int n3 = RSS14Reader.count(this.evenCounts);
        int n4 = n2 + n3 - n;
        boolean bl2 = (n2 & 1) == (bl ? 1 : 0);
        boolean bl3 = (n3 & 1) == 1;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl) {
            if (n2 > 12) {
                bl5 = true;
            } else if (n2 < 4) {
                bl4 = true;
            }
            if (n3 > 12) {
                bl7 = true;
            } else if (n3 < 4) {
                bl6 = true;
            }
        } else {
            if (n2 > 11) {
                bl5 = true;
            } else if (n2 < 5) {
                bl4 = true;
            }
            if (n3 > 10) {
                bl7 = true;
            } else if (n3 < 4) {
                bl6 = true;
            }
        }
        if (n4 == 1) {
            if (bl2) {
                if (bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl5 = true;
            } else {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl7 = true;
            }
        } else if (n4 == -1) {
            if (bl2) {
                if (bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl4 = true;
            } else {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                bl6 = true;
            }
        } else if (n4 == 0) {
            if (bl2) {
                if (!bl3) {
                    throw NotFoundException.getNotFoundInstance();
                }
                if (n2 < n3) {
                    bl4 = true;
                    bl7 = true;
                } else {
                    bl5 = true;
                    bl6 = true;
                }
            } else if (bl3) {
                throw NotFoundException.getNotFoundInstance();
            }
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (bl4) {
            if (bl5) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.oddCounts, this.oddRoundingErrors);
        }
        if (bl5) {
            RSS14Reader.decrement(this.oddCounts, this.oddRoundingErrors);
        }
        if (bl6) {
            if (bl7) {
                throw NotFoundException.getNotFoundInstance();
            }
            RSS14Reader.increment(this.evenCounts, this.oddRoundingErrors);
        }
        if (bl7) {
            RSS14Reader.decrement(this.evenCounts, this.evenRoundingErrors);
        }
    }
}

