/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.Writer;
import ai.com.google.zxing.WriterException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.oned.UPCEANReader;
import java.util.Hashtable;

public abstract class UPCEANWriter
implements Writer {
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) throws WriterException {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Requested dimensions are too small: " + n + 'x' + n2);
        }
        byte[] byArray = this.encode(string);
        return UPCEANWriter.renderResult(byArray, n, n2);
    }

    private static BitMatrix renderResult(byte[] byArray, int n, int n2) {
        int n3 = byArray.length;
        int n4 = n3 + (UPCEANReader.START_END_PATTERN.length << 1);
        int n5 = Math.max(n, n4);
        int n6 = Math.max(1, n2);
        int n7 = n5 / n4;
        int n8 = (n5 - n3 * n7) / 2;
        BitMatrix bitMatrix = new BitMatrix(n5, n6);
        int n9 = 0;
        int n10 = n8;
        while (n9 < n3) {
            if (byArray[n9] == 1) {
                bitMatrix.setRegion(n10, 0, n7, n6);
            }
            ++n9;
            n10 += n7;
        }
        return bitMatrix;
    }

    protected static int appendPattern(byte[] byArray, int n, int[] nArray, int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("startColor must be either 0 or 1, but got: " + n2);
        }
        byte by = (byte)n2;
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i]; ++j) {
                byArray[n] = by;
                ++n;
                ++n3;
            }
            by = (byte)(by ^ 1);
        }
        return n3;
    }

    public abstract byte[] encode(String var1);
}

