/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.Writer;
import ai.com.google.zxing.WriterException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.oned.EAN13Writer;
import java.util.Hashtable;

public class UPCAWriter
implements Writer {
    private final EAN13Writer subWriter = new EAN13Writer();

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) throws WriterException {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (barcodeFormat != BarcodeFormat.UPC_A) {
            throw new IllegalArgumentException("Can only encode UPC-A, but got " + barcodeFormat);
        }
        return this.subWriter.encode(UPCAWriter.preencode(string), BarcodeFormat.EAN_13, n, n2, hashtable);
    }

    private static String preencode(String string) {
        int n = string.length();
        if (n == 11) {
            int n2 = 0;
            for (int i = 0; i < 11; ++i) {
                n2 += (string.charAt(i) - 48) * (i % 2 == 0 ? 3 : 1);
            }
            string = string + (1000 - n2) % 10;
        } else if (n != 12) {
            throw new IllegalArgumentException("Requested contents should be 11 or 12 digits long, but got " + string.length());
        }
        return '0' + string;
    }
}

