/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.WriterException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.oned.EAN13Reader;
import ai.com.google.zxing.oned.UPCEANReader;
import ai.com.google.zxing.oned.UPCEANWriter;
import java.util.Hashtable;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int codeWidth = 95;

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (barcodeFormat != BarcodeFormat.EAN_13) {
            throw new IllegalArgumentException("Can only encode EAN_13, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, hashtable);
    }

    public byte[] encode(String string) {
        int n;
        int n2;
        if (string.length() != 13) {
            throw new IllegalArgumentException("Requested contents should be 13 digits long, but got " + string.length());
        }
        int n3 = Integer.parseInt(string.substring(0, 1));
        int n4 = EAN13Reader.FIRST_DIGIT_ENCODINGS[n3];
        byte[] byArray = new byte[95];
        int n5 = 0;
        n5 += EAN13Writer.appendPattern(byArray, n5, UPCEANReader.START_END_PATTERN, 1);
        for (n2 = 1; n2 <= 6; ++n2) {
            n = Integer.parseInt(string.substring(n2, n2 + 1));
            if ((n4 >> 6 - n2 & 1) == 1) {
                n += 10;
            }
            n5 += EAN13Writer.appendPattern(byArray, n5, UPCEANReader.L_AND_G_PATTERNS[n], 0);
        }
        n5 += EAN13Writer.appendPattern(byArray, n5, UPCEANReader.MIDDLE_PATTERN, 0);
        for (n2 = 7; n2 <= 12; ++n2) {
            n = Integer.parseInt(string.substring(n2, n2 + 1));
            n5 += EAN13Writer.appendPattern(byArray, n5, UPCEANReader.L_PATTERNS[n], 1);
        }
        n5 += EAN13Writer.appendPattern(byArray, n5, UPCEANReader.START_END_PATTERN, 1);
        return byArray;
    }
}

