/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.oned;

import ai.com.google.zxing.BarcodeFormat;
import ai.com.google.zxing.WriterException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.oned.Code128Reader;
import ai.com.google.zxing.oned.UPCEANWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Code128Writer
extends UPCEANWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Hashtable hashtable) throws WriterException {
        if (barcodeFormat != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, hashtable);
    }

    public byte[] encode(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.length();
        if (n4 < 1 || n4 > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + n4);
        }
        for (int i = 0; i < n4; ++i) {
            n3 = string.charAt(i);
            if (n3 >= 32 && n3 <= 126) continue;
            throw new IllegalArgumentException("Contents should only contain characters between ' ' and '~'");
        }
        Vector<int[]> vector = new Vector<int[]>();
        n3 = 0;
        int n5 = 1;
        int n6 = 0;
        int n7 = 0;
        while (n7 < n4) {
            int n8;
            n2 = n6 == 99 ? 2 : 4;
            int n9 = n4 - n7 >= n2 && Code128Writer.isDigits(string, n7, n2) ? 99 : 100;
            if (n9 == n6) {
                if (n6 == 100) {
                    n8 = string.charAt(n7) - 32;
                    ++n7;
                } else {
                    n8 = Integer.parseInt(string.substring(n7, n7 + 2));
                    n7 += 2;
                }
            } else {
                n8 = n6 == 0 ? (n9 == 100 ? 104 : 105) : n9;
                n6 = n9;
            }
            vector.addElement(Code128Reader.CODE_PATTERNS[n8]);
            n3 += n8 * n5;
            if (n7 == 0) continue;
            ++n5;
        }
        vector.addElement(Code128Reader.CODE_PATTERNS[n3 %= 103]);
        vector.addElement(Code128Reader.CODE_PATTERNS[106]);
        n2 = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            for (n = 0; n < nArray.length; ++n) {
                n2 += nArray[n];
            }
        }
        byte[] byArray = new byte[n2];
        enumeration = vector.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            int[] nArray = (int[])enumeration.nextElement();
            n += Code128Writer.appendPattern(byArray, n, nArray, 1);
        }
        return byArray;
    }

    private static boolean isDigits(String string, int n, int n2) {
        int n3 = n + n2;
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }
}

