/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.multi.qrcode.detector;

import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.ReaderException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.DetectorResult;
import ai.com.google.zxing.multi.qrcode.detector.MultiFinderPatternFinder;
import ai.com.google.zxing.qrcode.detector.Detector;
import ai.com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.util.Hashtable;
import java.util.Vector;

public final class MultiDetector
extends Detector {
    private static final DetectorResult[] EMPTY_DETECTOR_RESULTS = new DetectorResult[0];

    public MultiDetector(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    public DetectorResult[] detectMulti(Hashtable hashtable) throws NotFoundException {
        BitMatrix bitMatrix = this.getImage();
        MultiFinderPatternFinder multiFinderPatternFinder = new MultiFinderPatternFinder(bitMatrix);
        FinderPatternInfo[] finderPatternInfoArray = multiFinderPatternFinder.findMulti(hashtable);
        if (finderPatternInfoArray == null || finderPatternInfoArray.length == 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        Vector<DetectorResult> vector = new Vector<DetectorResult>();
        for (int i = 0; i < finderPatternInfoArray.length; ++i) {
            try {
                vector.addElement(this.processFinderPatternInfo(finderPatternInfoArray[i]));
                continue;
            }
            catch (ReaderException readerException) {
                // empty catch block
            }
        }
        if (vector.isEmpty()) {
            return EMPTY_DETECTOR_RESULTS;
        }
        DetectorResult[] detectorResultArray = new DetectorResult[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            detectorResultArray[i] = (DetectorResult)vector.elementAt(i);
        }
        return detectorResultArray;
    }
}

