/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.multi;

import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Reader;
import ai.com.google.zxing.ReaderException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.multi.MultipleBarcodeReader;
import java.util.Hashtable;
import java.util.Vector;

public final class GenericMultipleBarcodeReader
implements MultipleBarcodeReader {
    private static final int MIN_DIMENSION_TO_RECUR = 100;
    private final Reader delegate;

    public GenericMultipleBarcodeReader(Reader reader) {
        this.delegate = reader;
    }

    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) throws NotFoundException {
        return this.decodeMultiple(binaryBitmap, null);
    }

    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Hashtable hashtable) throws NotFoundException {
        Vector vector = new Vector();
        this.doDecodeMultiple(binaryBitmap, hashtable, vector, 0, 0);
        if (vector.isEmpty()) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n = vector.size();
        Result[] resultArray = new Result[n];
        for (int i = 0; i < n; ++i) {
            resultArray[i] = (Result)vector.elementAt(i);
        }
        return resultArray;
    }

    private void doDecodeMultiple(BinaryBitmap binaryBitmap, Hashtable hashtable, Vector vector, int n, int n2) {
        Result result;
        try {
            result = this.delegate.decode(binaryBitmap, hashtable);
        }
        catch (ReaderException readerException) {
            return;
        }
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            Result result2 = (Result)vector.elementAt(i);
            if (!result2.getText().equals(result.getText())) continue;
            bl = true;
            break;
        }
        if (bl) {
            return;
        }
        vector.addElement(GenericMultipleBarcodeReader.translateResultPoints(result, n, n2));
        ResultPoint[] resultPointArray = result.getResultPoints();
        if (resultPointArray == null || resultPointArray.length == 0) {
            return;
        }
        int n3 = binaryBitmap.getWidth();
        int n4 = binaryBitmap.getHeight();
        float f = n3;
        float f2 = n4;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < resultPointArray.length; ++i) {
            ResultPoint resultPoint = resultPointArray[i];
            float f5 = resultPoint.getX();
            float f6 = resultPoint.getY();
            if (f5 < f) {
                f = f5;
            }
            if (f6 < f2) {
                f2 = f6;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            if (!(f6 > f4)) continue;
            f4 = f6;
        }
        if (f > 100.0f) {
            this.doDecodeMultiple(binaryBitmap.crop(0, 0, (int)f, n4), hashtable, vector, n, n2);
        }
        if (f2 > 100.0f) {
            this.doDecodeMultiple(binaryBitmap.crop(0, 0, n3, (int)f2), hashtable, vector, n, n2);
        }
        if (f3 < (float)(n3 - 100)) {
            this.doDecodeMultiple(binaryBitmap.crop((int)f3, 0, n3 - (int)f3, n4), hashtable, vector, n + (int)f3, n2);
        }
        if (f4 < (float)(n4 - 100)) {
            this.doDecodeMultiple(binaryBitmap.crop(0, (int)f4, n3, n4 - (int)f4), hashtable, vector, n, n2 + (int)f4);
        }
    }

    private static Result translateResultPoints(Result result, int n, int n2) {
        ResultPoint[] resultPointArray = result.getResultPoints();
        ResultPoint[] resultPointArray2 = new ResultPoint[resultPointArray.length];
        for (int i = 0; i < resultPointArray.length; ++i) {
            ResultPoint resultPoint = resultPointArray[i];
            resultPointArray2[i] = new ResultPoint(resultPoint.getX() + (float)n, resultPoint.getY() + (float)n2);
        }
        return new Result(result.getText(), result.getRawBytes(), resultPointArray2, result.getBarcodeFormat());
    }
}

