/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.common.reedsolomon;

import ai.com.google.zxing.common.reedsolomon.GenericGF;
import ai.com.google.zxing.common.reedsolomon.GenericGFPoly;
import java.util.Vector;

public final class ReedSolomonEncoder {
    private final GenericGF field;
    private final Vector cachedGenerators;

    public ReedSolomonEncoder(GenericGF genericGF) {
        if (!GenericGF.QR_CODE_FIELD_256.equals(genericGF)) {
            throw new IllegalArgumentException("Only QR Code is supported at this time");
        }
        this.field = genericGF;
        this.cachedGenerators = new Vector();
        this.cachedGenerators.addElement(new GenericGFPoly(genericGF, new int[]{1}));
    }

    private GenericGFPoly buildGenerator(int n) {
        if (n >= this.cachedGenerators.size()) {
            GenericGFPoly genericGFPoly = (GenericGFPoly)this.cachedGenerators.elementAt(this.cachedGenerators.size() - 1);
            for (int i = this.cachedGenerators.size(); i <= n; ++i) {
                GenericGFPoly genericGFPoly2 = genericGFPoly.multiply(new GenericGFPoly(this.field, new int[]{1, this.field.exp(i - 1)}));
                this.cachedGenerators.addElement(genericGFPoly2);
                genericGFPoly = genericGFPoly2;
            }
        }
        return (GenericGFPoly)this.cachedGenerators.elementAt(n);
    }

    public void encode(int[] nArray, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int n2 = nArray.length - n;
        if (n2 <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GenericGFPoly genericGFPoly = this.buildGenerator(n);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        GenericGFPoly genericGFPoly2 = new GenericGFPoly(this.field, nArray2);
        genericGFPoly2 = genericGFPoly2.multiplyByMonomial(n, 1);
        GenericGFPoly genericGFPoly3 = genericGFPoly2.divide(genericGFPoly)[1];
        int[] nArray3 = genericGFPoly3.getCoefficients();
        int n3 = n - nArray3.length;
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = 0;
        }
        System.arraycopy(nArray3, 0, nArray, n2 + n3, nArray3.length);
    }
}

