/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.common.reedsolomon;

import ai.com.google.zxing.common.reedsolomon.GenericGF;
import ai.com.google.zxing.common.reedsolomon.GenericGFPoly;
import ai.com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class ReedSolomonDecoder {
    private final GenericGF field;

    public ReedSolomonDecoder(GenericGF genericGF) {
        this.field = genericGF;
    }

    public void decode(int[] nArray, int n) throws ReedSolomonException {
        GenericGFPoly genericGFPoly = new GenericGFPoly(this.field, nArray);
        int[] nArray2 = new int[n];
        boolean bl = this.field.equals(GenericGF.DATA_MATRIX_FIELD_256);
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            int n2;
            nArray2[nArray2.length - 1 - i] = n2 = genericGFPoly.evaluateAt(this.field.exp(bl ? i + 1 : i));
            if (n2 == 0) continue;
            bl2 = false;
        }
        if (bl2) {
            return;
        }
        GenericGFPoly genericGFPoly2 = new GenericGFPoly(this.field, nArray2);
        GenericGFPoly[] genericGFPolyArray = this.runEuclideanAlgorithm(this.field.buildMonomial(n, 1), genericGFPoly2, n);
        GenericGFPoly genericGFPoly3 = genericGFPolyArray[0];
        GenericGFPoly genericGFPoly4 = genericGFPolyArray[1];
        int[] nArray3 = this.findErrorLocations(genericGFPoly3);
        int[] nArray4 = this.findErrorMagnitudes(genericGFPoly4, nArray3, bl);
        for (int i = 0; i < nArray3.length; ++i) {
            int n3 = nArray.length - 1 - this.field.log(nArray3[i]);
            if (n3 < 0) {
                throw new ReedSolomonException("Bad error location");
            }
            nArray[n3] = GenericGF.addOrSubtract(nArray[n3], nArray4[i]);
        }
    }

    private GenericGFPoly[] runEuclideanAlgorithm(GenericGFPoly genericGFPoly, GenericGFPoly genericGFPoly2, int n) throws ReedSolomonException {
        GenericGFPoly genericGFPoly3;
        GenericGFPoly genericGFPoly4;
        GenericGFPoly genericGFPoly5;
        if (genericGFPoly.getDegree() < genericGFPoly2.getDegree()) {
            genericGFPoly5 = genericGFPoly;
            genericGFPoly = genericGFPoly2;
            genericGFPoly2 = genericGFPoly5;
        }
        genericGFPoly5 = genericGFPoly;
        GenericGFPoly genericGFPoly6 = genericGFPoly2;
        GenericGFPoly genericGFPoly7 = this.field.getOne();
        GenericGFPoly genericGFPoly8 = this.field.getZero();
        GenericGFPoly genericGFPoly9 = this.field.getZero();
        GenericGFPoly genericGFPoly10 = this.field.getOne();
        while (genericGFPoly6.getDegree() >= n / 2) {
            GenericGFPoly genericGFPoly11 = genericGFPoly5;
            GenericGFPoly genericGFPoly12 = genericGFPoly7;
            genericGFPoly4 = genericGFPoly9;
            genericGFPoly5 = genericGFPoly6;
            genericGFPoly7 = genericGFPoly8;
            genericGFPoly9 = genericGFPoly10;
            if (genericGFPoly5.isZero()) {
                throw new ReedSolomonException("r_{i-1} was zero");
            }
            genericGFPoly6 = genericGFPoly11;
            genericGFPoly3 = this.field.getZero();
            int n2 = genericGFPoly5.getCoefficient(genericGFPoly5.getDegree());
            int n3 = this.field.inverse(n2);
            while (genericGFPoly6.getDegree() >= genericGFPoly5.getDegree() && !genericGFPoly6.isZero()) {
                int n4 = genericGFPoly6.getDegree() - genericGFPoly5.getDegree();
                int n5 = this.field.multiply(genericGFPoly6.getCoefficient(genericGFPoly6.getDegree()), n3);
                genericGFPoly3 = genericGFPoly3.addOrSubtract(this.field.buildMonomial(n4, n5));
                genericGFPoly6 = genericGFPoly6.addOrSubtract(genericGFPoly5.multiplyByMonomial(n4, n5));
            }
            genericGFPoly8 = genericGFPoly3.multiply(genericGFPoly7).addOrSubtract(genericGFPoly12);
            genericGFPoly10 = genericGFPoly3.multiply(genericGFPoly9).addOrSubtract(genericGFPoly4);
        }
        int n6 = genericGFPoly10.getCoefficient(0);
        if (n6 == 0) {
            throw new ReedSolomonException("sigmaTilde(0) was zero");
        }
        int n7 = this.field.inverse(n6);
        genericGFPoly4 = genericGFPoly10.multiply(n7);
        genericGFPoly3 = genericGFPoly6.multiply(n7);
        return new GenericGFPoly[]{genericGFPoly4, genericGFPoly3};
    }

    private int[] findErrorLocations(GenericGFPoly genericGFPoly) throws ReedSolomonException {
        int n = genericGFPoly.getDegree();
        if (n == 1) {
            return new int[]{genericGFPoly.getCoefficient(1)};
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 1; i < this.field.getSize() && n2 < n; ++i) {
            if (genericGFPoly.evaluateAt(i) != 0) continue;
            nArray[n2] = this.field.inverse(i);
            ++n2;
        }
        if (n2 != n) {
            throw new ReedSolomonException("Error locator degree does not match number of roots");
        }
        return nArray;
    }

    private int[] findErrorMagnitudes(GenericGFPoly genericGFPoly, int[] nArray, boolean bl) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = this.field.inverse(nArray[i]);
            int n3 = 1;
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                int n4 = this.field.multiply(nArray[j], n2);
                int n5 = (n4 & 1) == 0 ? n4 | 1 : n4 & 0xFFFFFFFE;
                n3 = this.field.multiply(n3, n5);
            }
            nArray2[i] = this.field.multiply(genericGFPoly.evaluateAt(n2), this.field.inverse(n3));
            if (!bl) continue;
            nArray2[i] = this.field.multiply(nArray2[i], n2);
        }
        return nArray2;
    }
}

