/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.common.detector;

import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.common.BitMatrix;

public final class WhiteRectangleDetector {
    private static final int INIT_SIZE = 30;
    private static final int CORR = 1;
    private final BitMatrix image;
    private final int height;
    private final int width;
    private final int leftInit;
    private final int rightInit;
    private final int downInit;
    private final int upInit;

    public WhiteRectangleDetector(BitMatrix bitMatrix) throws NotFoundException {
        this.image = bitMatrix;
        this.height = bitMatrix.getHeight();
        this.width = bitMatrix.getWidth();
        this.leftInit = this.width - 30 >> 1;
        this.rightInit = this.width + 30 >> 1;
        this.upInit = this.height - 30 >> 1;
        this.downInit = this.height + 30 >> 1;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public WhiteRectangleDetector(BitMatrix bitMatrix, int n, int n2, int n3) throws NotFoundException {
        this.image = bitMatrix;
        this.height = bitMatrix.getHeight();
        this.width = bitMatrix.getWidth();
        int n4 = n >> 1;
        this.leftInit = n2 - n4;
        this.rightInit = n2 + n4;
        this.upInit = n3 - n4;
        this.downInit = n3 + n4;
        if (this.upInit < 0 || this.leftInit < 0 || this.downInit >= this.height || this.rightInit >= this.width) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    public ResultPoint[] detect() throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4 = this.leftInit;
        int n5 = this.rightInit;
        int n6 = this.upInit;
        int n7 = this.downInit;
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        while (bl2) {
            bl2 = false;
            n3 = 1;
            while (n3 != 0 && n5 < this.width) {
                n3 = this.containsBlackPoint(n6, n7, n5, false) ? 1 : 0;
                if (n3 == 0) continue;
                ++n5;
                bl2 = true;
            }
            if (n5 >= this.width) {
                bl = true;
                break;
            }
            boolean bl4 = true;
            while (bl4 && n7 < this.height) {
                bl4 = this.containsBlackPoint(n4, n5, n7, true);
                if (!bl4) continue;
                ++n7;
                bl2 = true;
            }
            if (n7 >= this.height) {
                bl = true;
                break;
            }
            n2 = 1;
            while (n2 != 0 && n4 >= 0) {
                n2 = this.containsBlackPoint(n6, n7, n4, false) ? 1 : 0;
                if (n2 == 0) continue;
                --n4;
                bl2 = true;
            }
            if (n4 < 0) {
                bl = true;
                break;
            }
            n = 1;
            while (n != 0 && n6 >= 0) {
                n = this.containsBlackPoint(n4, n5, n6, true) ? 1 : 0;
                if (n == 0) continue;
                --n6;
                bl2 = true;
            }
            if (n6 < 0) {
                bl = true;
                break;
            }
            if (!bl2) continue;
            bl3 = true;
        }
        if (!bl && bl3) {
            n3 = n5 - n4;
            ResultPoint resultPoint = null;
            for (n2 = 1; n2 < n3 && (resultPoint = this.getBlackPointOnSegment(n4, n7 - n2, n4 + n2, n7)) == null; ++n2) {
            }
            if (resultPoint == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint2 = null;
            for (n = 1; n < n3 && (resultPoint2 = this.getBlackPointOnSegment(n4, n6 + n, n4 + n, n6)) == null; ++n) {
            }
            if (resultPoint2 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint3 = null;
            for (int i = 1; i < n3 && (resultPoint3 = this.getBlackPointOnSegment(n5, n6 + i, n5 - i, n6)) == null; ++i) {
            }
            if (resultPoint3 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            ResultPoint resultPoint4 = null;
            for (int i = 1; i < n3 && (resultPoint4 = this.getBlackPointOnSegment(n5, n7 - i, n5 - i, n7)) == null; ++i) {
            }
            if (resultPoint4 == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            return this.centerEdges(resultPoint4, resultPoint, resultPoint3, resultPoint2);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int round(float f) {
        return (int)(f + 0.5f);
    }

    private ResultPoint getBlackPointOnSegment(float f, float f2, float f3, float f4) {
        int n = WhiteRectangleDetector.distanceL2(f, f2, f3, f4);
        float f5 = (f3 - f) / (float)n;
        float f6 = (f4 - f2) / (float)n;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3 = WhiteRectangleDetector.round(f + (float)i * f5);
            if (!this.image.get(n3, n2 = WhiteRectangleDetector.round(f2 + (float)i * f6))) continue;
            return new ResultPoint(n3, n2);
        }
        return null;
    }

    private static int distanceL2(float f, float f2, float f3, float f4) {
        float f5 = f - f3;
        float f6 = f2 - f4;
        return WhiteRectangleDetector.round((float)Math.sqrt(f5 * f5 + f6 * f6));
    }

    private ResultPoint[] centerEdges(ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) {
        float f = resultPoint.getX();
        float f2 = resultPoint.getY();
        float f3 = resultPoint2.getX();
        float f4 = resultPoint2.getY();
        float f5 = resultPoint3.getX();
        float f6 = resultPoint3.getY();
        float f7 = resultPoint4.getX();
        float f8 = resultPoint4.getY();
        if (f < (float)(this.width / 2)) {
            return new ResultPoint[]{new ResultPoint(f7 - 1.0f, f8 + 1.0f), new ResultPoint(f3 + 1.0f, f4 + 1.0f), new ResultPoint(f5 - 1.0f, f6 - 1.0f), new ResultPoint(f + 1.0f, f2 - 1.0f)};
        }
        return new ResultPoint[]{new ResultPoint(f7 + 1.0f, f8 + 1.0f), new ResultPoint(f3 + 1.0f, f4 - 1.0f), new ResultPoint(f5 - 1.0f, f6 + 1.0f), new ResultPoint(f - 1.0f, f2 - 1.0f)};
    }

    private boolean containsBlackPoint(int n, int n2, int n3, boolean bl) {
        if (bl) {
            for (int i = n; i <= n2; ++i) {
                if (!this.image.get(i, n3)) continue;
                return true;
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                if (!this.image.get(n3, i)) continue;
                return true;
            }
        }
        return false;
    }
}

