/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.common;

import ai.com.google.zxing.Binarizer;
import ai.com.google.zxing.LuminanceSource;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int MINIMUM_DIMENSION = 40;
    private BitMatrix matrix = null;

    public HybridBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    public BitMatrix getBlackMatrix() throws NotFoundException {
        this.binarizeEntireImage();
        return this.matrix;
    }

    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizer(luminanceSource);
    }

    private void binarizeEntireImage() throws NotFoundException {
        if (this.matrix == null) {
            LuminanceSource luminanceSource = this.getLuminanceSource();
            if (luminanceSource.getWidth() >= 40 && luminanceSource.getHeight() >= 40) {
                byte[] byArray = luminanceSource.getMatrix();
                int n = luminanceSource.getWidth();
                int n2 = luminanceSource.getHeight();
                int n3 = n >> 3;
                if ((n & 7) != 0) {
                    ++n3;
                }
                int n4 = n2 >> 3;
                if ((n2 & 7) != 0) {
                    ++n4;
                }
                int[][] nArray = HybridBinarizer.calculateBlackPoints(byArray, n3, n4, n, n2);
                this.matrix = new BitMatrix(n, n2);
                HybridBinarizer.calculateThresholdForBlock(byArray, n3, n4, n, n2, nArray, this.matrix);
            } else {
                this.matrix = super.getBlackMatrix();
            }
        }
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n, int n2, int n3, int n4, int[][] nArray, BitMatrix bitMatrix) {
        for (int i = 0; i < n2; ++i) {
            int n5 = i << 3;
            if (n5 + 8 >= n4) {
                n5 = n4 - 8;
            }
            for (int j = 0; j < n; ++j) {
                int n6;
                int n7 = j << 3;
                if (n7 + 8 >= n3) {
                    n7 = n3 - 8;
                }
                int n8 = j > 1 ? j : 2;
                n8 = n8 < n - 2 ? n8 : n - 3;
                int n9 = i > 1 ? i : 2;
                n9 = n9 < n2 - 2 ? n9 : n2 - 3;
                int n10 = 0;
                for (n6 = -2; n6 <= 2; ++n6) {
                    int[] nArray2 = nArray[n9 + n6];
                    n10 += nArray2[n8 - 2];
                    n10 += nArray2[n8 - 1];
                    n10 += nArray2[n8];
                    n10 += nArray2[n8 + 1];
                    n10 += nArray2[n8 + 2];
                }
                n6 = n10 / 25;
                HybridBinarizer.threshold8x8Block(byArray, n7, n5, n6, n3, bitMatrix);
            }
        }
    }

    private static void threshold8x8Block(byte[] byArray, int n, int n2, int n3, int n4, BitMatrix bitMatrix) {
        for (int i = 0; i < 8; ++i) {
            int n5 = (n2 + i) * n4 + n;
            for (int j = 0; j < 8; ++j) {
                int n6 = byArray[n5 + j] & 0xFF;
                if (n6 >= n3) continue;
                bitMatrix.set(n + j, n2 + i);
            }
        }
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n, int n2, int n3, int n4) {
        int[][] nArray = new int[n2][n];
        for (int i = 0; i < n2; ++i) {
            int n5 = i << 3;
            if (n5 + 8 >= n4) {
                n5 = n4 - 8;
            }
            for (int j = 0; j < n; ++j) {
                int n6;
                int n7 = j << 3;
                if (n7 + 8 >= n3) {
                    n7 = n3 - 8;
                }
                int n8 = 0;
                int n9 = 255;
                int n10 = 0;
                for (n6 = 0; n6 < 8; ++n6) {
                    int n11 = (n5 + n6) * n3 + n7;
                    for (int k = 0; k < 8; ++k) {
                        int n12 = byArray[n11 + k] & 0xFF;
                        n8 += n12;
                        if (n12 < n9) {
                            n9 = n12;
                        }
                        if (n12 <= n10) continue;
                        n10 = n12;
                    }
                }
                n6 = n10 - n9 > 24 ? n8 >> 6 : (n10 == 0 ? 1 : n9 >> 1);
                nArray[i][j] = n6;
            }
        }
        return nArray;
    }
}

