/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.common;

import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.DefaultGridSampler;
import ai.com.google.zxing.common.PerspectiveTransform;

public abstract class GridSampler {
    private static GridSampler gridSampler = new DefaultGridSampler();

    public static void setGridSampler(GridSampler gridSampler) {
        if (gridSampler == null) {
            throw new IllegalArgumentException();
        }
        GridSampler.gridSampler = gridSampler;
    }

    public static GridSampler getInstance() {
        return gridSampler;
    }

    public abstract BitMatrix sampleGrid(BitMatrix var1, int var2, int var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19) throws NotFoundException;

    public abstract BitMatrix sampleGrid(BitMatrix var1, int var2, int var3, PerspectiveTransform var4) throws NotFoundException;

    protected static void checkAndNudgePoints(BitMatrix bitMatrix, float[] fArray) throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4 = bitMatrix.getWidth();
        int n5 = bitMatrix.getHeight();
        boolean bl = true;
        for (n3 = 0; n3 < fArray.length && bl; n3 += 2) {
            n2 = (int)fArray[n3];
            n = (int)fArray[n3 + 1];
            if (n2 < -1 || n2 > n4 || n < -1 || n > n5) {
                throw NotFoundException.getNotFoundInstance();
            }
            bl = false;
            if (n2 == -1) {
                fArray[n3] = 0.0f;
                bl = true;
            } else if (n2 == n4) {
                fArray[n3] = n4 - 1;
                bl = true;
            }
            if (n == -1) {
                fArray[n3 + 1] = 0.0f;
                bl = true;
                continue;
            }
            if (n != n5) continue;
            fArray[n3 + 1] = n5 - 1;
            bl = true;
        }
        bl = true;
        for (n3 = fArray.length - 2; n3 >= 0 && bl; n3 -= 2) {
            n2 = (int)fArray[n3];
            n = (int)fArray[n3 + 1];
            if (n2 < -1 || n2 > n4 || n < -1 || n > n5) {
                throw NotFoundException.getNotFoundInstance();
            }
            bl = false;
            if (n2 == -1) {
                fArray[n3] = 0.0f;
                bl = true;
            } else if (n2 == n4) {
                fArray[n3] = n4 - 1;
                bl = true;
            }
            if (n == -1) {
                fArray[n3 + 1] = 0.0f;
                bl = true;
                continue;
            }
            if (n != n5) continue;
            fArray[n3 + 1] = n5 - 1;
            bl = true;
        }
    }
}

