/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.common;

public final class BitSource {
    private final byte[] bytes;
    private int byteOffset;
    private int bitOffset;

    public BitSource(byte[] byArray) {
        this.bytes = byArray;
    }

    public int readBits(int n) {
        int n2;
        int n3;
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException();
        }
        int n4 = 0;
        if (this.bitOffset > 0) {
            n3 = 8 - this.bitOffset;
            n2 = n < n3 ? n : n3;
            int n5 = n3 - n2;
            int n6 = 255 >> 8 - n2 << n5;
            n4 = (this.bytes[this.byteOffset] & n6) >> n5;
            n -= n2;
            this.bitOffset += n2;
            if (this.bitOffset == 8) {
                this.bitOffset = 0;
                ++this.byteOffset;
            }
        }
        if (n > 0) {
            while (n >= 8) {
                n4 = n4 << 8 | this.bytes[this.byteOffset] & 0xFF;
                ++this.byteOffset;
                n -= 8;
            }
            if (n > 0) {
                n3 = 8 - n;
                n2 = 255 >> n3 << n3;
                n4 = n4 << n | (this.bytes[this.byteOffset] & n2) >> n3;
                this.bitOffset += n;
            }
        }
        return n4;
    }

    public int available() {
        return 8 * (this.bytes.length - this.byteOffset) - this.bitOffset;
    }
}

