/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.client.result.optional;

import ai.com.google.zxing.Result;
import ai.com.google.zxing.client.result.URIParsedResult;
import ai.com.google.zxing.client.result.optional.AbstractNDEFResultParser;
import ai.com.google.zxing.client.result.optional.NDEFRecord;

final class NDEFURIResultParser
extends AbstractNDEFResultParser {
    private static final String[] URI_PREFIXES = new String[]{null, "http://www.", "https://www.", "http://", "https://", "tel:", "mailto:", "ftp://anonymous:anonymous@", "ftp://ftp.", "ftps://", "sftp://", "smb://", "nfs://", "ftp://", "dav://", "news:", "telnet://", "imap:", "rtsp://", "urn:", "pop:", "sip:", "sips:", "tftp:", "btspp://", "btl2cap://", "btgoep://", "tcpobex://", "irdaobex://", "file://", "urn:epc:id:", "urn:epc:tag:", "urn:epc:pat:", "urn:epc:raw:", "urn:epc:", "urn:nfc:"};

    NDEFURIResultParser() {
    }

    public static URIParsedResult parse(Result result) {
        byte[] byArray = result.getRawBytes();
        if (byArray == null) {
            return null;
        }
        NDEFRecord nDEFRecord = NDEFRecord.readRecord(byArray, 0);
        if (nDEFRecord == null || !nDEFRecord.isMessageBegin() || !nDEFRecord.isMessageEnd()) {
            return null;
        }
        if (!nDEFRecord.getType().equals("U")) {
            return null;
        }
        String string = NDEFURIResultParser.decodeURIPayload(nDEFRecord.getPayload());
        return new URIParsedResult(string, null);
    }

    static String decodeURIPayload(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        String string = null;
        if (n < URI_PREFIXES.length) {
            string = URI_PREFIXES[n];
        }
        String string2 = NDEFURIResultParser.bytesToString(byArray, 1, byArray.length - 1, "UTF8");
        return string == null ? string2 : string + string2;
    }
}

