/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.client.result.optional;

import ai.com.google.zxing.client.result.optional.AbstractNDEFResultParser;

final class NDEFRecord {
    private static final int SUPPORTED_HEADER_MASK = 63;
    private static final int SUPPORTED_HEADER = 17;
    public static final String TEXT_WELL_KNOWN_TYPE = "T";
    public static final String URI_WELL_KNOWN_TYPE = "U";
    public static final String SMART_POSTER_WELL_KNOWN_TYPE = "Sp";
    public static final String ACTION_WELL_KNOWN_TYPE = "act";
    private final int header;
    private final String type;
    private final byte[] payload;
    private final int totalRecordLength;

    private NDEFRecord(int n, String string, byte[] byArray, int n2) {
        this.header = n;
        this.type = string;
        this.payload = byArray;
        this.totalRecordLength = n2;
    }

    static NDEFRecord readRecord(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        if (((n2 ^ 0x11) & 0x3F) != 0) {
            return null;
        }
        int n3 = byArray[n + 1] & 0xFF;
        int n4 = byArray[n + 2] & 0xFF;
        String string = AbstractNDEFResultParser.bytesToString(byArray, n + 3, n3, "US-ASCII");
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n + 3 + n3, byArray2, 0, n4);
        return new NDEFRecord(n2, string, byArray2, 3 + n3 + n4);
    }

    boolean isMessageBegin() {
        return (this.header & 0x80) != 0;
    }

    boolean isMessageEnd() {
        return (this.header & 0x40) != 0;
    }

    String getType() {
        return this.type;
    }

    byte[] getPayload() {
        return this.payload;
    }

    int getTotalRecordLength() {
        return this.totalRecordLength;
    }
}

