/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.client.j2se;

import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.MultiFormatReader;
import ai.com.google.zxing.ReaderException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import ai.com.google.zxing.common.HybridBinarizer;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class GUIRunner
extends JFrame {
    private final JLabel imageLabel = new JLabel();
    private final JTextArea textArea = new JTextArea();

    private GUIRunner() {
        this.textArea.setEditable(false);
        this.textArea.setMaximumSize(new Dimension(400, 200));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.imageLabel);
        jPanel.add(this.textArea);
        this.setTitle("ZXing");
        this.setSize(400, 400);
        this.setDefaultCloseOperation(3);
        this.setContentPane(jPanel);
        this.setLocationRelativeTo(null);
    }

    public static void main(String[] stringArray) throws MalformedURLException {
        GUIRunner gUIRunner = new GUIRunner();
        gUIRunner.setVisible(true);
        gUIRunner.chooseImage();
    }

    private void chooseImage() throws MalformedURLException {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.showOpenDialog(this);
        File file = jFileChooser.getSelectedFile();
        ImageIcon imageIcon = new ImageIcon(file.toURI().toURL());
        this.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight() + 100);
        this.imageLabel.setIcon(imageIcon);
        String string = GUIRunner.getDecodeText(file);
        this.textArea.setText(string);
    }

    private static String getDecodeText(File file) {
        Result result;
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (IOException iOException) {
            return iOException.toString();
        }
        if (bufferedImage == null) {
            return "Could not decode image";
        }
        BufferedImageLuminanceSource bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
        BinaryBitmap binaryBitmap = new BinaryBitmap(new HybridBinarizer(bufferedImageLuminanceSource));
        try {
            result = new MultiFormatReader().decode(binaryBitmap);
        }
        catch (ReaderException readerException) {
            return readerException.toString();
        }
        return result.getText();
    }
}

