/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.client.j2se;

import ai.com.google.zxing.BinaryBitmap;
import ai.com.google.zxing.DecodeHintType;
import ai.com.google.zxing.MultiFormatReader;
import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.Result;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import ai.com.google.zxing.client.j2se.Config;
import ai.com.google.zxing.client.j2se.Inputs;
import ai.com.google.zxing.client.result.ParsedResult;
import ai.com.google.zxing.client.result.ResultParser;
import ai.com.google.zxing.common.BitArray;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.HybridBinarizer;
import ai.com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Hashtable;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DecodeThread
extends Thread {
    private int successful;
    private final Config config;
    private final Inputs inputs;

    DecodeThread(Config config, Inputs inputs) {
        this.config = config;
        this.inputs = inputs;
    }

    @Override
    public void run() {
        String string;
        while ((string = this.inputs.getNextInput()) != null) {
            Object object;
            File file = new File(string);
            if (file.exists()) {
                try {
                    if (this.config.isMulti()) {
                        object = this.decodeMulti(file.toURI(), this.config.getHints());
                        if (object == null) continue;
                        ++this.successful;
                        if (!this.config.isDumpResults()) continue;
                        DecodeThread.dumpResultMulti(file, object);
                        continue;
                    }
                    object = this.decode(file.toURI(), this.config.getHints());
                    if (object == null) continue;
                    ++this.successful;
                    if (!this.config.isDumpResults()) continue;
                    DecodeThread.dumpResult(file, (Result)object);
                }
                catch (IOException iOException) {}
                continue;
            }
            try {
                object = this.decode(new URI(string), this.config.getHints());
                if (object == null) continue;
                ++this.successful;
            }
            catch (Exception exception) {}
        }
    }

    public int getSuccessful() {
        return this.successful;
    }

    private static void dumpResult(File file, Result result) throws IOException {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        File file2 = new File(string + ".txt");
        DecodeThread.writeStringToFile(result.getText(), file2);
    }

    private static void dumpResultMulti(File file, Result[] resultArray) throws IOException {
        String string = file.getAbsolutePath();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        File file2 = new File(string + ".txt");
        DecodeThread.writeResultsToFile(resultArray, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStringToFile(String string, File file) throws IOException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
        try {
            outputStreamWriter.write(string);
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResultsToFile(Result[] resultArray, File file) throws IOException {
        String string = System.getProperty("line.separator");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF8"));
        try {
            for (Result result : resultArray) {
                outputStreamWriter.write(result.getText());
                outputStreamWriter.write(string);
            }
        }
        finally {
            ((Writer)outputStreamWriter).close();
        }
    }

    private Result decode(URI uRI, Hashtable<DecodeHintType, Object> hashtable) throws IOException {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(uRI.toURL());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FileNotFoundException("Resource not found: " + uRI);
        }
        if (bufferedImage == null) {
            System.err.println(uRI.toString() + ": Could not load image");
            return null;
        }
        try {
            Object object;
            BufferedImageLuminanceSource bufferedImageLuminanceSource;
            if (this.config.getCrop() == null) {
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
            } else {
                object = this.config.getCrop();
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage, object[0], object[1], object[2], object[3]);
            }
            object = new BinaryBitmap(new HybridBinarizer(bufferedImageLuminanceSource));
            if (this.config.isDumpBlackPoint()) {
                DecodeThread.dumpBlackPoint(uRI, bufferedImage, (BinaryBitmap)object);
            }
            Result result = new MultiFormatReader().decode((BinaryBitmap)object, hashtable);
            if (this.config.isBrief()) {
                System.out.println(uRI.toString() + ": Success");
            } else {
                ParsedResult parsedResult = ResultParser.parseResult(result);
                System.out.println(uRI.toString() + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                System.out.println("Found " + result.getResultPoints().length + " result points.");
                for (int i = 0; i < result.getResultPoints().length; ++i) {
                    ResultPoint resultPoint = result.getResultPoints()[i];
                    System.out.println("  Point " + i + ": (" + resultPoint.getX() + ',' + resultPoint.getY() + ')');
                }
            }
            return result;
        }
        catch (NotFoundException notFoundException) {
            System.out.println(uRI.toString() + ": No barcode found");
            return null;
        }
    }

    private Result[] decodeMulti(URI uRI, Hashtable<DecodeHintType, Object> hashtable) throws IOException {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(uRI.toURL());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FileNotFoundException("Resource not found: " + uRI);
        }
        if (bufferedImage == null) {
            System.err.println(uRI.toString() + ": Could not load image");
            return null;
        }
        try {
            Object object;
            BufferedImageLuminanceSource bufferedImageLuminanceSource;
            if (this.config.getCrop() == null) {
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
            } else {
                object = this.config.getCrop();
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage, object[0], object[1], object[2], object[3]);
            }
            object = new BinaryBitmap(new HybridBinarizer(bufferedImageLuminanceSource));
            if (this.config.isDumpBlackPoint()) {
                DecodeThread.dumpBlackPoint(uRI, bufferedImage, (BinaryBitmap)object);
            }
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            GenericMultipleBarcodeReader genericMultipleBarcodeReader = new GenericMultipleBarcodeReader(multiFormatReader);
            Result[] resultArray = genericMultipleBarcodeReader.decodeMultiple((BinaryBitmap)object, hashtable);
            if (this.config.isBrief()) {
                System.out.println(uRI.toString() + ": Success");
            } else {
                for (Result result : resultArray) {
                    ParsedResult parsedResult = ResultParser.parseResult(result);
                    System.out.println(uRI.toString() + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                    System.out.println("Found " + result.getResultPoints().length + " result points.");
                    for (int i = 0; i < result.getResultPoints().length; ++i) {
                        ResultPoint resultPoint = result.getResultPoints()[i];
                        System.out.println("  Point " + i + ": (" + resultPoint.getX() + ',' + resultPoint.getY() + ')');
                    }
                }
            }
            return resultArray;
        }
        catch (NotFoundException notFoundException) {
            System.out.println(uRI.toString() + ": No barcode found");
            return null;
        }
    }

    private static void dumpBlackPoint(URI uRI, BufferedImage bufferedImage, BinaryBitmap binaryBitmap) {
        int n;
        int n2;
        int n3;
        String string = uRI.getPath();
        if (string.contains(".mono.png")) {
            return;
        }
        int n4 = binaryBitmap.getWidth();
        int n5 = binaryBitmap.getHeight();
        int n6 = n4 * 3;
        int[] nArray = new int[n6 * n5];
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n5; ++i) {
            bufferedImage.getRGB(0, i, n4, 1, nArray2, 0, n4);
            System.arraycopy(nArray2, 0, nArray, i * n6, n4);
        }
        BitArray bitArray = new BitArray(n4);
        for (n3 = 0; n3 < n5; ++n3) {
            try {
                bitArray = binaryBitmap.getBlackRow(n3, bitArray);
            }
            catch (NotFoundException notFoundException) {
                n2 = n3 * n6 + n4;
                for (n = 0; n < n4; ++n) {
                    nArray[n2 + n] = -65536;
                }
                continue;
            }
            int n7 = n3 * n6 + n4;
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n7 + n2] = bitArray.get(n2) ? -16777216 : -1;
            }
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                BitMatrix bitMatrix = binaryBitmap.getBlackMatrix();
                n2 = n3 * n6 + n4 * 2;
                for (n = 0; n < n4; ++n) {
                    nArray[n2 + n] = bitMatrix.get(n, n3) ? -16777216 : -1;
                }
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        DecodeThread.writeResultImage(n6, n5, nArray, uRI, string, ".mono.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeResultImage(int n, int n2, int[] nArray, URI uRI, String string, String string2) {
        int n3;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        String string3 = string;
        if ("http".equals(uRI.getScheme()) && (n3 = string3.lastIndexOf(47)) > 0) {
            string3 = '.' + string3.substring(n3);
        }
        if ((n3 = string3.lastIndexOf(46)) > 0) {
            string3 = string3.substring(0, n3);
        }
        string3 = string3 + string2;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string3);
            ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Could not create " + string3);
        }
        catch (IOException iOException) {
            System.err.println("Could not write to " + string3);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

