/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.client.j2se;

import ai.com.google.zxing.LuminanceSource;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public final class BufferedImageLuminanceSource
extends LuminanceSource {
    private final BufferedImage image;
    private final int left;
    private final int top;

    public BufferedImageLuminanceSource(BufferedImage bufferedImage) {
        this(bufferedImage, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public BufferedImageLuminanceSource(BufferedImage bufferedImage, int n, int n2, int n3, int n4) {
        super(n3, n4);
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        if (n + n3 > n5 || n2 + n4 > n6) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.image = new BufferedImage(n5, n6, 10);
        this.image.getGraphics().drawImage(bufferedImage, 0, 0, null);
        this.left = n;
        this.top = n2;
    }

    public byte[] getRow(int n, byte[] byArray) {
        if (n < 0 || n >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n);
        }
        int n2 = this.getWidth();
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        this.image.getRaster().getDataElements(this.left, this.top + n, n2, 1, byArray);
        return byArray;
    }

    public byte[] getMatrix() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        this.image.getRaster().getDataElements(this.left, this.top, n, n2, byArray);
        return byArray;
    }

    public boolean isCropSupported() {
        return true;
    }

    public LuminanceSource crop(int n, int n2, int n3, int n4) {
        return new BufferedImageLuminanceSource(this.image, this.left + n, this.top + n2, n3, n4);
    }

    public boolean isRotateSupported() {
        return true;
    }

    public LuminanceSource rotateCounterClockwise() {
        int n = this.image.getWidth();
        int n2 = this.image.getHeight();
        AffineTransform affineTransform = new AffineTransform(0.0, -1.0, 1.0, 0.0, 0.0, (double)n);
        BufferedImage bufferedImage = new BufferedImage(n2, n, 10);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.image, affineTransform, null);
        graphics2D.dispose();
        int n3 = this.getWidth();
        return new BufferedImageLuminanceSource(bufferedImage, this.top, n - (this.left + n3), this.getHeight(), n3);
    }
}

