/*
 * Decompiled with CFR 0.152.
 */
package ai.com.google.zxing.aztec.detector;

import ai.com.google.zxing.NotFoundException;
import ai.com.google.zxing.ResultPoint;
import ai.com.google.zxing.aztec.AztecDetectorResult;
import ai.com.google.zxing.common.BitMatrix;
import ai.com.google.zxing.common.GridSampler;
import ai.com.google.zxing.common.detector.WhiteRectangleDetector;
import ai.com.google.zxing.common.reedsolomon.GenericGF;
import ai.com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import ai.com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class Detector {
    private final BitMatrix image;
    private boolean compact;
    private int nbLayers;
    private int nbDataBlocks;
    private int nbCenterLayers;
    private int shift;

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    public AztecDetectorResult detect() throws NotFoundException {
        Point point = this.getMatrixCenter();
        Point[] pointArray = this.getBullEyeCornerPoints(point);
        this.extractParameters(pointArray);
        ResultPoint[] resultPointArray = this.getMatrixCornerPoints(pointArray);
        BitMatrix bitMatrix = this.sampleGrid(this.image, resultPointArray[this.shift % 4], resultPointArray[(this.shift + 3) % 4], resultPointArray[(this.shift + 2) % 4], resultPointArray[(this.shift + 1) % 4]);
        return new AztecDetectorResult(bitMatrix, resultPointArray, this.compact, this.nbDataBlocks, this.nbLayers);
    }

    private void extractParameters(Point[] pointArray) throws NotFoundException {
        boolean[] blArray;
        boolean[] blArray2 = this.sampleLine(pointArray[0], pointArray[1], 2 * this.nbCenterLayers + 1);
        boolean[] blArray3 = this.sampleLine(pointArray[1], pointArray[2], 2 * this.nbCenterLayers + 1);
        boolean[] blArray4 = this.sampleLine(pointArray[2], pointArray[3], 2 * this.nbCenterLayers + 1);
        boolean[] blArray5 = this.sampleLine(pointArray[3], pointArray[0], 2 * this.nbCenterLayers + 1);
        if (blArray2[0] && blArray2[2 * this.nbCenterLayers]) {
            this.shift = 0;
        } else if (blArray3[0] && blArray3[2 * this.nbCenterLayers]) {
            this.shift = 1;
        } else if (blArray4[0] && blArray4[2 * this.nbCenterLayers]) {
            this.shift = 2;
        } else if (blArray5[0] && blArray5[2 * this.nbCenterLayers]) {
            this.shift = 3;
        } else {
            throw NotFoundException.getNotFoundInstance();
        }
        if (this.compact) {
            int n;
            boolean[] blArray6 = new boolean[28];
            for (n = 0; n < 7; ++n) {
                blArray6[n] = blArray2[2 + n];
                blArray6[n + 7] = blArray3[2 + n];
                blArray6[n + 14] = blArray4[2 + n];
                blArray6[n + 21] = blArray5[2 + n];
            }
            blArray = new boolean[28];
            for (n = 0; n < 28; ++n) {
                blArray[n] = blArray6[(n + this.shift * 7) % 28];
            }
        } else {
            int n;
            boolean[] blArray7 = new boolean[40];
            for (n = 0; n < 11; ++n) {
                if (n < 5) {
                    blArray7[n] = blArray2[2 + n];
                    blArray7[n + 10] = blArray3[2 + n];
                    blArray7[n + 20] = blArray4[2 + n];
                    blArray7[n + 30] = blArray5[2 + n];
                }
                if (n <= 5) continue;
                blArray7[n - 1] = blArray2[2 + n];
                blArray7[n + 10 - 1] = blArray3[2 + n];
                blArray7[n + 20 - 1] = blArray4[2 + n];
                blArray7[n + 30 - 1] = blArray5[2 + n];
            }
            blArray = new boolean[40];
            for (n = 0; n < 40; ++n) {
                blArray[n] = blArray7[(n + this.shift * 10) % 40];
            }
        }
        Detector.correctParameterData(blArray, this.compact);
        this.getParameters(blArray);
    }

    private ResultPoint[] getMatrixCornerPoints(Point[] pointArray) throws NotFoundException {
        float f = (float)(2 * this.nbLayers + (this.nbLayers > 4 ? 1 : 0) + (this.nbLayers - 4) / 8) / (2.0f * (float)this.nbCenterLayers);
        int n = pointArray[0].x - pointArray[2].x;
        int n2 = pointArray[0].y - pointArray[2].y;
        int n3 = n2 > 0 ? 1 : -1;
        int n4 = Detector.round((float)pointArray[2].x - f * (float)(n += n > 0 ? 1 : -1));
        int n5 = Detector.round((float)pointArray[2].y - f * (float)(n2 += n3));
        int n6 = Detector.round((float)pointArray[0].x + f * (float)n);
        int n7 = Detector.round((float)pointArray[0].y + f * (float)n2);
        n = pointArray[1].x - pointArray[3].x;
        n2 = pointArray[1].y - pointArray[3].y;
        int n8 = n2 > 0 ? 1 : -1;
        int n9 = Detector.round((float)pointArray[3].x - f * (float)(n += n > 0 ? 1 : -1));
        int n10 = Detector.round((float)pointArray[3].y - f * (float)(n2 += n8));
        int n11 = Detector.round((float)pointArray[1].x + f * (float)n);
        int n12 = Detector.round((float)pointArray[1].y + f * (float)n2);
        if (!(this.isValid(n6, n7) && this.isValid(n11, n12) && this.isValid(n4, n5) && this.isValid(n9, n10))) {
            throw NotFoundException.getNotFoundInstance();
        }
        return new ResultPoint[]{new ResultPoint(n6, n7), new ResultPoint(n11, n12), new ResultPoint(n4, n5), new ResultPoint(n9, n10)};
    }

    private static void correctParameterData(boolean[] blArray, boolean bl) throws NotFoundException {
        int n;
        int n2;
        int n3;
        int n4;
        if (bl) {
            n4 = 7;
            n3 = 2;
        } else {
            n4 = 10;
            n3 = 4;
        }
        int n5 = n4 - n3;
        int[] nArray = new int[n4];
        int n6 = 4;
        for (int i = 0; i < n4; ++i) {
            n2 = 1;
            for (n = 1; n <= n6; ++n) {
                if (blArray[n6 * i + n6 - n]) {
                    int n7 = i;
                    nArray[n7] = nArray[n7] + n2;
                }
                n2 <<= 1;
            }
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(GenericGF.AZTEC_PARAM);
            reedSolomonDecoder.decode(nArray, n5);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw NotFoundException.getNotFoundInstance();
        }
        for (int i = 0; i < n3; ++i) {
            n2 = 1;
            for (n = 1; n <= n6; ++n) {
                blArray[i * n6 + n6 - n] = (nArray[i] & n2) == n2;
                n2 <<= 1;
            }
        }
    }

    private Point[] getBullEyeCornerPoints(Point point) throws NotFoundException {
        Point point2 = point;
        Point point3 = point;
        Point point4 = point;
        Point point5 = point;
        boolean bl = true;
        this.nbCenterLayers = 1;
        while (this.nbCenterLayers < 9) {
            float f;
            Point point6 = this.getFirstDifferent(point2, bl, 1, -1);
            Point point7 = this.getFirstDifferent(point3, bl, 1, 1);
            Point point8 = this.getFirstDifferent(point4, bl, -1, 1);
            Point point9 = this.getFirstDifferent(point5, bl, -1, -1);
            if (this.nbCenterLayers > 2 && ((double)(f = Detector.distance(point9, point6) * (float)this.nbCenterLayers / (Detector.distance(point5, point2) * (float)(this.nbCenterLayers + 2))) < 0.75 || (double)f > 1.25 || !this.isWhiteOrBlackRectangle(point6, point7, point8, point9))) break;
            point2 = point6;
            point3 = point7;
            point4 = point8;
            point5 = point9;
            bl = !bl;
            ++this.nbCenterLayers;
        }
        if (this.nbCenterLayers != 5 && this.nbCenterLayers != 7) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.compact = this.nbCenterLayers == 5;
        float f = 1.5f / (float)(2 * this.nbCenterLayers - 3);
        int n = point2.x - point4.x;
        int n2 = point2.y - point4.y;
        int n3 = Detector.round((float)point4.x - f * (float)n);
        int n4 = Detector.round((float)point4.y - f * (float)n2);
        int n5 = Detector.round((float)point2.x + f * (float)n);
        int n6 = Detector.round((float)point2.y + f * (float)n2);
        n = point3.x - point5.x;
        n2 = point3.y - point5.y;
        int n7 = Detector.round((float)point5.x - f * (float)n);
        int n8 = Detector.round((float)point5.y - f * (float)n2);
        int n9 = Detector.round((float)point3.x + f * (float)n);
        int n10 = Detector.round((float)point3.y + f * (float)n2);
        if (!(this.isValid(n5, n6) && this.isValid(n9, n10) && this.isValid(n3, n4) && this.isValid(n7, n8))) {
            throw NotFoundException.getNotFoundInstance();
        }
        Point point10 = new Point(n5, n6);
        Point point11 = new Point(n9, n10);
        Point point12 = new Point(n3, n4);
        Point point13 = new Point(n7, n8);
        return new Point[]{point10, point11, point12, point13};
    }

    private Point getMatrixCenter() {
        int n;
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            n = this.image.width / 2;
            int n2 = this.image.height / 2;
            resultPoint4 = this.getFirstDifferent(new Point(n + 7, n2 - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Point(n + 7, n2 + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Point(n - 7, n2 + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Point(n - 7, n2 - 7), false, -1, -1).toResultPoint();
        }
        int n3 = Detector.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n = Detector.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image, 15, n3, n).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            resultPoint4 = this.getFirstDifferent(new Point(n3 + 7, n - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Point(n3 + 7, n + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Point(n3 - 7, n + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Point(n3 - 7, n - 7), false, -1, -1).toResultPoint();
        }
        n3 = Detector.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n = Detector.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        return new Point(n3, n);
    }

    private BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        int n = this.compact ? 4 * this.nbLayers + 11 : (this.nbLayers <= 4 ? 4 * this.nbLayers + 15 : 4 * this.nbLayers + 2 * ((this.nbLayers - 4) / 8 + 1) + 15);
        GridSampler gridSampler = GridSampler.getInstance();
        return gridSampler.sampleGrid(bitMatrix, n, n, 0.5f, 0.5f, (float)n - 0.5f, 0.5f, (float)n - 0.5f, (float)n - 0.5f, 0.5f, (float)n - 0.5f, resultPoint.getX(), resultPoint.getY(), resultPoint4.getX(), resultPoint4.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private void getParameters(boolean[] blArray) {
        int n;
        int n2;
        int n3;
        if (this.compact) {
            n3 = 2;
            n2 = 6;
        } else {
            n3 = 5;
            n2 = 11;
        }
        for (n = 0; n < n3; ++n) {
            this.nbLayers <<= 1;
            if (!blArray[n]) continue;
            ++this.nbLayers;
        }
        for (n = n3; n < n3 + n2; ++n) {
            this.nbDataBlocks <<= 1;
            if (!blArray[n]) continue;
            ++this.nbDataBlocks;
        }
        ++this.nbLayers;
        ++this.nbDataBlocks;
    }

    private boolean[] sampleLine(Point point, Point point2, int n) {
        boolean[] blArray = new boolean[n];
        float f = Detector.distance(point, point2);
        float f2 = f / (float)(n - 1);
        float f3 = f2 * (float)(point2.x - point.x) / f;
        float f4 = f2 * (float)(point2.y - point.y) / f;
        float f5 = point.x;
        float f6 = point.y;
        for (int i = 0; i < n; ++i) {
            blArray[i] = this.image.get(Detector.round(f5), Detector.round(f6));
            f5 += f3;
            f6 += f4;
        }
        return blArray;
    }

    private boolean isWhiteOrBlackRectangle(Point point, Point point2, Point point3, Point point4) {
        int n = 3;
        point = new Point(point.x - n, point.y + n);
        point2 = new Point(point2.x - n, point2.y - n);
        point3 = new Point(point3.x + n, point3.y - n);
        point4 = new Point(point4.x + n, point4.y + n);
        int n2 = this.getColor(point4, point);
        if (n2 == 0) {
            return false;
        }
        int n3 = this.getColor(point, point2);
        if (n3 != n2 || n3 == 0) {
            return false;
        }
        n3 = this.getColor(point2, point3);
        if (n3 != n2 || n3 == 0) {
            return false;
        }
        n3 = this.getColor(point3, point4);
        return n3 == n2 && n3 != 0;
    }

    private int getColor(Point point, Point point2) {
        float f = Detector.distance(point, point2);
        float f2 = (float)(point2.x - point.x) / f;
        float f3 = (float)(point2.y - point.y) / f;
        int n = 0;
        float f4 = point.x;
        float f5 = point.y;
        boolean bl = this.image.get(point.x, point.y);
        int n2 = 0;
        while ((float)n2 < f) {
            if (this.image.get(Detector.round(f4 += f2), Detector.round(f5 += f3)) != bl) {
                ++n;
            }
            ++n2;
        }
        float f6 = (float)n / f;
        if ((double)f6 > 0.1 && (double)f6 < 0.9) {
            return 0;
        }
        if ((double)f6 <= 0.1) {
            return bl ? 1 : -1;
        }
        return bl ? -1 : 1;
    }

    private Point getFirstDifferent(Point point, boolean bl, int n, int n2) {
        int n3 = point.x + n;
        int n4 = point.y + n2;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n3 += n;
            n4 += n2;
        }
        n3 -= n;
        n4 -= n2;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n3 += n;
        }
        n3 -= n;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n4 += n2;
        }
        return new Point(n3, n4 -= n2);
    }

    private boolean isValid(int n, int n2) {
        return n >= 0 && n < this.image.width && n2 > 0 && n2 < this.image.height;
    }

    private static int round(float f) {
        return (int)(f + 0.5f);
    }

    private static float distance(Point point, Point point2) {
        return (float)Math.sqrt((point.x - point2.x) * (point.x - point2.x) + (point.y - point2.y) * (point.y - point2.y));
    }

    private static class Point {
        public final int x;
        public final int y;

        public ResultPoint toResultPoint() {
            return new ResultPoint(this.x, this.y);
        }

        private Point(int n, int n2) {
            this.x = n;
            this.y = n2;
        }
    }
}

