/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.chartdirector;

import com.activeintra.chartdirector.ParseXml;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class AIChartDirectorProperties {
    private InputStream xmlInputStream;
    private Document document;
    private Element rootNode;
    private Logger logger = Logger.getLogger((String)"AIChartDirectorProperties");
    List<String> noLegend;
    int[] colorArray = new int[]{14117045, 6638505, 1482723, 1683363, 702792, 15057982, 15368758, 15558209, 11808296, 9131108, 12019839, 8593787, 7165083, 5661822, 7507362, 0x525755, 4358242, 5999663, 0x899880, 0x707070};

    public Element getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(Element element) {
        this.rootNode = element;
    }

    public int[] getDefaultColorArray() {
        return this.colorArray;
    }

    public AIChartDirectorProperties(InputStream inputStream) {
        this.xmlInputStream = inputStream;
        this.noLegend = new ArrayList<String>();
        this.noLegend.add("Simple Bar Chart");
        this.noLegend.add("Simple Bar(no border)");
        this.noLegend.add("Multi-Color Bar Chart");
        this.noLegend.add("Soft Bar Shading");
        this.noLegend.add("Glass Bar Shading");
        this.noLegend.add("Gradient Bar Shading");
        this.noLegend.add("Cylinder Bar Shading");
        this.noLegend.add("3D Bar Chart");
        this.noLegend.add("Cylinder Bar Shape");
        this.noLegend.add("Polygon Bar Shapes");
        this.noLegend.add("Positive Negative Bars");
        this.noLegend.add("Pareto Chart");
        this.noLegend.add("Simple Radar Chart");
        this.noLegend.add("Simple Gantt Chart");
        this.noLegend.add("Multi-Color Gantt Chart");
        this.noLegend.add("xy Line Chart");
        this.noLegend.add("xy spLine Chart");
    }

    public void setProperties() {
        try {
            this.document = ParseXml.parse(this.xmlInputStream);
            this.setRootNode(this.document.getRootElement());
        }
        catch (Exception exception) {
            this.logger.error((Object)("#1010 " + exception));
        }
        Element element = this.document.getRootElement();
    }

    public void setData(String string) {
        Element element;
        int n;
        String[] stringArray = string.indexOf("\r\n\r\n") != -1 ? string.replaceAll("\r\n\r\n", "").split("\n") : string.split("\n");
        String[] stringArray2 = stringArray[0].split("\t");
        Element element2 = this.document.getRootElement();
        Element element3 = element2.getChild("chartdata").getChild("series");
        Element element4 = element2.getChild("chartdata").getChild("label");
        Element element5 = element2.getChild("chartdata").getChild("data");
        element3.removeChildren("subSeries");
        element4.removeChildren("subLabel");
        element5.removeChildren("rowData");
        for (n = 1; n < stringArray2.length; ++n) {
            element = new Element("subSeries");
            element.addContent(stringArray2[n]);
            element3.addContent((Content)element);
        }
        for (n = 1; n < stringArray.length; ++n) {
            element = stringArray[n].split("\t");
            Element element6 = new Element("subLabel");
            element6.addContent((String)element[0]);
            element4.addContent((Content)element6);
        }
        for (n = 1; n < stringArray2.length; ++n) {
            element = new Element("rowData");
            element.addContent("");
            element5.addContent((Content)element);
            for (int i = 1; i < stringArray.length; ++i) {
                String[] stringArray3 = stringArray[i].split("\t");
                for (int j = 1; j < stringArray3.length; ++j) {
                    if (j != n) continue;
                    String string2 = stringArray3[j].replace("\r", "");
                    if (string2 == null | string2.equals("")) {
                        string2 = "0";
                    }
                    if (string2.equals("NOVALUE")) {
                        string2 = "1.7E+308";
                    } else {
                        for (int k = 0; k < string2.length(); ++k) {
                            if (string2.charAt(k) >= '0' && string2.charAt(k) <= '9' || string2.charAt(k) == '.' || string2.charAt(k) == '-') continue;
                            string2 = "0";
                            break;
                        }
                    }
                    Element element7 = new Element("colData");
                    element7.addContent(string2);
                    element.addContent((Content)element7);
                }
            }
        }
    }
}

