/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.plot.DrawingSupplier;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import ai.org.jfree.chart.renderer.xy.XYSplineRenderer;
import ai.org.jfree.data.xy.IntervalXYDataset;
import ai.org.jfree.data.xy.XYDataset;
import ai.org.jfree.data.xy.XYSeries;
import ai.org.jfree.data.xy.XYSeriesCollection;
import ai.org.jfree.ui.RectangleInsets;
import com.activeintra.aichart.AIChartModule;
import com.activeintra.aichart.CustomDrawingSupplier;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public class XYSplineChart
extends AIChartModule {
    public String toString() {
        return "3. XY Spline Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        int n2 = this.data.length % 2;
        if (n2 != 0 || this.data.length < 2) {
            return this.getErrorChart();
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i = 0; i < this.series.length; i += 2) {
            XYSeries xYSeries = new XYSeries((Comparable)((Object)this.series[i]));
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                double d2 = this.data[i + 1][j];
                xYSeries.add(d, d2);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        return this.createChart((IntervalXYDataset)xYSeriesCollection);
    }

    public JFreeChart createChart(IntervalXYDataset intervalXYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)intervalXYDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBorderVisible(true);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setNoDataMessage("NO DATA!");
        xYPlot.setBackgroundPaint(null);
        xYPlot.setInsets(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        xYPlot.setOutlinePaint((Paint)Color.black);
        xYPlot.setRangeGridlinesVisible(true);
        xYPlot.setRangeGridlinePaint((Paint)new Color(112, 112, 112));
        BasicStroke basicStroke = new BasicStroke(0.1f);
        xYPlot.setRangeGridlineStroke((Stroke)basicStroke);
        xYPlot.setRangePannable(true);
        xYPlot.setBackgroundPaint((Paint)Color.white);
        CustomDrawingSupplier customDrawingSupplier = new CustomDrawingSupplier();
        xYPlot.setDrawingSupplier((DrawingSupplier)customDrawingSupplier);
        XYSplineRenderer xYSplineRenderer = new XYSplineRenderer();
        xYSplineRenderer.setDrawOutlines(true);
        xYPlot.setRenderer((XYItemRenderer)xYSplineRenderer);
        for (int i = 0; i < this.series.length; ++i) {
            xYSplineRenderer.setSeriesPaint(i, (Paint)new Color(this.colorArray[i]));
            xYSplineRenderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
        }
        return jFreeChart;
    }
}

