/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.DefaultCategoryDataset;
import com.activeintra.aichart.AIChartModule;
import java.awt.Color;
import java.awt.Paint;

public class StackedAreaChart
extends AIChartModule {
    public String toString() {
        return "2. Stacked-Area Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        if (this.data.length < 1) {
            return this.getErrorChart();
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.series.length; ++i) {
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                defaultCategoryDataset.addValue(d, (Comparable)((Object)this.series[i]), (Comparable)((Object)this.labels[j]));
            }
        }
        return this.createChart((CategoryDataset)defaultCategoryDataset);
    }

    public JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedAreaChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBorderVisible(true);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setNoDataMessage("NO DATA!");
        categoryPlot.setForegroundAlpha(0.85f);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        categoryAxis.setLowerMargin(0.0);
        categoryAxis.setUpperMargin(0.0);
        categoryAxis.setCategoryMargin(0.0);
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelsVisible(true);
        for (int i = 0; i < this.series.length; ++i) {
            categoryPlot.getRenderer().setSeriesPaint(i, (Paint)new Color(this.colorArray[i]));
        }
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }
}

