/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.labels.PieSectionLabelGenerator;
import ai.org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import ai.org.jfree.chart.plot.AbstractPieLabelDistributor;
import ai.org.jfree.chart.plot.PieLabelDistributor;
import ai.org.jfree.chart.plot.PieLabelLinkStyle;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.data.general.DefaultPieDataset;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.ui.RectangleInsets;
import com.activeintra.aichart.AIChartModule;
import com.activeintra.aichart.CustomRingPlot;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.List;

public class RingChart
extends AIChartModule {
    public String toString() {
        return "2. Ring Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        if (this.data.length < 1) {
            return this.getErrorChart();
        }
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                defaultPieDataset.setValue((Comparable)((Object)this.labels[j]), d);
            }
        }
        return this.createChart(defaultPieDataset);
    }

    public JFreeChart createChart(DefaultPieDataset defaultPieDataset) {
        Color color;
        CustomRingPlot customRingPlot = new CustomRingPlot((PieDataset)defaultPieDataset);
        customRingPlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
        customRingPlot.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        customRingPlot.setNoDataMessage("No data available");
        customRingPlot.setBackgroundPaint(null);
        customRingPlot.setOutlinePaint(Color.black);
        customRingPlot.setCircular(true);
        customRingPlot.setLabelGap(0.0);
        customRingPlot.setMinimumArcAngleToDraw(0.0);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(255, 255, 255), 500.0f, 500.0f, Color.red);
        Paint[] paintArray = new Paint[20];
        for (int i = 0; i < this.colorArray.length; ++i) {
            color = new Color(this.colorArray[i]);
            paintArray[i] = new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color.brighter());
        }
        RingRenderer ringRenderer = new RingRenderer(paintArray);
        ringRenderer.setColor(customRingPlot, (PieDataset)defaultPieDataset);
        customRingPlot.setLabelLinkStyle(PieLabelLinkStyle.STANDARD);
        color = new PieLabelDistributor(0);
        customRingPlot.setLabelDistributor((AbstractPieLabelDistributor)color);
        customRingPlot.setLabelBackgroundPaint(null);
        customRingPlot.setLabelOutlinePaint(null);
        customRingPlot.setLabelShadowPaint(null);
        customRingPlot.setBackgroundPaint(Color.white);
        customRingPlot.setSectionDepth(0.5);
        customRingPlot.setSeparatorsVisible(false);
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator("{0} \n {2} ({1})");
        customRingPlot.setLabelGenerator((PieSectionLabelGenerator)standardPieSectionLabelGenerator);
        JFreeChart jFreeChart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)customRingPlot, false);
        jFreeChart.setBorderVisible(true);
        return jFreeChart;
    }

    public class RingRenderer {
        private Paint[] color;

        public RingRenderer(Paint[] paintArray) {
            this.color = paintArray;
        }

        public void setColor(CustomRingPlot customRingPlot, PieDataset pieDataset) {
            List list = pieDataset.getKeys();
            for (int i = 0; i < list.size(); ++i) {
                int n = i % this.color.length;
                customRingPlot.setSectionPaint((Comparable)list.get(i), this.color[n]);
            }
        }
    }
}

