/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.labels.PieSectionLabelGenerator;
import ai.org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import ai.org.jfree.chart.plot.AbstractPieLabelDistributor;
import ai.org.jfree.chart.plot.PieLabelDistributor;
import ai.org.jfree.chart.plot.PieLabelLinkStyle;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.data.general.DefaultPieDataset;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.ui.RectangleInsets;
import com.activeintra.aichart.AIChartModule;
import com.activeintra.aichart.CustomPiePlot3D;
import java.awt.Color;
import java.awt.Paint;
import java.util.List;

public class PieChart
extends AIChartModule {
    public String toString() {
        return "1. Pie Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        if (this.data.length < 1) {
            return this.getErrorChart();
        }
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                defaultPieDataset.setValue((Comparable)((Object)this.labels[j]), d);
            }
        }
        return this.createChart(defaultPieDataset);
    }

    public JFreeChart createChart(DefaultPieDataset defaultPieDataset) {
        Color color;
        CustomPiePlot3D customPiePlot3D = new CustomPiePlot3D((PieDataset)defaultPieDataset);
        customPiePlot3D.setForegroundAlpha(1.0f);
        customPiePlot3D.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
        customPiePlot3D.setInsets(new RectangleInsets(0.0, 5.0, 5.0, 5.0));
        customPiePlot3D.setNoDataMessage("No data available");
        customPiePlot3D.setCircular(true);
        customPiePlot3D.setLabelGap(0.0);
        customPiePlot3D.setMinimumArcAngleToDraw(0.0);
        Paint[] paintArray = new Paint[20];
        for (int i = 0; i < this.colorArray.length; ++i) {
            color = new Color(this.colorArray[i]);
            paintArray[i] = color;
        }
        PieRenderer pieRenderer = new PieRenderer(paintArray);
        pieRenderer.setColor(customPiePlot3D, (PieDataset)defaultPieDataset);
        customPiePlot3D.setLabelLinkStyle(PieLabelLinkStyle.CUBIC_CURVE);
        color = new PieLabelDistributor(0);
        customPiePlot3D.setLabelDistributor((AbstractPieLabelDistributor)color);
        customPiePlot3D.setLabelBackgroundPaint(null);
        customPiePlot3D.setLabelOutlinePaint(null);
        customPiePlot3D.setLabelShadowPaint(null);
        customPiePlot3D.setBackgroundPaint(Color.white);
        StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = new StandardPieSectionLabelGenerator("{0} \n {2} ({1})");
        customPiePlot3D.setLabelGenerator((PieSectionLabelGenerator)standardPieSectionLabelGenerator);
        customPiePlot3D.setMaximumLabelWidth(0.0);
        JFreeChart jFreeChart = new JFreeChart("", JFreeChart.DEFAULT_TITLE_FONT, (Plot)customPiePlot3D, false);
        jFreeChart.setBorderVisible(true);
        return jFreeChart;
    }

    public class PieRenderer {
        private Paint[] color;

        public PieRenderer(Paint[] paintArray) {
            this.color = paintArray;
        }

        public void setColor(CustomPiePlot3D customPiePlot3D, PieDataset pieDataset) {
            List list = pieDataset.getKeys();
            for (int i = 0; i < list.size(); ++i) {
                int n = i % this.color.length;
                customPiePlot3D.setSectionPaint((Comparable)list.get(i), this.color[n]);
            }
        }
    }
}

