/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarPainter;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import ai.org.jfree.chart.renderer.category.StandardBarPainter;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.DefaultCategoryDataset;
import ai.org.jfree.ui.RectangleInsets;
import ai.org.jfree.util.SortOrder;
import com.activeintra.aichart.AIChartModule;
import com.activeintra.aichart.CustomBarRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;

public class MultiBarChart
extends AIChartModule {
    public String toString() {
        return "3. Multi-Bar Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        if (this.data.length < 1) {
            return this.getErrorChart();
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < this.series.length; ++i) {
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                defaultCategoryDataset.addValue(d, (Comparable)((Object)this.series[i]), (Comparable)((Object)this.labels[j]));
            }
        }
        return this.createChart((CategoryDataset)defaultCategoryDataset);
    }

    public JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBorderVisible(true);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setNoDataMessage("NO DATA!");
        categoryPlot.setBackgroundPaint(null);
        categoryPlot.setInsets(new RectangleInsets(10.0, 5.0, 5.0, 5.0));
        categoryPlot.setOutlinePaint((Paint)Color.black);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint((Paint)new Color(112, 112, 112));
        BasicStroke basicStroke = new BasicStroke(0.1f);
        categoryPlot.setRangeGridlineStroke((Stroke)basicStroke);
        categoryPlot.setRangePannable(true);
        categoryPlot.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setRowRenderingOrder(SortOrder.DESCENDING);
        Paint[] paintArray = this.createPaint();
        CustomBarRenderer customBarRenderer = new CustomBarRenderer(paintArray, true);
        customBarRenderer.setBarPainter((BarPainter)new StandardBarPainter());
        customBarRenderer.setDrawBarOutline(true);
        customBarRenderer.setBaseOutlinePaint(new Color(41, 41, 41));
        customBarRenderer.setBaseOutlineStroke(new BasicStroke(0.7f));
        customBarRenderer.setShadowVisible(false);
        categoryPlot.setRenderer((CategoryItemRenderer)customBarRenderer);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setTickMarkPaint((Paint)Color.black);
        return jFreeChart;
    }

    private Paint[] createPaint() {
        Paint[] paintArray = new Paint[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            paintArray[i] = new Color(this.colorArray[i]);
        }
        return paintArray;
    }
}

