/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.renderer.category.StackedBarRenderer3D;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.TextAnchor;
import ai.org.jfree.util.BooleanUtilities;
import com.activeintra.aichart.PaintAlpha;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class GradientStackedRenderer3DBar
extends StackedBarRenderer3D {
    private boolean showTotal = false;
    private Font totalLabelFont;
    private NumberFormat totalFormatter;
    private Paint totalLabelPaint;

    public GradientStackedRenderer3DBar() {
        this.totalLabelFont = new Font("\uad74\ub9bc\uccb4", 1, 10);
        this.totalFormatter = NumberFormat.getInstance();
        this.totalLabelPaint = Color.black;
    }

    public GradientStackedRenderer3DBar(double d, double d2) {
        super(d, d2);
        this.totalLabelFont = new Font("\uad74\ub9bc\uccb4", 1, 12);
        this.totalFormatter = NumberFormat.getInstance();
        this.totalLabelPaint = Color.black;
    }

    public NumberFormat getTotalFormatter() {
        return this.totalFormatter;
    }

    public void setTotalFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null format not permitted.");
        }
        this.totalFormatter = numberFormat;
    }

    public void setTotalLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.setTotalLabelFont(font, true);
    }

    public void setTotalLabelFont(Font font, boolean bl) {
        this.totalLabelFont = font;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setTotalLabelPaint(Paint paint) {
        this.setTotalLabelPaint(paint, true);
    }

    public void setTotalLabelPaint(Paint paint, boolean bl) {
        this.totalLabelPaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setShowTotal(boolean bl) {
        this.showTotal = bl;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (n < categoryDataset.getRowCount() - 1) {
            return;
        }
        Comparable comparable = categoryDataset.getColumnKey(n2);
        List list = this.createStackedValueList(categoryDataset, categoryDataset.getColumnKey(n2), categoryItemRendererState.getVisibleSeriesArray(), this.getBase(), this.getRenderAsPercentages());
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawStackHorizontal(list, comparable, graphics2D, categoryItemRendererState, double_, categoryPlot, categoryAxis, valueAxis, categoryDataset);
        } else {
            this.drawStackVertical(list, comparable, graphics2D, categoryItemRendererState, double_, categoryPlot, categoryAxis, valueAxis, categoryDataset);
        }
    }

    protected void drawStackHorizontal(List list, Comparable comparable, Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset) {
        int n;
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        int n2 = categoryDataset.getColumnIndex(comparable);
        double d = categoryAxis.getCategoryMiddle(n2, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d2 = categoryItemRendererState.getBarWidth();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = valueAxis.isInverted();
        int n3 = list.size() - 1;
        for (int i = 0; i < n3; ++i) {
            Paint paint;
            int n4 = bl ? n3 - i - 1 : i;
            Object[] objectArray = (Object[])list.get(n4);
            Object[] objectArray2 = (Object[])list.get(n4 + 1);
            int n5 = 0;
            if (objectArray2[0] == null) {
                n5 = -((Integer)objectArray[0]).intValue() - 1;
            } else {
                n5 = (Integer)objectArray2[0];
                if (n5 < 0) {
                    n5 = -((Integer)objectArray[0]).intValue() - 1;
                }
            }
            double d3 = (Double)objectArray[1];
            double d4 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d5 = (Double)objectArray2[1];
            double d6 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
            categoryItemLabelGenerator = this.createHorizontalBlock(d, d2, d4, d6, bl);
            Paint paint2 = paint = this.getItemPaint(n5, n2);
            if (paint2 instanceof Color) {
                paint2 = ((Color)paint).darker();
            }
            boolean bl2 = this.isDrawBarOutline();
            Paint paint3 = paint;
            if (bl2) {
                paint3 = this.getItemOutlinePaint(n5, n2);
                graphics2D.setStroke(this.getItemOutlineStroke(n5, n2));
            }
            for (int j = 0; j < 6; ++j) {
                if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
                    GradientPaint gradientPaint = (GradientPaint)paint;
                    paint = this.getGradientPaintTransformer().transform(gradientPaint, categoryItemLabelGenerator[j]);
                    paint2 = PaintAlpha.darker(paint);
                }
                if (j == 5) {
                    graphics2D.setPaint(paint);
                } else {
                    graphics2D.setPaint(paint2);
                }
                graphics2D.fill(categoryItemLabelGenerator[j]);
                if (!bl2) continue;
                graphics2D.setPaint(paint3);
                graphics2D.draw(categoryItemLabelGenerator[j]);
            }
            arrayList.add(new Object[]{new Integer(n5), categoryItemLabelGenerator[5].getBounds2D(), BooleanUtilities.valueOf((d3 < this.getBase() ? 1 : 0) != 0)});
            EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
            if (entityCollection == null) continue;
            this.addItemEntity(entityCollection, categoryDataset, n5, n2, categoryItemLabelGenerator[5]);
        }
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        for (n = 0; n < arrayList.size(); ++n) {
            Object[] objectArray = (Object[])arrayList.get(n);
            int n6 = (Integer)objectArray[0];
            Rectangle2D rectangle2D2 = (Rectangle2D)objectArray[1];
            d7 = rectangle2D2.getX();
            d8 = rectangle2D2.getY();
            d9 = rectangle2D2.getWidth();
            d10 = rectangle2D2.getHeight();
            boolean bl3 = (Boolean)objectArray[2];
            categoryItemLabelGenerator = this.getItemLabelGenerator(n6, n2);
            if (categoryItemLabelGenerator == null || !this.isItemLabelVisible(n6, n2)) continue;
            this.drawItemLabel(graphics2D, categoryDataset, n6, n2, categoryPlot, categoryItemLabelGenerator, rectangle2D2, bl3);
        }
        if (this.showTotal) {
            for (n = 0; n < arrayList.size(); ++n) {
                graphics2D.setPaint(this.totalLabelPaint);
                graphics2D.setFont(this.totalLabelFont);
                double d11 = this.calculateSumOfPositiveValuesForCategory(categoryDataset, n2);
                float f = (float)(d7 + d9 + 15.0);
                float f2 = (float)(d8 + d10 / 2.0);
                categoryItemLabelGenerator = TextAnchor.CENTER_LEFT;
                TextUtilities.drawRotatedString((String)this.totalFormatter.format(d11), (Graphics2D)graphics2D, (float)f, (float)f2, (TextAnchor)categoryItemLabelGenerator, (double)0.0, (TextAnchor)TextAnchor.CENTER);
            }
        }
    }

    private Shape[] createHorizontalBlock(double d, double d2, double d3, double d4, boolean bl) {
        Shape[] shapeArray = new Shape[6];
        Point2D.Double double_ = new Point2D.Double(d3, d);
        Point2D.Double double_2 = new Point2D.Double(d3, d + d2);
        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_2).getX() + this.getXOffset(), ((Point2D)double_2).getY() - this.getYOffset());
        Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + this.getXOffset(), ((Point2D)double_).getY() - this.getYOffset());
        Point2D.Double double_5 = new Point2D.Double(d4, d);
        Point2D.Double double_6 = new Point2D.Double(d4, d + d2);
        Point2D.Double double_7 = new Point2D.Double(((Point2D)double_6).getX() + this.getXOffset(), ((Point2D)double_6).getY() - this.getYOffset());
        Point2D.Double double_8 = new Point2D.Double(((Point2D)double_5).getX() + this.getXOffset(), ((Point2D)double_5).getY() - this.getYOffset());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath2.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath2.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath2.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath2.closePath();
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath3.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath3.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath3.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath3.closePath();
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath4.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath4.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath4.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath4.closePath();
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath5.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath5.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath5.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath5.closePath();
        GeneralPath generalPath6 = new GeneralPath();
        generalPath6.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath6.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath6.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath6.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath6.closePath();
        shapeArray[0] = generalPath;
        shapeArray[1] = generalPath3;
        if (bl) {
            shapeArray[2] = generalPath6;
            shapeArray[3] = generalPath5;
        } else {
            shapeArray[2] = generalPath5;
            shapeArray[3] = generalPath6;
        }
        shapeArray[4] = generalPath2;
        shapeArray[5] = generalPath4;
        return shapeArray;
    }

    protected void drawStackVertical(List list, Comparable comparable, Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset) {
        int n;
        int n2 = categoryDataset.getColumnIndex(comparable);
        double d = categoryAxis.getCategoryMiddle(n2, categoryDataset.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d2 = categoryItemRendererState.getBarWidth();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        boolean bl = valueAxis.isInverted();
        int n3 = list.size() - 1;
        for (int i = 0; i < n3; ++i) {
            Paint paint;
            int n4 = bl ? n3 - i - 1 : i;
            Object[] objectArray = (Object[])list.get(n4);
            Object[] objectArray2 = (Object[])list.get(n4 + 1);
            int n5 = 0;
            if (objectArray2[0] == null) {
                n5 = -((Integer)objectArray[0]).intValue() - 1;
            } else {
                n5 = (Integer)objectArray2[0];
                if (n5 < 0) {
                    n5 = -((Integer)objectArray[0]).intValue() - 1;
                }
            }
            double d3 = (Double)objectArray[1];
            double d4 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
            double d5 = (Double)objectArray2[1];
            double d6 = valueAxis.valueToJava2D(d5, rectangle2D, categoryPlot.getRangeAxisEdge());
            Shape[] shapeArray = this.createVerticalBlock(d, d2, d4, d6, bl);
            Paint paint2 = paint = this.getItemPaint(n5, n2);
            if (paint2 instanceof Color) {
                paint2 = ((Color)paint).darker();
            }
            boolean bl2 = this.isDrawBarOutline();
            Paint paint3 = paint;
            if (bl2) {
                paint3 = this.getItemOutlinePaint(n5, n2);
                graphics2D.setStroke(this.getItemOutlineStroke(n5, n2));
            }
            for (int j = 0; j < 6; ++j) {
                if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
                    GradientPaint gradientPaint = (GradientPaint)paint;
                    paint = this.getGradientPaintTransformer().transform(gradientPaint, shapeArray[j]);
                    paint2 = PaintAlpha.darker(paint);
                }
                if (j == 5) {
                    graphics2D.setPaint(paint);
                } else {
                    graphics2D.setPaint(paint2);
                }
                graphics2D.fill(shapeArray[j]);
                if (!bl2) continue;
                graphics2D.setPaint(paint3);
                graphics2D.draw(shapeArray[j]);
            }
            arrayList.add(new Object[]{new Integer(n5), shapeArray[5].getBounds2D(), BooleanUtilities.valueOf((d3 < this.getBase() ? 1 : 0) != 0)});
            EntityCollection entityCollection = categoryItemRendererState.getEntityCollection();
            if (entityCollection == null) continue;
            this.addItemEntity(entityCollection, categoryDataset, n5, n2, shapeArray[5]);
        }
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        for (n = 0; n < arrayList.size(); ++n) {
            Object[] objectArray = (Object[])arrayList.get(n);
            int n6 = (Integer)objectArray[0];
            Rectangle2D rectangle2D2 = (Rectangle2D)objectArray[1];
            d7 = rectangle2D2.getX();
            d8 = rectangle2D2.getY();
            d9 = rectangle2D2.getWidth();
            boolean bl3 = (Boolean)objectArray[2];
            CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n6, n2);
            if (categoryItemLabelGenerator == null || !this.isItemLabelVisible(n6, n2)) continue;
            this.drawItemLabel(graphics2D, categoryDataset, n6, n2, categoryPlot, categoryItemLabelGenerator, rectangle2D2, bl3);
        }
        if (this.showTotal) {
            for (n = 0; n < arrayList.size(); ++n) {
                graphics2D.setPaint(this.totalLabelPaint);
                graphics2D.setFont(this.totalLabelFont);
                double d10 = this.calculateSumOfPositiveValuesForCategory(categoryDataset, n2);
                float f = (float)(d7 + d9 / 2.0);
                float f2 = (float)d8 - 18.0f;
                TextAnchor textAnchor = TextAnchor.CENTER_LEFT;
                TextUtilities.drawRotatedString((String)this.totalFormatter.format(d10), (Graphics2D)graphics2D, (float)f, (float)f2, (TextAnchor)textAnchor, (double)0.0, (TextAnchor)TextAnchor.CENTER);
            }
        }
    }

    private Shape[] createVerticalBlock(double d, double d2, double d3, double d4, boolean bl) {
        Shape[] shapeArray = new Shape[6];
        Point2D.Double double_ = new Point2D.Double(d, d3);
        Point2D.Double double_2 = new Point2D.Double(d + d2, d3);
        Point2D.Double double_3 = new Point2D.Double(((Point2D)double_2).getX() + this.getXOffset(), ((Point2D)double_2).getY() - this.getYOffset());
        Point2D.Double double_4 = new Point2D.Double(((Point2D)double_).getX() + this.getXOffset(), ((Point2D)double_).getY() - this.getYOffset());
        Point2D.Double double_5 = new Point2D.Double(d, d4);
        Point2D.Double double_6 = new Point2D.Double(d + d2, d4);
        Point2D.Double double_7 = new Point2D.Double(((Point2D)double_6).getX() + this.getXOffset(), ((Point2D)double_6).getY() - this.getYOffset());
        Point2D.Double double_8 = new Point2D.Double(((Point2D)double_5).getX() + this.getXOffset(), ((Point2D)double_5).getY() - this.getYOffset());
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath.closePath();
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath2.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath2.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath2.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath2.closePath();
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath3.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath3.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath3.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath3.closePath();
        GeneralPath generalPath4 = new GeneralPath();
        generalPath4.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath4.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath4.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath4.lineTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath4.closePath();
        GeneralPath generalPath5 = new GeneralPath();
        generalPath5.moveTo((float)((Point2D)double_5).getX(), (float)((Point2D)double_5).getY());
        generalPath5.lineTo((float)((Point2D)double_6).getX(), (float)((Point2D)double_6).getY());
        generalPath5.lineTo((float)((Point2D)double_7).getX(), (float)((Point2D)double_7).getY());
        generalPath5.lineTo((float)((Point2D)double_8).getX(), (float)((Point2D)double_8).getY());
        generalPath5.closePath();
        GeneralPath generalPath6 = new GeneralPath();
        generalPath6.moveTo((float)((Point2D)double_).getX(), (float)((Point2D)double_).getY());
        generalPath6.lineTo((float)((Point2D)double_2).getX(), (float)((Point2D)double_2).getY());
        generalPath6.lineTo((float)((Point2D)double_3).getX(), (float)((Point2D)double_3).getY());
        generalPath6.lineTo((float)((Point2D)double_4).getX(), (float)((Point2D)double_4).getY());
        generalPath6.closePath();
        shapeArray[0] = generalPath6;
        shapeArray[1] = generalPath3;
        shapeArray[2] = generalPath2;
        shapeArray[3] = generalPath;
        shapeArray[4] = generalPath5;
        shapeArray[5] = generalPath4;
        if (bl) {
            shapeArray[0] = generalPath5;
            shapeArray[4] = generalPath6;
        }
        return shapeArray;
    }

    public void drawItem2(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        int n4 = categoryItemRendererState.getVisibleSeriesIndex(n);
        if (n4 < 0) {
            return;
        }
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = this.calculateBarW0(categoryPlot, plotOrientation, double_, categoryAxis, categoryItemRendererState, n4, n2);
        double[] dArray = this.calculateBarL0L1(d);
        if (dArray == null) {
            return;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(dArray[0], (Rectangle2D)double_, rectangleEdge);
        double d4 = valueAxis.valueToJava2D(dArray[1], (Rectangle2D)double_, rectangleEdge);
        double d5 = Math.min(d3, d4);
        double d6 = Math.abs(d4 - d3);
        Rectangle2D.Double double_2 = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d5, d2, d6, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d2, d5, categoryItemRendererState.getBarWidth(), d6);
        Paint paint = this.getItemPaint(n, n2);
        if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
            GradientPaint gradientPaint = (GradientPaint)paint;
            paint = this.getGradientPaintTransformer().transform(gradientPaint, (Shape)double_2);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        double d7 = double_2.getMinX();
        double d8 = d7 + this.getXOffset();
        double d9 = double_2.getMaxX();
        double d10 = d9 + this.getXOffset();
        double d11 = double_2.getMinY() - this.getYOffset();
        double d12 = double_2.getMinY();
        double d13 = double_2.getMaxY() - this.getYOffset();
        double d14 = double_2.getMaxY();
        GeneralPath generalPath = null;
        if (d6 > 0.0) {
            generalPath = new GeneralPath();
            generalPath.moveTo((float)d9, (float)d14);
            generalPath.lineTo((float)d9, (float)d12);
            generalPath.lineTo((float)d10, (float)d11);
            generalPath.lineTo((float)d10, (float)d13);
            generalPath.closePath();
            graphics2D.setPaint(PaintAlpha.darker(paint));
            graphics2D.fill(generalPath);
        }
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)d7, (float)d12);
        generalPath2.lineTo((float)d8, (float)d11);
        generalPath2.lineTo((float)d10, (float)d11);
        generalPath2.lineTo((float)d9, (float)d12);
        generalPath2.closePath();
        graphics2D.fill(generalPath2);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_2);
            if (generalPath != null) {
                graphics2D.draw(generalPath);
            }
            graphics2D.draw(generalPath2);
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_2, d < 0.0);
        }
        if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            GeneralPath generalPath3 = new GeneralPath();
            generalPath3.moveTo((float)d7, (float)d14);
            generalPath3.lineTo((float)d7, (float)d12);
            generalPath3.lineTo((float)d8, (float)d11);
            generalPath3.lineTo((float)d10, (float)d11);
            generalPath3.lineTo((float)d10, (float)d13);
            generalPath3.lineTo((float)d9, (float)d14);
            generalPath3.closePath();
            this.addItemEntity(entityCollection, categoryDataset, n, n2, generalPath3);
        }
    }

    private double calculateSumOfPositiveValuesForCategory(CategoryDataset categoryDataset, int n) {
        double d = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d2;
            Number number = categoryDataset.getValue(i, n);
            if (number == null || !((d2 = number.doubleValue()) > 0.0)) continue;
            d += d2;
        }
        return d;
    }

    private double calculateSumOfNegativeValuesForCategory(CategoryDataset categoryDataset, int n) {
        double d = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d2;
            Number number = categoryDataset.getValue(i, n);
            if (number == null || !((d2 = number.doubleValue()) < 0.0)) continue;
            d += d2;
        }
        return d;
    }
}

