/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.ChartFactory;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.data.category.DefaultCategoryDataset;
import ai.org.jfree.ui.GradientPaintTransformType;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.StandardGradientPaintTransformer;
import com.activeintra.aichart.AIChartModule;
import com.activeintra.aichart.CustomCylinderRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;

public class CylinderBarChart
extends AIChartModule {
    public String toString() {
        return "4. Cylinder Bar Chart";
    }

    public int getNoOfCharts() {
        return 1;
    }

    public JFreeChart createChart(int n) {
        this.getChartObject();
        if (this.data.length < 1) {
            return this.getErrorChart();
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i = 0; i < 1; ++i) {
            for (int j = 0; j < this.labels.length; ++j) {
                double d = this.data[i][j];
                defaultCategoryDataset.addValue(d, (Comparable)((Object)this.series[i]), (Comparable)((Object)this.labels[j]));
            }
        }
        return this.createChart((CategoryDataset)defaultCategoryDataset);
    }

    public JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart3D((String)"", (String)"", (String)"", (CategoryDataset)categoryDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        jFreeChart.setBackgroundPaint((Paint)new Color(225, 225, 225));
        jFreeChart.setBorderVisible(true);
        jFreeChart.setAntiAlias(true);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setNoDataMessage("NO DATA!");
        categoryPlot.setBackgroundPaint(null);
        categoryPlot.setOutlinePaint((Paint)Color.black);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint((Paint)new Color(112, 112, 112));
        BasicStroke basicStroke = new BasicStroke(0.1f);
        categoryPlot.setRangeGridlineStroke((Stroke)basicStroke);
        categoryPlot.setRangePannable(true);
        categoryPlot.setBackgroundPaint((Paint)Color.white);
        categoryPlot.setForegroundAlpha(1.0f);
        Paint[] paintArray = this.createPaint();
        CustomCylinderRenderer customCylinderRenderer = new CustomCylinderRenderer(paintArray);
        customCylinderRenderer.setGradientPaintTransformer((GradientPaintTransformer)new StandardGradientPaintTransformer(GradientPaintTransformType.CENTER_HORIZONTAL));
        customCylinderRenderer.setDrawBarOutline(true);
        customCylinderRenderer.setBaseOutlinePaint(Color.black);
        customCylinderRenderer.setBaseOutlineStroke(new BasicStroke(0.5f));
        categoryPlot.setRenderer((CategoryItemRenderer)customCylinderRenderer);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setTickMarkPaint((Paint)Color.black);
        return jFreeChart;
    }

    private Paint[] createPaint() {
        Paint[] paintArray = new Paint[this.labels.length];
        for (int i = 0; i < this.labels.length; ++i) {
            Color color = new Color(this.colorArray[i]);
            paintArray[i] = new GradientPaint(0.0f, 0.0f, color, 0.0f, 0.0f, color.brighter());
        }
        return paintArray;
    }
}

