/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.axis.CategoryAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.CategoryItemEntity;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.labels.CategoryItemLabelGenerator;
import ai.org.jfree.chart.labels.CategoryToolTipGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.BarRenderer;
import ai.org.jfree.chart.renderer.category.CategoryItemRendererState;
import ai.org.jfree.chart.renderer.category.StackedBarRenderer;
import ai.org.jfree.data.category.CategoryDataset;
import ai.org.jfree.text.TextUtilities;
import ai.org.jfree.ui.GradientPaintTransformer;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.TextAnchor;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;

public class CustomStackedBarRenderer
extends StackedBarRenderer {
    private boolean showPositiveTotal = true;
    private boolean showNegativeTotal = true;
    private Font totalLabelFont = new Font("\uad74\ub9bc\uccb4", 1, 12);
    private NumberFormat totalFormatter = NumberFormat.getInstance();
    private Paint totalLabelPaint = Color.black;

    public NumberFormat getTotalFormatter() {
        return this.totalFormatter;
    }

    public void setTotalFormatter(NumberFormat numberFormat) {
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null format not permitted.");
        }
        this.totalFormatter = numberFormat;
    }

    public void setTotalLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.setTotalLabelFont(font, true);
    }

    public void setTotalLabelFont(Font font, boolean bl) {
        this.totalLabelFont = font;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void setTotalLabelPaint(Paint paint) {
        this.setTotalLabelPaint(paint, true);
    }

    public void setTotalLabelPaint(Paint paint, boolean bl) {
        this.totalLabelPaint = paint;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        TextAnchor textAnchor;
        float f;
        float f2;
        double d;
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d2;
        double d3;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d4 = number.doubleValue();
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d5 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d6 = 0.0;
        double d7 = 0.0;
        for (int i = 0; i < n; ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null) continue;
            double d8 = number2.doubleValue();
            if (d8 > 0.0) {
                d6 += d8;
                continue;
            }
            d7 += d8;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d4 > 0.0) {
            d3 = valueAxis.valueToJava2D(d6, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d6 + d4, rectangle2D, rectangleEdge);
        } else {
            d3 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
            d2 = valueAxis.valueToJava2D(d7 + d4, rectangle2D, rectangleEdge);
        }
        double d9 = Math.min(d3, d2);
        double d10 = Math.max(Math.abs(d2 - d3), this.getMinimumBarLength());
        Rectangle2D.Double double_ = null;
        double_ = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d9, d5, d10, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d5, d9, categoryItemRendererState.getBarWidth(), d10);
        Paint paint = this.getItemPaint(n, n2);
        GradientPaintTransformer gradientPaintTransformer = ((BarRenderer)categoryPlot.getRenderer()).getGradientPaintTransformer();
        if (gradientPaintTransformer != null && paint instanceof GradientPaint) {
            paint = gradientPaintTransformer.transform((GradientPaint)paint, (Shape)double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_, d4 < 0.0);
        }
        if (d4 > 0.0) {
            if (this.showPositiveTotal && this.isLastPositiveItem(categoryDataset, n, n2)) {
                graphics2D.setPaint(this.totalLabelPaint);
                graphics2D.setFont(this.totalLabelFont);
                d = this.calculateSumOfPositiveValuesForCategory(categoryDataset, n2);
                f2 = (float)double_.getCenterX();
                f = (float)double_.getMinY() - 4.0f;
                textAnchor = TextAnchor.BOTTOM_CENTER;
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    f2 = (float)double_.getMaxX() + 4.0f;
                    f = (float)double_.getCenterY();
                    textAnchor = TextAnchor.CENTER_LEFT;
                }
                TextUtilities.drawRotatedString((String)this.totalFormatter.format(d), (Graphics2D)graphics2D, (float)f2, (float)f, (TextAnchor)textAnchor, (double)0.0, (TextAnchor)TextAnchor.CENTER);
            }
        } else if (this.showNegativeTotal && this.isLastNegativeItem(categoryDataset, n, n2)) {
            graphics2D.setPaint(this.totalLabelPaint);
            graphics2D.setFont(this.totalLabelFont);
            d = this.calculateSumOfNegativeValuesForCategory(categoryDataset, n2);
            f2 = (float)double_.getCenterX();
            f = (float)double_.getMaxY() + 4.0f;
            textAnchor = TextAnchor.TOP_CENTER;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                f2 = (float)double_.getMinX() - 4.0f;
                f = (float)double_.getCenterY();
                textAnchor = TextAnchor.CENTER_RIGHT;
            }
            TextUtilities.drawRotatedString((String)this.totalFormatter.format(d), (Graphics2D)graphics2D, (float)f2, (float)f, (TextAnchor)textAnchor, (double)0.0, (TextAnchor)TextAnchor.CENTER);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            textAnchor = new CategoryItemEntity((Shape)double_, string, string2, categoryDataset, categoryDataset.getRowKey(n), categoryDataset.getColumnKey(n2));
            entityCollection.add((ChartEntity)textAnchor);
        }
    }

    private boolean isLastPositiveItem(CategoryDataset categoryDataset, int n, int n2) {
        boolean bl = true;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return false;
        }
        for (int i = n + 1; i < categoryDataset.getRowCount(); ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null) continue;
            bl = bl && number2.doubleValue() <= 0.0;
        }
        return bl;
    }

    private boolean isLastNegativeItem(CategoryDataset categoryDataset, int n, int n2) {
        boolean bl = true;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return false;
        }
        for (int i = n + 1; i < categoryDataset.getRowCount(); ++i) {
            Number number2 = categoryDataset.getValue(i, n2);
            if (number2 == null) continue;
            bl = bl && number2.doubleValue() >= 0.0;
        }
        return bl;
    }

    private double calculateSumOfPositiveValuesForCategory(CategoryDataset categoryDataset, int n) {
        double d = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d2;
            Number number = categoryDataset.getValue(i, n);
            if (number == null || !((d2 = number.doubleValue()) > 0.0)) continue;
            d += d2;
        }
        return d;
    }

    private double calculateSumOfNegativeValuesForCategory(CategoryDataset categoryDataset, int n) {
        double d = 0.0;
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            double d2;
            Number number = categoryDataset.getValue(i, n);
            if (number == null || !((d2 = number.doubleValue()) < 0.0)) continue;
            d += d2;
        }
        return d;
    }
}

