/*
 * Decompiled with CFR 0.152.
 */
package com.activeintra.aichart;

import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.PieSectionEntity;
import ai.org.jfree.chart.labels.PieToolTipGenerator;
import ai.org.jfree.chart.plot.PiePlotState;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.PlotState;
import ai.org.jfree.data.general.DatasetUtilities;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.ui.RectangleInsets;
import com.activeintra.aichart.CustomPiePlot;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Transparency;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CustomPiePlot3D
extends CustomPiePlot
implements Serializable {
    private int angle = 0;
    private double depthFactor = 0.12;
    private boolean darkerSides = false;

    public void setAngle(int n) {
        this.angle = n;
    }

    public CustomPiePlot3D() {
        this(null);
    }

    public CustomPiePlot3D(PieDataset pieDataset) {
        super(pieDataset);
        this.setCircular(false, false);
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void setDepthFactor(double d) {
        this.depthFactor = d;
        this.fireChangeEvent();
    }

    public boolean getDarkerSides() {
        return this.darkerSides;
    }

    public void setDarkerSides(boolean bl) {
        this.darkerSides = bl;
        this.fireChangeEvent();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Transparency transparency;
        Object object;
        Object object2;
        Stroke stroke;
        Paint paint;
        Paint paint2;
        Arc2D.Double double_;
        int n;
        Serializable serializable;
        Object object422;
        List list;
        double d;
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        if (this.getShadowGenerator() != null) {
            bufferedImage = new BufferedImage((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(-rectangle2D.getX(), -rectangle2D.getY());
            graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
            rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        }
        double d2 = this.getInteriorGap();
        double d3 = 0.0;
        if (this.getLabelGenerator() != null) {
            d3 = this.getLabelGap() + this.getMaximumLabelWidth();
        }
        double d4 = rectangle2D.getWidth() * (d2 + d3) * 2.0;
        double d5 = rectangle2D.getHeight() * (d2 + d3 + 0.1) * 2.0;
        double d6 = rectangle2D.getX() + d4 / 2.0;
        double d7 = rectangle2D.getY() + d5 / 2.0;
        double d8 = rectangle2D.getWidth() - d4;
        double d9 = rectangle2D.getHeight() - d5;
        if (this.isCircular()) {
            d = Math.min(d8, d9) / 2.0;
            d6 = (d6 + d6 + d8) / 2.0 - d;
            d7 = (d7 + d7 + d9) / 2.0 - d;
            d8 = 2.0 * d;
            d9 = 2.0 * d;
        }
        d = d9;
        d9 = d8 / (1.0 + (double)this.angle / 10.0);
        PiePlotState piePlotState = this.initialise(graphics2D, rectangle2D, this, null, plotRenderingInfo);
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d6, d7, d8, d9 * (1.0 - this.depthFactor));
        piePlotState.setLinkArea((Rectangle2D)double_2);
        double d10 = d8 * this.getLabelLinkMargin();
        double d11 = d9 * this.getLabelLinkMargin();
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d6 + d10 / 2.0, d7 + d11 / 2.0, d8 - d10, d9 - d11);
        piePlotState.setExplodedPieArea((Rectangle2D)double_3);
        double d12 = this.getMaximumExplodePercent();
        double d13 = d12 / (1.0 + d12);
        double d14 = ((RectangularShape)double_3).getWidth() * d13;
        double d15 = ((RectangularShape)double_3).getHeight() * d13;
        Rectangle2D.Double double_4 = new Rectangle2D.Double(((RectangularShape)double_3).getX() + d14 / 2.0, ((RectangularShape)double_3).getY() + d15 / 2.0, ((RectangularShape)double_3).getWidth() - d14, ((RectangularShape)double_3).getHeight() - d15);
        int n2 = (int)(d * this.depthFactor);
        Rectangle2D.Double double_5 = new Rectangle2D.Double(d6, d7, d8, d9 - (double)n2);
        piePlotState.setLinkArea((Rectangle2D)double_5);
        piePlotState.setPieArea((Rectangle2D)double_4);
        piePlotState.setPieCenterX(double_4.getCenterX());
        piePlotState.setPieCenterY(double_4.getCenterY() - (double)n2 / 2.0);
        piePlotState.setPieWRadius(((RectangularShape)double_4).getWidth() / 2.0);
        piePlotState.setPieHRadius((((RectangularShape)double_4).getHeight() - (double)n2) / 2.0);
        PieDataset pieDataset = this.getDataset();
        if (DatasetUtilities.isEmptyOrNull((PieDataset)this.getDataset())) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
            graphics2D.setClip(shape);
            this.drawOutline(graphics2D, rectangle2D);
            return;
        }
        if ((double)pieDataset.getKeys().size() > rectangle2D.getWidth()) {
            String string = localizationResources.getString("Too_many_elements");
            Font font = new Font("dialog", 1, 10);
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            int n3 = fontMetrics.stringWidth(string);
            graphics2D.drawString(string, (int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)n3) / 2.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
            return;
        }
        if (this.isCircular()) {
            double d16 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
            rectangle2D = new Rectangle2D.Double(rectangle2D.getCenterX() - d16, rectangle2D.getCenterY() - d16, 2.0 * d16, 2.0 * d16);
        }
        if ((list = pieDataset.getKeys()).size() == 0) {
            return;
        }
        double d17 = ((RectangularShape)double_4).getX();
        double d18 = ((RectangularShape)double_4).getY();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        double d19 = DatasetUtilities.calculatePieDatasetTotal((PieDataset)pieDataset);
        double d20 = 0.0;
        if (n2 < 0) {
            return;
        }
        ArrayList<Arc2D.Double> arrayList = new ArrayList<Arc2D.Double>();
        for (Object object422 : list) {
            double d21;
            double d22;
            serializable = pieDataset.getValue((Comparable)object422);
            if (serializable == null) {
                arrayList.add(null);
                continue;
            }
            double d23 = ((Number)serializable).doubleValue();
            if (d23 <= 0.0) {
                arrayList.add(null);
                continue;
            }
            double d24 = this.getStartAngle();
            double d25 = d24 + (d22 = this.getDirection().getFactor()) * (d20 + d23) * 360.0 / d19;
            if (Math.abs(d25 - (d21 = d24 + d22 * (d20 * 360.0) / d19)) > this.getMinimumArcAngleToDraw()) {
                arrayList.add(new Arc2D.Double(d17, d18 + (double)n2, ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n2, d21, d25 - d21, 2));
            } else {
                arrayList.add(null);
            }
            d20 += d23;
        }
        object422 = graphics2D.getClip();
        serializable = new Ellipse2D.Double(((RectangularShape)double_4).getX(), ((RectangularShape)double_4).getY(), ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n2);
        Ellipse2D.Double double_6 = new Ellipse2D.Double(((RectangularShape)double_4).getX(), ((RectangularShape)double_4).getY() + (double)n2, ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n2);
        Rectangle2D.Double double_7 = new Rectangle2D.Double(((RectangularShape)((Object)serializable)).getX(), ((RectangularShape)((Object)serializable)).getCenterY(), ((RectangularShape)double_4).getWidth(), double_6.getMaxY() - ((RectangularShape)((Object)serializable)).getCenterY());
        Rectangle2D.Double double_8 = new Rectangle2D.Double(((RectangularShape)double_4).getX(), ((RectangularShape)((Object)serializable)).getY(), ((RectangularShape)double_4).getWidth(), double_6.getCenterY() - ((RectangularShape)((Object)serializable)).getY());
        Area area = new Area((Shape)((Object)serializable));
        area.add(new Area(double_7));
        Area area2 = new Area(double_6);
        area2.add(new Area(double_8));
        Area area3 = new Area(area);
        area3.intersect(area2);
        Area area4 = new Area(area3);
        area4.subtract(new Area((Shape)((Object)serializable)));
        Area area5 = new Area(area3);
        area5.subtract(new Area(double_6));
        int n4 = arrayList.size();
        for (n = 0; n < n4; ++n) {
            double_ = (Arc2D.Double)arrayList.get(n);
            if (double_ == null) continue;
            Comparable object32 = this.getSectionKey(n);
            paint2 = this.lookupSectionPaint(object32);
            paint = this.lookupSectionOutlinePaint(object32);
            stroke = this.lookupSectionOutlineStroke(object32);
            graphics2D.setPaint(paint2);
            graphics2D.fill(double_);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw(double_);
            graphics2D.setPaint(paint2);
            object2 = double_.getStartPoint();
            int[] nArray = new int[]{(int)double_.getCenterX(), (int)double_.getCenterX(), (int)((Point2D)object2).getX(), (int)((Point2D)object2).getX()};
            int[] nArray2 = new int[]{(int)double_.getCenterY(), (int)double_.getCenterY() - n2, (int)((Point2D)object2).getY() - n2, (int)((Point2D)object2).getY()};
            object = new Polygon(nArray, nArray2, 4);
            graphics2D.setPaint(Color.lightGray);
            graphics2D.fill((Shape)object);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            graphics2D.draw((Shape)object);
            graphics2D.setPaint(paint2);
        }
        graphics2D.setPaint(Color.gray);
        graphics2D.fill(area5);
        graphics2D.fill(area4);
        n = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                object2 = this.getSectionKey(n);
                paint2 = this.lookupSectionPaint((Comparable)object2);
                paint = this.lookupSectionOutlinePaint((Comparable)object2);
                stroke = this.lookupSectionOutlineStroke((Comparable)object2);
                this.drawSide(graphics2D, double_4, arc2D, area4, area5, paint2, paint, stroke, false, true);
            }
            ++n;
        }
        n = 0;
        for (Arc2D arc2D : arrayList) {
            if (arc2D != null) {
                object2 = this.getSectionKey(n);
                paint2 = this.lookupSectionPaint((Comparable)object2);
                paint = this.lookupSectionOutlinePaint((Comparable)object2);
                stroke = this.lookupSectionOutlineStroke((Comparable)object2);
                this.drawSide(graphics2D, double_4, arc2D, area4, area5, paint2, paint, stroke, true, false);
            }
            ++n;
        }
        graphics2D.setClip((Shape)object422);
        for (int i = 0; i < n4; ++i) {
            double_ = (Arc2D.Double)arrayList.get(i);
            if (double_ == null) continue;
            Arc2D.Double double_9 = new Arc2D.Double(d17, d18, ((RectangularShape)double_4).getWidth(), ((RectangularShape)double_4).getHeight() - (double)n2, double_.getAngleStart(), double_.getAngleExtent(), 2);
            object = (Comparable)list.get(i);
            paint2 = this.lookupSectionPaint((Comparable)object, true);
            if (this.getGradientPaintTransformer() != null && paint2 instanceof GradientPaint) {
                transparency = (GradientPaint)paint2;
                paint2 = this.getGradientPaintTransformer().transform((GradientPaint)transparency, (Shape)double_9);
            }
            paint = this.lookupSectionOutlinePaint((Comparable)object);
            stroke = this.lookupSectionOutlineStroke((Comparable)object);
            graphics2D.setPaint(paint2);
            graphics2D.fill(double_9);
            graphics2D.draw(double_9);
            if (plotRenderingInfo == null || (transparency = plotRenderingInfo.getOwner().getEntityCollection()) == null) continue;
            String string = null;
            PieToolTipGenerator pieToolTipGenerator = this.getToolTipGenerator();
            if (pieToolTipGenerator != null) {
                string = pieToolTipGenerator.generateToolTip(pieDataset, (Comparable)object);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(pieDataset, (Comparable)object, this.getPieIndex());
            }
            PieSectionEntity pieSectionEntity = new PieSectionEntity((Shape)double_9, pieDataset, this.getPieIndex(), i, (Comparable)object, string, string2);
            transparency.add((ChartEntity)pieSectionEntity);
        }
        List list2 = pieDataset.getKeys();
        object = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth(), rectangle2D2.getHeight() - (double)n2);
        if (this.getSimpleLabels()) {
            this.drawSimpleLabels(graphics2D, list2, d19, (Rectangle2D)object, double_5, piePlotState);
        } else {
            this.drawLabels(graphics2D, list2, d19, (Rectangle2D)object, double_5, piePlotState);
        }
        if (this.getShadowGenerator() != null) {
            transparency = this.getShadowGenerator().createDropShadow(bufferedImage);
            graphics2D = graphics2D2;
            graphics2D.drawImage((Image)((Object)transparency), (int)rectangle2D.getX() + this.getShadowGenerator().calculateOffsetX(), (int)rectangle2D.getY() + this.getShadowGenerator().calculateOffsetY(), null);
            graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D.getX(), (int)rectangle2D.getY(), null);
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    protected void drawSide(Graphics2D graphics2D, Rectangle2D rectangle2D, Arc2D arc2D, Area area, Area area2, Paint paint, Paint paint2, Stroke stroke, boolean bl, boolean bl2) {
        if (this.getDarkerSides()) {
            Color color;
            if (paint instanceof Color) {
                color = (Color)paint;
                color = color.darker();
                paint = color;
            } else if (paint instanceof GradientPaint) {
                color = ((GradientPaint)paint).getColor1();
                color = color.darker();
                paint = color;
            }
        }
        double d = arc2D.getAngleStart();
        double d2 = arc2D.getAngleExtent();
        double d3 = d + d2;
        graphics2D.setStroke(stroke);
        if (d2 < 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 > -180.0) {
                        if (bl) {
                            Area area3 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                            area3.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area3);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area3);
                        }
                    } else {
                        Area area4 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area4.intersect(area);
                        Area area5 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area5.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl) {
                            graphics2D.fill(area4);
                            graphics2D.fill(area5);
                        }
                        if (bl2) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl) {
                            graphics2D.draw(area4);
                            graphics2D.draw(area5);
                        }
                        if (bl2) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area6;
                    if (bl2) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                    if (bl) {
                        area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area6.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area6);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area6);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 > -180.0) {
                    if (bl2) {
                        Area area7 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area7.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area7);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area7);
                    }
                } else {
                    Area area8 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area8.intersect(area2);
                    Area area9 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area9.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl2) {
                        graphics2D.fill(area8);
                        graphics2D.fill(area9);
                    }
                    if (bl) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl2) {
                        graphics2D.draw(area8);
                        graphics2D.draw(area9);
                    }
                    if (bl) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area10;
                if (bl2) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
                if (bl) {
                    area10 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area10.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area10);
                }
            }
        } else if (d2 > 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 < 180.0) {
                        if (bl) {
                            Area area11 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                            area11.intersect(area);
                            graphics2D.setPaint(paint);
                            graphics2D.fill(area11);
                            graphics2D.setPaint(paint2);
                            graphics2D.draw(area11);
                        }
                    } else {
                        Area area12 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area12.intersect(area);
                        Area area13 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area13.intersect(area);
                        graphics2D.setPaint(paint);
                        if (bl) {
                            graphics2D.fill(area12);
                            graphics2D.fill(area13);
                        }
                        if (bl2) {
                            graphics2D.fill(area2);
                        }
                        graphics2D.setPaint(paint2);
                        if (bl) {
                            graphics2D.draw(area12);
                            graphics2D.draw(area13);
                        }
                        if (bl2) {
                            graphics2D.draw(area2);
                        }
                    }
                } else {
                    Area area14;
                    if (bl2) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                    if (bl) {
                        area14 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area14);
                    }
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 < 180.0) {
                    if (bl2) {
                        Area area15 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area15.intersect(area2);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area15);
                        graphics2D.setPaint(paint2);
                        graphics2D.draw(area15);
                    }
                } else {
                    Area area16 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area16.intersect(area2);
                    Area area17 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area17.intersect(area2);
                    graphics2D.setPaint(paint);
                    if (bl2) {
                        graphics2D.fill(area16);
                        graphics2D.fill(area17);
                    }
                    if (bl) {
                        graphics2D.fill(area);
                    }
                    graphics2D.setPaint(paint2);
                    if (bl2) {
                        graphics2D.draw(area16);
                        graphics2D.draw(area17);
                    }
                    if (bl) {
                        graphics2D.draw(area);
                    }
                }
            } else {
                Area area18;
                if (bl2) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
                if (bl) {
                    area18 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area18.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(area18);
                }
            }
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Pie_3D_Plot");
    }

    private boolean isAngleAtFront(double d) {
        return Math.sin(Math.toRadians(d)) < 0.0;
    }

    private boolean isAngleAtBack(double d) {
        return Math.sin(Math.toRadians(d)) > 0.0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CustomPiePlot3D)) {
            return false;
        }
        CustomPiePlot3D customPiePlot3D = (CustomPiePlot3D)object;
        if (this.depthFactor != customPiePlot3D.depthFactor) {
            return false;
        }
        if (this.darkerSides != customPiePlot3D.darkerSides) {
            return false;
        }
        return super.equals(object);
    }
}

