/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.web.servlet.persistence;

import com.captcha.botdetect.CodeStyle;
import com.captcha.botdetect.HelpLinkMode;
import com.captcha.botdetect.ImageFormat;
import com.captcha.botdetect.ImageSize;
import com.captcha.botdetect.ImageStyle;
import com.captcha.botdetect.SoundFormat;
import com.captcha.botdetect.SoundRegenerationMode;
import com.captcha.botdetect.SoundStyle;
import com.captcha.botdetect.configuration.ICaptchaConfiguration;
import com.captcha.botdetect.internal.core.CaptchaBase;
import com.captcha.botdetect.internal.core.captchacode.CodeCollection;
import com.captcha.botdetect.internal.core.captchacode.DisallowedCodeSubstrings;
import com.captcha.botdetect.internal.infrastructure.text.StringHelper;
import com.captcha.botdetect.web.servlet.Captcha;
import com.captcha.botdetect.web.servlet.persistence.IPersistenceProvider;
import java.awt.Color;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaptchaPersistence {
    private IPersistenceProvider userState;
    private ICaptchaConfiguration captchaConfiguration;

    public CaptchaPersistence(IPersistenceProvider iPersistenceProvider, ICaptchaConfiguration iCaptchaConfiguration) {
        this.userState = iPersistenceProvider;
        this.captchaConfiguration = iCaptchaConfiguration;
    }

    public Captcha load(String string) {
        Captcha captcha = new Captcha(string, this.captchaConfiguration, this);
        captcha.initialize();
        return captcha;
    }

    public String getCodeLengthKey(String string) {
        return "BDC_codeLength_" + string;
    }

    public void loadCodeLength(CaptchaBase captchaBase, String string) {
        String string2 = this.getCodeLengthKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setCodeLength(((Integer)this.userState.load(string2)).intValue());
        }
    }

    public void saveCodeLength(String string, Integer n) {
        String string2 = this.getCodeLengthKey(string);
        if (this.userState != null) {
            if (n != null) {
                this.userState.save(string2, n);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getCodeStyleKey(String string) {
        return "BDC_codeStyle_" + string;
    }

    public void loadCodeStyle(CaptchaBase captchaBase, String string) {
        String string2 = this.getCodeStyleKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setCodeStyle((CodeStyle)this.userState.load(string2));
        }
    }

    public void saveCodeStyle(String string, CodeStyle codeStyle) {
        String string2 = this.getCodeStyleKey(string);
        if (this.userState != null) {
            if (codeStyle != null) {
                this.userState.save(string2, codeStyle);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getCodeTimeoutKey(String string) {
        return "BDC_codeTimeout_" + string;
    }

    public void loadCodeTimeout(CaptchaBase captchaBase, String string) {
        String string2 = this.getCodeTimeoutKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setCodeTimeout(((Integer)this.userState.load(string2)).intValue());
        }
    }

    public void saveCodeTimeout(String string, Integer n) {
        String string2 = this.getCodeTimeoutKey(string);
        if (this.userState != null) {
            if (n != null) {
                this.userState.save(string2, n);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getDisallowedCodeSubstringsKey(String string) {
        return "BDC_disallowedCodeSubstrings_" + string;
    }

    public void loadDisallowedCodeSubstrings(CaptchaBase captchaBase, String string) {
        String string2 = this.getDisallowedCodeSubstringsKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setDisallowedCodeSubstrings((DisallowedCodeSubstrings)this.userState.load(string2));
        }
    }

    public void saveDisallowedCodeSubstrings(String string, DisallowedCodeSubstrings disallowedCodeSubstrings) {
        String string2 = this.getDisallowedCodeSubstringsKey(string);
        if (this.userState != null) {
            if (disallowedCodeSubstrings != null) {
                this.userState.save(string2, disallowedCodeSubstrings);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getImageStyleKey(String string) {
        return "BDC_imageStyle_" + string;
    }

    public void loadImageStyle(CaptchaBase captchaBase, String string) {
        String string2 = this.getImageStyleKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setImageStyle((List)this.userState.load(string2));
        }
    }

    public void saveImageStyle(String string, List<ImageStyle> list) {
        String string2 = this.getImageStyleKey(string);
        if (this.userState != null) {
            if (list != null) {
                this.userState.save(string2, list);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getImageFormatKey(String string) {
        return "BDC_imageFormat_" + string;
    }

    public void loadImageFormat(CaptchaBase captchaBase, String string) {
        String string2 = this.getImageFormatKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setImageFormat((ImageFormat)this.userState.load(string2));
        }
    }

    public void saveImageFormat(String string, ImageFormat imageFormat) {
        String string2 = this.getImageFormatKey(string);
        if (this.userState != null) {
            if (imageFormat != null && !this.captchaConfiguration.getImageFormat().name().equalsIgnoreCase(imageFormat.name())) {
                this.userState.save(string2, imageFormat);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getImageSizeKey(String string) {
        return "BDC_imageSize_" + string;
    }

    public void loadImageSize(CaptchaBase captchaBase, String string) {
        String string2 = this.getImageSizeKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setImageSize((ImageSize)this.userState.load(string2));
        }
    }

    public void saveImageSize(String string, ImageSize imageSize) {
        String string2 = this.getImageSizeKey(string);
        if (this.userState != null) {
            if (this.captchaConfiguration.getImageSize().getWidth() != imageSize.getWidth() || this.captchaConfiguration.getImageSize().getHeight() != imageSize.getHeight()) {
                this.userState.save(string2, imageSize);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getCustomLightColorKey(String string) {
        return "BDC_customLightColor_" + string;
    }

    public void loadCustomLightColor(CaptchaBase captchaBase, String string) {
        String string2 = this.getCustomLightColorKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setCustomLightColor((Color)this.userState.load(string2));
        }
    }

    public void saveCustomLightColor(String string, Color color) {
        String string2 = this.getCustomLightColorKey(string);
        if (this.userState != null) {
            if (color != null && this.captchaConfiguration.getCustomLightColor() != color) {
                this.userState.save(string2, color);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getCustomDarkColorKey(String string) {
        return "BDC_customDarkColor_" + string;
    }

    public void loadCustomDarkColor(CaptchaBase captchaBase, String string) {
        String string2 = this.getCustomDarkColorKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setCustomDarkColor((Color)this.userState.load(string2));
        }
    }

    public void saveCustomDarkColor(String string, Color color) {
        String string2 = this.getCustomDarkColorKey(string);
        if (this.userState != null) {
            if (color != null && this.captchaConfiguration.getCustomDarkColor() != color) {
                this.userState.save(string2, color);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getSoundEnabledKey(String string) {
        return "BDC_soundEnabled_" + string;
    }

    public void loadSoundEnabled(CaptchaBase captchaBase, String string) {
        String string2 = this.getSoundEnabledKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setSoundEnabled(((Boolean)this.userState.load(string2)).booleanValue());
        }
    }

    public void saveSoundEnabled(String string, boolean bl) {
        String string2 = this.getSoundEnabledKey(string);
        if (this.userState != null) {
            if (this.captchaConfiguration.isSoundEnabled() != bl) {
                this.userState.save(string2, bl);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getSoundStyleKey(String string) {
        return "BDC_soundStyle_" + string;
    }

    public void loadSoundStyle(CaptchaBase captchaBase, String string) {
        String string2 = this.getSoundStyleKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setSoundStyle((List)this.userState.load(string2));
        }
    }

    public void saveSoundStyle(String string, List<SoundStyle> list) {
        String string2 = this.getSoundStyleKey(string);
        if (this.userState != null) {
            if (list != null) {
                this.userState.save(string2, list);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getSoundFormatKey(String string) {
        return "BDC_soundFormat_" + string;
    }

    public void loadSoundFormat(CaptchaBase captchaBase, String string) {
        String string2 = this.getSoundFormatKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setSoundFormat((SoundFormat)this.userState.load(string2));
        }
    }

    public void saveSoundFormat(String string, SoundFormat soundFormat) {
        String string2 = this.getSoundFormatKey(string);
        if (this.userState != null) {
            if (soundFormat != null && !this.captchaConfiguration.getSoundFormat().name().equalsIgnoreCase(soundFormat.name())) {
                this.userState.save(string2, soundFormat);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getSoundRegenerationModeKey(String string) {
        return "BDC_soundRegenerationMode_" + string;
    }

    public void loadSoundRegenerationMode(CaptchaBase captchaBase, String string) {
        String string2 = this.getSoundRegenerationModeKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setSoundRegenerationMode((SoundRegenerationMode)this.userState.load(string2));
        }
    }

    public void saveSoundRegenerationMode(String string, SoundRegenerationMode soundRegenerationMode) {
        String string2 = this.getSoundRegenerationModeKey(string);
        if (this.userState != null) {
            if (soundRegenerationMode != null && !this.captchaConfiguration.getSoundRegenerationMode().name().equalsIgnoreCase(soundRegenerationMode.name())) {
                this.userState.save(string2, soundRegenerationMode);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getHelpLinkEnabledKey(String string) {
        return "BDC_helpLinkEnabled_" + string;
    }

    public void loadHelpLinkEnabled(CaptchaBase captchaBase, String string) {
        String string2 = this.getHelpLinkEnabledKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setHelpLinkEnabled(((Boolean)this.userState.load(string2)).booleanValue());
        }
    }

    public void saveHelpLinkEnabled(String string, boolean bl) {
        String string2 = this.getHelpLinkEnabledKey(string);
        if (this.userState != null) {
            if (this.captchaConfiguration.isHelpLinkEnabled() != bl) {
                this.userState.save(string2, bl);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getHelpLinkModeKey(String string) {
        return "BDC_helpLinkMode_" + string;
    }

    public void loadHelpLinkMode(CaptchaBase captchaBase, String string) {
        String string2 = this.getHelpLinkModeKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setHelpLinkMode((HelpLinkMode)this.userState.load(string2));
        }
    }

    public void saveHelpLinkMode(String string, HelpLinkMode helpLinkMode) {
        String string2 = this.getHelpLinkModeKey(string);
        if (this.userState != null) {
            if (helpLinkMode != null && !this.captchaConfiguration.getHelpLinkMode().name().equalsIgnoreCase(helpLinkMode.name())) {
                this.userState.save(string2, helpLinkMode);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getCodeCollectionKey(String string) {
        return "BDC_codeCollection_" + string;
    }

    public void loadCodeCollection(CaptchaBase captchaBase, String string) {
        String string2 = this.getCodeCollectionKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setCodeCollection((CodeCollection)this.userState.load(string2));
        }
    }

    public void saveCodeCollection(String string, CodeCollection codeCollection) {
        String string2 = this.getCodeCollectionKey(string);
        if (this.userState != null) {
            if (codeCollection != null) {
                this.userState.save(string2, codeCollection);
            } else {
                this.userState.remove(string2);
            }
        }
    }

    public String getImageTooltipKey(String string) {
        return "BDC_imageTooltip_" + string;
    }

    public void loadImageTooltip(Captcha captcha, String string) {
        String string2 = this.getImageTooltipKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captcha.setImageTooltip((String)this.userState.load(string2));
        }
    }

    public void saveImageTooltip(String string, String string2) {
        String string3 = this.getImageTooltipKey(string);
        if (this.userState != null) {
            if (StringHelper.hasValue((String)string2)) {
                this.userState.save(string3, string2);
            } else {
                this.userState.remove(string3);
            }
        }
    }

    public String getReloadTooltipKey(String string) {
        return "BDC_reloadTooltip_" + string;
    }

    public void loadReloadTooltip(Captcha captcha, String string) {
        String string2 = this.getReloadTooltipKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captcha.setReloadTooltip((String)this.userState.load(string2));
        }
    }

    public void saveReloadTooltip(String string, String string2) {
        String string3 = this.getReloadTooltipKey(string);
        if (this.userState != null) {
            if (StringHelper.hasValue((String)string2)) {
                this.userState.save(string3, string2);
            } else {
                this.userState.remove(string3);
            }
        }
    }

    public String getLocaleKey(String string) {
        return "BDC_locale_" + string;
    }

    public void loadLocale(CaptchaBase captchaBase, String string) {
        String string2 = this.getLocaleKey(string);
        if (this.userState != null && this.userState.contains(string2)) {
            captchaBase.setLocale((String)this.userState.load(string2));
        }
    }

    public void saveLocale(String string, String string2) {
        String string3 = this.getLocaleKey(string);
        if (this.userState != null) {
            if (this.captchaConfiguration.getLocale() != string2) {
                this.userState.save(string3, string2);
            } else {
                this.userState.remove(string3);
            }
        }
    }

    public boolean isValid(String string) {
        String string2 = this.getCodeCollectionKey(string);
        return this.userState != null && this.userState.contains(string2);
    }
}

