/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.web.servlet.configration;

import com.captcha.botdetect.CaptchaRandomization;
import com.captcha.botdetect.CodeStyle;
import com.captcha.botdetect.HelpLinkMode;
import com.captcha.botdetect.ImageFormat;
import com.captcha.botdetect.ImageSize;
import com.captcha.botdetect.ImageStyle;
import com.captcha.botdetect.SoundFormat;
import com.captcha.botdetect.SoundRegenerationMode;
import com.captcha.botdetect.SoundStyle;
import com.captcha.botdetect.configuration.ICaptchaConfiguration;
import com.captcha.botdetect.internal.infrastructure.text.StringHelper;
import com.captcha.botdetect.internal.support.CaptchaDefaults;
import com.captcha.botdetect.web.servlet.configration.BotDetectConfigurationParameter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaptchaConfiguration
implements ICaptchaConfiguration {
    private ServletContext context;
    private BotDetectConfigurationParameter configurationProvider;

    public CaptchaConfiguration(ServletContext servletContext) {
        this.context = servletContext;
        this.configurationProvider = new BotDetectConfigurationParameter(servletContext);
    }

    public Integer getCodeLength() {
        String string;
        Integer n = CaptchaDefaults.CODE_LENGTH;
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getCodeLengthString()))) {
            if (!string.contains("-")) {
                try {
                    Integer n2 = Integer.valueOf(string);
                    if (n2 >= 1 && n2 <= 15) {
                        n = n2;
                    }
                }
                catch (Exception exception) {}
            } else {
                String[] stringArray = string.split("-");
                if (stringArray.length > 1) {
                    try {
                        Integer n3 = Integer.valueOf(stringArray[0]);
                        Integer n4 = Integer.valueOf(stringArray[1]);
                        if (n4 >= n3) {
                            n = CaptchaRandomization.getRandomCodeLength((int)n3, (int)n4);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return n;
    }

    public CodeStyle getCodeStyle() {
        CodeStyle codeStyle;
        String string;
        CodeStyle codeStyle2 = CaptchaDefaults.CODE_STYLE;
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getCodeStyleString())) && (codeStyle = CodeStyle.parseString((String)string)) != null) {
            codeStyle2 = codeStyle;
        }
        return codeStyle2;
    }

    public List<String> getDisallowedCodeSubstrings() {
        String string;
        List<String> list = new ArrayList<String>();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getDisallowedCodeSubstringsString()))) {
            list = StringHelper.parseCsv((String)string);
        }
        return list;
    }

    public int getCodeTimeout() {
        int n = 1200;
        if (this.configurationProvider != null) {
            try {
                int n2 = this.configurationProvider.getCodeTimeout();
                if (n2 >= 30 && n2 <= 7200) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean isTestModeEnabled() {
        boolean bl = false;
        if (this.configurationProvider != null) {
            Boolean bl2 = this.configurationProvider.isTestModeEnabled();
            if (bl2 != null) {
                bl = bl2;
            }
            bl = false;
        }
        return bl;
    }

    public List<ImageStyle> getImageStyle() {
        List list;
        String string;
        List<Object> list2 = new ArrayList<ImageStyle>();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getImageStyleString())) && !(list = ImageStyle.parseCommaDelimitedString((String)string)).isEmpty()) {
            list2 = list;
        }
        return list2;
    }

    public ImageSize getImageSize() {
        int n = 250;
        int n2 = 50;
        if (this.configurationProvider != null) {
            int n3;
            try {
                n3 = this.configurationProvider.getImageWidth();
                if (CaptchaDefaults.MIN_IMAGE_SIZE.getWidth() <= n3 && CaptchaDefaults.MAX_IMAGE_SIZE.getWidth() >= n3) {
                    n = n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n3 = this.configurationProvider.getImageHeight();
                if (CaptchaDefaults.MIN_IMAGE_SIZE.getHeight() <= n3 && CaptchaDefaults.MAX_IMAGE_SIZE.getHeight() >= n3) {
                    n2 = n3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ImageSize(n, n2);
    }

    public ImageFormat getImageFormat() {
        ImageFormat imageFormat;
        ImageFormat imageFormat2 = CaptchaDefaults.IMAGE_FORMAT;
        if (this.configurationProvider != null && (imageFormat = this.configurationProvider.getImageFormat()) != null) {
            imageFormat2 = imageFormat;
        }
        return imageFormat2;
    }

    public Color getCustomDarkColor() {
        Color color = CaptchaDefaults.CUSTOM_DARK_COLOR;
        if (this.configurationProvider != null) {
            String string = this.configurationProvider.getCustomDarkColor();
            try {
                color = Color.decode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return color;
    }

    public Color getCustomLightColor() {
        Color color = CaptchaDefaults.CUSTOM_LIGHT_COLOR;
        if (this.configurationProvider != null) {
            String string = this.configurationProvider.getCustomLightColor();
            try {
                color = Color.decode(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return color;
    }

    public List<ImageStyle> getDisabledImageStyles() {
        List list;
        String string;
        List<Object> list2 = new ArrayList<ImageStyle>();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getDisabledImageStylesString())) && !(list = ImageStyle.parseCommaDelimitedString((String)string)).isEmpty()) {
            list2 = list;
        }
        return list2;
    }

    public boolean isSoundEnabled() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isSoundEnabled()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public List<SoundStyle> getSoundStyle() {
        List list;
        String string;
        List<Object> list2 = new ArrayList<SoundStyle>();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getSoundStyleString())) && !(list = SoundStyle.parseCommaDelimitedString((String)string)).isEmpty()) {
            list2 = list;
        }
        return list2;
    }

    public SoundFormat getSoundFormat() {
        SoundFormat soundFormat;
        SoundFormat soundFormat2 = CaptchaDefaults.SOUND_FORMAT;
        if (this.configurationProvider != null && (soundFormat = this.configurationProvider.getSoundFormat()) != null) {
            soundFormat2 = soundFormat;
        }
        return soundFormat2;
    }

    public SoundRegenerationMode getSoundRegenerationMode() {
        SoundRegenerationMode soundRegenerationMode;
        SoundRegenerationMode soundRegenerationMode2 = CaptchaDefaults.SOUND_REGENERATION_MODE;
        if (this.configurationProvider != null && (soundRegenerationMode = this.configurationProvider.getSoundRegenerationMode()) != null) {
            soundRegenerationMode2 = soundRegenerationMode;
        }
        return soundRegenerationMode2;
    }

    public String getSoundPackagesFolder() {
        String string;
        String string2 = CaptchaDefaults.SOUND_PACKAGES_FOLDER;
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getSoundPackagesFolder()))) {
            string2 = string;
        }
        return string2;
    }

    public boolean isWarnAboutMissingSoundPackages() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isWarnAboutMissingSoundPackages()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public List<SoundStyle> getDisabledSoundStyles() {
        List list;
        String string;
        List<Object> list2 = new ArrayList<SoundStyle>();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getDisabledSoundStylesString())) && !(list = SoundStyle.parseCommaDelimitedString((String)string)).isEmpty()) {
            list2 = list;
        }
        return list2;
    }

    public String getLocale() {
        String string;
        String string2 = "en-US";
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getLocale()))) {
            string2 = string;
        }
        return string2;
    }

    public String getImageTooltip() {
        String string;
        String string2 = CaptchaDefaults.LOCALIZATION.getImageTooltip();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getImageTooltip()))) {
            string2 = string;
        }
        return string2;
    }

    public String getSoundTooltip() {
        String string;
        String string2 = CaptchaDefaults.LOCALIZATION.getSoundTooltip();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getSoundTooltip()))) {
            string2 = string;
        }
        return string2;
    }

    public String getReloadTooltip() {
        String string;
        String string2 = CaptchaDefaults.LOCALIZATION.getReloadTooltip();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getReloadTooltip()))) {
            string2 = string;
        }
        return string2;
    }

    public String getHelpLinkText() {
        String string;
        String string2 = null;
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getHelpLinkText()))) {
            string2 = string;
        }
        return string2;
    }

    public String getHelpLinkUrl() {
        String string;
        String string2 = CaptchaDefaults.LOCALIZATION.getHelpLinkUrl();
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getHelpLinkUrl()))) {
            string2 = string;
        }
        return string2;
    }

    public boolean isReloadEnabled() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isReloadEnabled()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public Boolean isUseSmallIcons() {
        Boolean bl;
        Boolean bl2 = CaptchaDefaults.USE_SMALL_ICONS;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isUseSmallIcons()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public Boolean isUseHorizontalIcons() {
        Boolean bl;
        Boolean bl2 = CaptchaDefaults.USE_HORIZONTAL_ICONS;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isUseHorizontalIcons()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public String getSoundIconUrl() {
        String string;
        String string2 = CaptchaDefaults.SOUND_ICON_URL;
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getSoundIconUrl()))) {
            string2 = string;
        }
        return string2;
    }

    public String getReloadIconUrl() {
        String string;
        String string2 = CaptchaDefaults.RELOAD_ICON_URL;
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getReloadIconUrl()))) {
            string2 = string;
        }
        return string2;
    }

    public Integer getIconsDivWidth() {
        Integer n = CaptchaDefaults.ICONS_DIV_WIDTH;
        if (this.configurationProvider != null) {
            try {
                Integer n2;
                n = n2 = this.configurationProvider.getIconsDivWidth();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean isHelpLinkEnabled() {
        boolean bl = true;
        if (this.configurationProvider != null) {
            Boolean bl2 = this.configurationProvider.isHelpLinkEnabled();
            if (bl2 != null) {
                bl = bl2;
            }
            bl = true;
        }
        return bl;
    }

    public HelpLinkMode getHelpLinkMode() {
        HelpLinkMode helpLinkMode;
        HelpLinkMode helpLinkMode2 = CaptchaDefaults.HELP_LINK_MODE;
        if (this.configurationProvider != null && (helpLinkMode = this.configurationProvider.getHelpLinkMode()) != null) {
            helpLinkMode2 = helpLinkMode;
        }
        return helpLinkMode2;
    }

    public String getAdditionalCssClasses() {
        String string;
        String string2 = "";
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getAdditionalCssClasses()))) {
            string2 = string;
        }
        return string2;
    }

    public String getAdditionalInlineCss() {
        String string;
        String string2 = "";
        if (this.configurationProvider != null && StringHelper.hasValue((String)(string = this.configurationProvider.getAdditionalInlineCss()))) {
            string2 = string;
        }
        return string2;
    }

    public boolean isAddCssInclude() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isAddCssInclude()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public boolean isAddScriptInclude() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isAddScriptInclude()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public boolean isAddInitScript() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isAddInitScript()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public boolean isAutoUppercaseInput() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isAutoUppercaseInput()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public boolean isAutoFocusInput() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isAutoFocusInput()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public boolean isAutoClearInput() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isAutoClearInput()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public boolean isAutoReloadExpiredCaptchas() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isAutoReloadExpiredCaptchas()) != null) {
            bl2 = bl;
        }
        return this.isReloadEnabled() && bl2;
    }

    public int getAutoReloadTimeout() {
        int n = 7200;
        if (this.configurationProvider != null) {
            try {
                int n2;
                n = n2 = this.configurationProvider.getAutoReloadTimeout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public int getSoundStartDelay() {
        int n = 0;
        if (this.configurationProvider != null) {
            try {
                int n2;
                n = n2 = this.configurationProvider.getSoundStartDelay();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public boolean isRemoteScriptEnabled() {
        Boolean bl;
        boolean bl2 = true;
        if (this.configurationProvider != null && (bl = this.configurationProvider.isRemoteScriptEnabled()) != null) {
            bl2 = bl;
        }
        return bl2;
    }

    public String getRealPath() {
        return this.context.getRealPath("");
    }
}

