/*
 * Decompiled with CFR 0.152.
 */
package com.captcha.botdetect.web.servlet;

import java.net.InetAddress;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class HttpHelper {
    private HttpHelper() {
    }

    public static boolean isLocalRequest(HttpServletRequest httpServletRequest) {
        try {
            String string = httpServletRequest.getRemoteAddr();
            if (string.equalsIgnoreCase(InetAddress.getLocalHost().getHostAddress())) {
                return true;
            }
            for (InetAddress inetAddress : InetAddress.getAllByName("localhost")) {
                if (!string.equalsIgnoreCase(inetAddress.getHostAddress())) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static void smartDisallowCache(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean bl;
        boolean bl2 = bl = httpServletRequest.getParameter("e") != null;
        if (httpServletRequest.isSecure() || bl) {
            HttpHelper.disallowCacheSsl(httpServletResponse);
        } else {
            HttpHelper.disallowCache(httpServletResponse);
        }
    }

    public static void disallowCache(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        httpServletResponse.setHeader("Connection", "close");
        httpServletResponse.setDateHeader("Expires", -1L);
        httpServletResponse.setHeader("Pragma", "no-cache");
    }

    public static void disallowCacheSsl(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader("Cache-Control", "public");
        httpServletResponse.setDateHeader("Expires", -1L);
    }

    public static void badRequest(HttpServletResponse httpServletResponse, String string) {
        try {
            httpServletResponse.sendError(404, string);
        }
        catch (Exception exception) {
            System.err.println("HttpHelper.badRequest:" + exception);
        }
    }
}

